/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.lock;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.function.BiConsumer;
import com.hazelcast.util.function.Consumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientLockRetryWhenOwnerDiesTest
extends ClientTestSupport {
    private static long leaseTime = 120L;
    private static long waitTime = 120L;
    @Parameterized.Parameter
    public Consumer<HazelcastInstance> closePolicy;
    @Parameterized.Parameter(value=1)
    public BiConsumer<HazelcastInstance, String> lockPolicy;
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="closePolicy:{0}, lockPolicy:{1}")
    public static Collection<Object[]> parameters() {
        List<Consumer> closePolicies = Arrays.asList(new Shutdown(), new Terminate());
        List<BiConsumer> lockPolicies = Arrays.asList(new LockLock(), new LockLockLease(), new LockTryLockTimeout(), new LockTryLockTimeoutLease(), new MapLock(), new MapLockLease(), new MapTryLockTimeout(), new MapTryLockTimeoutLease());
        LinkedList<Object[]> objects = new LinkedList<Object[]>();
        for (Consumer closePolicy : closePolicies) {
            for (BiConsumer lockPolicy : lockPolicies) {
                objects.add(new Object[]{closePolicy, lockPolicy});
            }
        }
        return objects;
    }

    @After
    public void teardown() {
        this.factory.terminateAll();
    }

    @Test
    public void testKeyOwnerCloses_afterInvocationTimeout() throws Exception {
        HazelcastInstance keyOwner = this.factory.newHazelcastInstance();
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        ClientLockRetryWhenOwnerDiesTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{keyOwner, instance});
        ClientConfig clientConfig = new ClientConfig();
        long invocationTimeoutMillis = 1000L;
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), String.valueOf(TimeUnit.MILLISECONDS.toSeconds(invocationTimeoutMillis)));
        final HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.makeSureConnectedToServers(client, 2);
        final String key = ClientLockRetryWhenOwnerDiesTest.generateKeyOwnedBy((HazelcastInstance)keyOwner);
        ILock lock = client.getLock(key);
        lock.lock();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ClientLockRetryWhenOwnerDiesTest.this.lockPolicy.accept((Object)client, (Object)key);
                latch.countDown();
            }
        }).start();
        Thread.sleep(invocationTimeoutMillis * 2L);
        this.closePolicy.accept((Object)keyOwner);
        Member secondMember = instance.getCluster().getLocalMember();
        while (!secondMember.equals(client.getPartitionService().getPartition((Object)key).getOwner())) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)lock.isLocked());
        Assert.assertTrue((boolean)lock.isLockedByCurrentThread());
        Assert.assertTrue((boolean)lock.tryLock());
        lock.unlock();
        lock.unlock();
        ClientLockRetryWhenOwnerDiesTest.assertOpenEventually((CountDownLatch)latch);
    }

    static class MapTryLockTimeoutLease
    implements BiConsumer<HazelcastInstance, String> {
        MapTryLockTimeoutLease() {
        }

        public void accept(HazelcastInstance client, String key) {
            IMap map = client.getMap(key);
            try {
                map.tryLock((Object)key, waitTime, TimeUnit.SECONDS, leaseTime, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            map.unlock((Object)key);
        }

        public String toString() {
            return "MapTryLockTimeoutLease{}";
        }
    }

    static class MapTryLockTimeout
    implements BiConsumer<HazelcastInstance, String> {
        MapTryLockTimeout() {
        }

        public void accept(HazelcastInstance client, String key) {
            IMap map = client.getMap(key);
            try {
                map.tryLock((Object)key, waitTime, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            map.unlock((Object)key);
        }

        public String toString() {
            return "MapTryLockTimeout{}";
        }
    }

    static class MapLockLease
    implements BiConsumer<HazelcastInstance, String> {
        MapLockLease() {
        }

        public void accept(HazelcastInstance client, String key) {
            IMap map = client.getMap(key);
            map.lock((Object)key, leaseTime, TimeUnit.SECONDS);
            map.unlock((Object)key);
        }
    }

    static class MapLock
    implements BiConsumer<HazelcastInstance, String> {
        MapLock() {
        }

        public void accept(HazelcastInstance client, String key) {
            IMap map = client.getMap(key);
            map.lock((Object)key);
            map.unlock((Object)key);
        }

        public String toString() {
            return "MapLock{}";
        }
    }

    static class LockTryLockTimeoutLease
    implements BiConsumer<HazelcastInstance, String> {
        LockTryLockTimeoutLease() {
        }

        public void accept(HazelcastInstance client, String key) {
            ILock lock = client.getLock(key);
            try {
                lock.tryLock(waitTime, TimeUnit.SECONDS, leaseTime, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            lock.unlock();
        }

        public String toString() {
            return "LockTryLockTimeoutLease{}";
        }
    }

    static class LockTryLockTimeout
    implements BiConsumer<HazelcastInstance, String> {
        LockTryLockTimeout() {
        }

        public void accept(HazelcastInstance client, String key) {
            ILock lock = client.getLock(key);
            try {
                lock.tryLock(waitTime, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            lock.unlock();
        }

        public String toString() {
            return "LockTryLockTimeout{}";
        }
    }

    static class LockLockLease
    implements BiConsumer<HazelcastInstance, String> {
        LockLockLease() {
        }

        public void accept(HazelcastInstance client, String key) {
            ILock lock = client.getLock(key);
            lock.lock(leaseTime, TimeUnit.SECONDS);
            lock.unlock();
        }

        public String toString() {
            return "LockLockLease{}";
        }
    }

    static class LockLock
    implements BiConsumer<HazelcastInstance, String> {
        LockLock() {
        }

        public void accept(HazelcastInstance client, String key) {
            ILock lock = client.getLock(key);
            lock.lock();
            lock.unlock();
        }

        public String toString() {
            return "LockLock{}";
        }
    }

    static class Terminate
    implements Consumer<HazelcastInstance> {
        Terminate() {
        }

        public void accept(HazelcastInstance hazelcastInstance) {
            hazelcastInstance.getLifecycleService().terminate();
        }

        public String toString() {
            return "Terminate{}";
        }
    }

    static class Shutdown
    implements Consumer<HazelcastInstance> {
        Shutdown() {
        }

        public void accept(HazelcastInstance hazelcastInstance) {
            hazelcastInstance.shutdown();
        }

        public String toString() {
            return "Shutdown{}";
        }
    }
}

