/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.lock;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientLockTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void teardown() {
        this.factory.terminateAll();
    }

    @Test
    public void testLock() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.lock();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                if (!lock.tryLock()) {
                    latch.countDown();
                }
            }
        }.start();
        ClientLockTest.assertOpenEventually((CountDownLatch)latch);
        lock.forceUnlock();
    }

    @Test
    public void testTryLockShouldSucceedWhenLockTTLisFinished() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        int lockTimeout = 3;
        lock.lock(3L, TimeUnit.SECONDS);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (lock.tryLock((long)(3 + HazelcastTestSupport.ASSERT_TRUE_EVENTUALLY_TIMEOUT / 2), TimeUnit.SECONDS)) {
                        latch.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        ClientLockTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testTryLock() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        Assert.assertTrue((boolean)lock.tryLock(2L, TimeUnit.SECONDS));
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (!lock.tryLock(2L, TimeUnit.SECONDS)) {
                        latch.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Assert.assertTrue((boolean)latch.await(100L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)lock.isLocked());
        final CountDownLatch latch2 = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (lock.tryLock(20L, TimeUnit.SECONDS)) {
                        latch2.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread.sleep(1000L);
        lock.unlock();
        Assert.assertTrue((boolean)latch2.await(100L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)lock.isLocked());
        lock.forceUnlock();
    }

    @Test
    public void testTryLockwithZeroTTL() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        ILock lock = hz.getLock(ClientLockTest.randomName());
        boolean lockWithZeroTTL = lock.tryLock(0L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)lockWithZeroTTL);
    }

    @Test
    public void testTryLockwithZeroTTLWithExistingLock() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.lock();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (!lock.tryLock(0L, TimeUnit.SECONDS)) {
                        latch.countDown();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        ClientLockTest.assertOpenEventually((CountDownLatch)latch);
        lock.forceUnlock();
    }

    @Test
    public void testForceUnlock() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.lock();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                lock.forceUnlock();
                latch.countDown();
            }
        }.start();
        Assert.assertTrue((boolean)latch.await(100L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testStats() throws InterruptedException {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.lock();
        Assert.assertTrue((boolean)lock.isLocked());
        Assert.assertTrue((boolean)lock.isLockedByCurrentThread());
        Assert.assertEquals((long)1L, (long)lock.getLockCount());
        lock.unlock();
        Assert.assertFalse((boolean)lock.isLocked());
        Assert.assertEquals((long)0L, (long)lock.getLockCount());
        Assert.assertEquals((long)-1L, (long)lock.getRemainingLeaseTime());
        lock.lock(1L, TimeUnit.MINUTES);
        Assert.assertTrue((boolean)lock.isLocked());
        Assert.assertTrue((boolean)lock.isLockedByCurrentThread());
        Assert.assertEquals((long)1L, (long)lock.getLockCount());
        Assert.assertTrue((lock.getRemainingLeaseTime() > 30000L ? 1 : 0) != 0);
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                Assert.assertTrue((boolean)lock.isLocked());
                Assert.assertFalse((boolean)lock.isLockedByCurrentThread());
                Assert.assertEquals((long)1L, (long)lock.getLockCount());
                Assert.assertTrue((lock.getRemainingLeaseTime() > 30000L ? 1 : 0) != 0);
                latch.countDown();
            }
        }.start();
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
    }

    @Test
    public void testObtainLock_FromDifferentClients() throws InterruptedException {
        this.factory.newHazelcastInstance();
        String name = ClientLockTest.randomName();
        HazelcastInstance clientA = this.factory.newHazelcastClient();
        ILock lockA = clientA.getLock(name);
        lockA.lock();
        HazelcastInstance clientB = this.factory.newHazelcastClient();
        ILock lockB = clientB.getLock(name);
        boolean lockObtained = lockB.tryLock();
        Assert.assertFalse((String)"Lock obtained by 2 client ", (boolean)lockObtained);
    }

    @Test(timeout=60000L)
    public void testTryLockLeaseTime_whenLockFree() throws InterruptedException {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        ILock lock = hz.getLock(ClientLockTest.randomName());
        boolean isLocked = lock.tryLock(1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)isLocked);
    }

    @Test(timeout=60000L)
    public void testTryLockLeaseTime_whenLockAcquiredByOther() throws InterruptedException {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        Thread thread = new Thread(){

            @Override
            public void run() {
                lock.lock();
            }
        };
        thread.start();
        thread.join();
        boolean isLocked = lock.tryLock(1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)isLocked);
    }

    @Test
    public void testTryLockLeaseTime_lockIsReleasedEventually() throws InterruptedException {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.tryLock(1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        ClientLockTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)lock.isLocked());
            }
        }, (long)30L);
    }

    @Test
    public void testMaxLockLeaseTime() {
        Config config = new Config();
        config.setProperty(GroupProperty.LOCK_MAX_LEASE_TIME_SECONDS.getName(), "1");
        this.factory.newHazelcastInstance(config);
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.lock();
        ClientLockTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((String)"Lock should be released after lease expires!", (boolean)lock.isLocked());
            }
        }, (long)30L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLockFail_whenGreaterThanMaxLeaseTimeUsed() {
        Config config = new Config();
        config.setProperty(GroupProperty.LOCK_MAX_LEASE_TIME_SECONDS.getName(), "1");
        this.factory.newHazelcastInstance(config);
        HazelcastInstance hz = this.factory.newHazelcastClient();
        ILock lock = hz.getLock(ClientLockTest.randomName());
        lock.lock(10L, TimeUnit.SECONDS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLockWithZeroTTL() {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        ILock lock = hz.getLock(ClientLockTest.randomName());
        long ttl = 0L;
        lock.lock(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testLockLease_withStringPartitionAwareName() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName() + "@hazelcast");
        ClientLockTest.spawn((Runnable)new Runnable(){

            @Override
            public void run() {
                lock.lock(5L, TimeUnit.SECONDS);
            }
        }).get();
        Assert.assertTrue((String)"Lock should have been released after lease expires", (boolean)lock.tryLock(2L, TimeUnit.MINUTES));
    }

    @Test
    public void testTryLockLease_withStringPartitionAwareName() throws Exception {
        this.factory.newHazelcastInstance();
        HazelcastInstance hz = this.factory.newHazelcastClient();
        final ILock lock = hz.getLock(ClientLockTest.randomName() + "@hazelcast");
        ClientLockTest.spawn((Runnable)new Runnable(){

            @Override
            public void run() {
                long timeout = 10L;
                long lease = 5L;
                try {
                    Assert.assertTrue((boolean)lock.tryLock(timeout, TimeUnit.SECONDS, lease, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    throw ExceptionUtil.rethrow((Throwable)e);
                }
            }
        }).get();
        Assert.assertTrue((String)"Lock should have been released after lease expires", (boolean)lock.tryLock(2L, TimeUnit.MINUTES));
    }
}

