/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapLoader;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryLoadedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientEntryLoadedListenerTest
extends HazelcastTestSupport {
    private static final TestHazelcastFactory FACTORY = new TestHazelcastFactory();
    private static HazelcastInstance client;

    @BeforeClass
    public static void setUp() {
        Config config = new Config();
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setInitialLoadMode(MapStoreConfig.InitialLoadMode.EAGER);
        mapStoreConfig.setClassName(TestMapLoader.class.getName());
        config.getMapConfig("default").setMapStoreConfig(mapStoreConfig);
        MapStoreConfig noInitialLoading = new MapStoreConfig();
        noInitialLoading.setEnabled(true);
        noInitialLoading.setClassName(TestMapLoaderWithoutInitialLoad.class.getName());
        config.getMapConfig("noInitialLoading*").setMapStoreConfig(noInitialLoading);
        FACTORY.newHazelcastInstance(config);
        FACTORY.newHazelcastInstance(config);
        client = FACTORY.newHazelcastClient();
    }

    @AfterClass
    public static void tearDown() {
        FACTORY.shutdownAll();
    }

    @Test
    public void load_listener_notified_when_containsKey_loads_from_map_loader() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_test_containsKey");
        map.addEntryListener((MapListener)new EntryLoadedListener<Integer, Integer>(){

            public void entryLoaded(EntryEvent<Integer, Integer> event) {
                loadEventCount.incrementAndGet();
            }
        }, true);
        map.containsKey((Object)1);
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)loadEventCount.get());
            }
        }, (long)10L);
    }

    @Test
    public void load_listener_notified_when_putIfAbsent_loads_from_map_loader() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_test_putIfAbsent");
        map.addEntryListener((MapListener)new EntryLoadedListener<Integer, Integer>(){

            public void entryLoaded(EntryEvent<Integer, Integer> event) {
                loadEventCount.incrementAndGet();
            }
        }, true);
        map.putIfAbsent((Object)1, (Object)100);
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)loadEventCount.get());
            }
        });
    }

    @Test
    public void load_listener_notified_when_get_loads_from_map_loader() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_test_get");
        map.addEntryListener((MapListener)new EntryLoadedListener<Integer, Integer>(){

            public void entryLoaded(EntryEvent<Integer, Integer> event) {
                loadEventCount.incrementAndGet();
            }
        }, true);
        map.get((Object)1);
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)loadEventCount.get());
            }
        });
    }

    @Test
    public void load_listener_notified_when_get_after_evict() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_load_listener_notified_when_get_after_evict");
        map.addEntryListener((MapListener)new EntryLoadedListener<Integer, Integer>(){

            public void entryLoaded(EntryEvent<Integer, Integer> event) {
                loadEventCount.incrementAndGet();
            }
        }, true);
        map.put((Object)1, (Object)1);
        map.evict((Object)1);
        map.get((Object)1);
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)loadEventCount.get());
            }
        }, (long)5L);
    }

    @Test
    public void load_listener_notified_when_getAll_loads_from_map_loader() {
        final ConcurrentLinkedQueue entryEvents = new ConcurrentLinkedQueue();
        IMap map = client.getMap("noInitialLoading_test_getAll");
        map.addEntryListener((MapListener)new EntryLoadedListener<Integer, Integer>(){

            public void entryLoaded(EntryEvent<Integer, Integer> event) {
                entryEvents.add(event);
            }
        }, true);
        final List<Integer> keyList = Arrays.asList(1, 2, 3, 4, 5);
        map.getAll(new HashSet<Integer>(keyList));
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)keyList.size(), (long)entryEvents.size());
                for (EntryEvent entryEvent : entryEvents) {
                    Assert.assertEquals((Object)EntryEventType.LOADED, (Object)entryEvent.getEventType());
                }
            }
        });
    }

    @Test
    public void load_listener_notified_when_read_only_entry_processor_loads_from_map_loader() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_test_read_only_ep");
        map.addEntryListener((MapListener)new EntryLoadedListener<Integer, Integer>(){

            public void entryLoaded(EntryEvent<Integer, Integer> event) {
                loadEventCount.incrementAndGet();
            }
        }, true);
        map.executeOnKey((Object)1, (EntryProcessor)new Reader());
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)loadEventCount.get());
            }
        });
    }

    @Test
    public void add_listener_not_notified_when_read_only_entry_processor_loads_from_map_loader() {
        final AtomicInteger addEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_test_read_only_ep_not_notified");
        map.addEntryListener((MapListener)new EntryAddedListener<Integer, Integer>(){

            public void entryAdded(EntryEvent<Integer, Integer> event) {
                addEventCount.incrementAndGet();
            }
        }, true);
        map.executeOnKey((Object)1, (EntryProcessor)new Reader());
        ClientEntryLoadedListenerTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)addEventCount.get());
            }
        }, (long)3L);
    }

    @Test
    public void load_and_update_listener_notified_when_updater_entry_processor_loads_from_map_loader() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        final AtomicInteger updateEventCount = new AtomicInteger();
        IMap map = client.getMap("noInitialLoading_test_updater_ep");
        map.addEntryListener((MapListener)new LoadAndUpdateListener(loadEventCount, updateEventCount), true);
        for (int i = 0; i < 10; ++i) {
            map.executeOnKey((Object)i, (EntryProcessor)new Updater());
        }
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)10L, (long)loadEventCount.get());
                Assert.assertEquals((long)10L, (long)updateEventCount.get());
            }
        });
    }

    @Test
    public void load_listener_notified_but_add_listener_not_notified_after_loadAll() {
        final AtomicInteger loadEventCount = new AtomicInteger();
        final AtomicInteger addEventCount = new AtomicInteger();
        IMap map = client.getMap("load_listener_notified_but_add_listener_not_notified_after_loadAll");
        map.clear();
        LoadAndAddListener listener = new LoadAndAddListener(loadEventCount, addEventCount);
        map.addEntryListener((MapListener)listener, true);
        map.addEntryListener((MapListener)new LoadAndAddListener(new AtomicInteger(), new AtomicInteger()), true);
        map.addEntryListener((MapListener)new LoadAndAddListener(new AtomicInteger(), new AtomicInteger()), true);
        map.loadAll(true);
        ClientEntryLoadedListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)5L, (long)loadEventCount.get());
            }
        });
        ClientEntryLoadedListenerTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)addEventCount.get());
            }
        }, (long)3L);
        ClientEntryLoadedListenerTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)5L, (long)loadEventCount.get());
            }
        }, (long)3L);
    }

    @Test
    public void add_listener_not_notified_after_loadAll() {
        final AtomicInteger addEventCount = new AtomicInteger();
        IMap map = client.getMap("add_listener_notified_after_loadAll");
        map.clear();
        AddListener listener = new AddListener(addEventCount);
        map.addEntryListener((MapListener)listener, true);
        map.loadAll(true);
        ClientEntryLoadedListenerTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)addEventCount.get());
            }
        }, (long)5L);
    }

    public static class Reader
    extends AbstractEntryProcessor<Integer, Integer> {
        public Object process(Map.Entry<Integer, Integer> entry) {
            return entry.getValue();
        }
    }

    public static class Updater
    extends AbstractEntryProcessor<Integer, Integer> {
        public Object process(Map.Entry<Integer, Integer> entry) {
            entry.setValue(entry.getValue() + 1);
            return entry.getValue();
        }
    }

    public static class TestMapLoaderWithoutInitialLoad
    extends TestMapLoader {
        @Override
        public Iterable<Integer> loadAllKeys() {
            return Collections.emptyList();
        }
    }

    public static class TestMapLoader
    implements MapLoader<Integer, Integer> {
        AtomicInteger sequence = new AtomicInteger();

        public Integer load(Integer key) {
            return this.sequence.incrementAndGet();
        }

        public Map<Integer, Integer> loadAll(Collection<Integer> keys) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (Integer key : keys) {
                map.put(key, this.sequence.incrementAndGet());
            }
            return map;
        }

        public Iterable<Integer> loadAllKeys() {
            return Arrays.asList(1, 2, 3, 4, 5);
        }
    }

    static class AddListener
    implements EntryAddedListener<Integer, Integer> {
        private final AtomicInteger addEventCount;

        public AddListener(AtomicInteger addEventCount) {
            this.addEventCount = addEventCount;
        }

        public void entryAdded(EntryEvent<Integer, Integer> event) {
            this.addEventCount.incrementAndGet();
        }
    }

    static class LoadAndUpdateListener
    implements EntryLoadedListener<Integer, Integer>,
    EntryUpdatedListener<Integer, Integer> {
        private final AtomicInteger loadEventCount;
        private final AtomicInteger updateEventCount;

        public LoadAndUpdateListener(AtomicInteger loadEventCount, AtomicInteger updateEventCount) {
            this.loadEventCount = loadEventCount;
            this.updateEventCount = updateEventCount;
        }

        public void entryLoaded(EntryEvent<Integer, Integer> event) {
            this.loadEventCount.incrementAndGet();
        }

        public void entryUpdated(EntryEvent<Integer, Integer> event) {
            this.updateEventCount.incrementAndGet();
        }
    }

    static class LoadAndAddListener
    implements EntryLoadedListener<Integer, Integer>,
    EntryAddedListener<Integer, Integer> {
        private final AtomicInteger loadEventCount;
        private final AtomicInteger addEventCount;

        public LoadAndAddListener(AtomicInteger loadEventCount, AtomicInteger addEventCount) {
            this.loadEventCount = loadEventCount;
            this.addEventCount = addEventCount;
        }

        public void entryLoaded(EntryEvent<Integer, Integer> event) {
            this.loadEventCount.incrementAndGet();
        }

        public void entryAdded(EntryEvent<Integer, Integer> event) {
            this.addEventCount.incrementAndGet();
        }
    }
}

