/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.LocalIndexStatsTest;
import com.hazelcast.monitor.LocalIndexStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalIndexStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.PerIndexStats;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientIndexStatsTest
extends LocalIndexStatsTest {
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    protected IMap map1;
    protected IMap map2;
    protected IMap noStatsMap1;
    protected IMap noStatsMap2;

    @Parameterized.Parameters(name="format:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.OBJECT}, {InMemoryFormat.BINARY});
    }

    protected HazelcastInstance createInstance(Config config) {
        HazelcastInstance member1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance member2 = this.hazelcastFactory.newHazelcastInstance(config);
        this.map1 = member1.getMap(this.mapName);
        this.map2 = member2.getMap(this.mapName);
        this.noStatsMap1 = member1.getMap(this.noStatsMapName);
        this.noStatsMap2 = member2.getMap(this.noStatsMapName);
        return this.hazelcastFactory.newHazelcastClient(new ClientConfig());
    }

    @After
    public void after() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testQueryCounting_WhenPartitionPredicateIsUsed() {
        this.map.addIndex("this", false);
        for (int i = 0; i < 100; ++i) {
            this.map.put((Object)i, (Object)i);
        }
        this.map.entrySet((Predicate)new PartitionPredicate((Object)10, Predicates.equal((String)"this", (Comparable)Integer.valueOf(10))));
        Assert.assertTrue((this.map1.getLocalMapStats().getQueryCount() == 1L && this.map2.getLocalMapStats().getQueryCount() == 0L || this.map1.getLocalMapStats().getQueryCount() == 0L && this.map2.getLocalMapStats().getQueryCount() == 1L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.map1.getLocalMapStats().getIndexedQueryCount());
        Assert.assertEquals((long)0L, (long)this.map2.getLocalMapStats().getIndexedQueryCount());
        Assert.assertEquals((long)0L, (long)((LocalIndexStats)this.map1.getLocalMapStats().getIndexStats().get("this")).getQueryCount());
        Assert.assertEquals((long)0L, (long)((LocalIndexStats)this.map2.getLocalMapStats().getIndexStats().get("this")).getQueryCount());
    }

    @Test
    @Ignore
    public void testAverageQuerySelectivityCalculation_WhenSomePartitionsAreEmpty() {
    }

    protected LocalMapStats stats() {
        return ClientIndexStatsTest.combineStats(this.map1, this.map2);
    }

    protected LocalMapStats noStats() {
        return ClientIndexStatsTest.combineStats(this.noStatsMap1, this.noStatsMap2);
    }

    private static LocalMapStats combineStats(IMap map1, IMap map2) {
        LocalMapStats stats1 = map1.getLocalMapStats();
        LocalMapStats stats2 = map2.getLocalMapStats();
        ArrayList allIndexes = new ArrayList();
        allIndexes.addAll(ClientIndexStatsTest.getAllIndexes((IMap)map1));
        allIndexes.addAll(ClientIndexStatsTest.getAllIndexes((IMap)map2));
        LocalMapStatsImpl combinedStats = new LocalMapStatsImpl();
        Assert.assertEquals((long)stats1.getQueryCount(), (long)stats2.getQueryCount());
        combinedStats.setQueryCount(stats1.getQueryCount());
        Assert.assertEquals((long)stats1.getIndexedQueryCount(), (long)stats2.getIndexedQueryCount());
        combinedStats.setIndexedQueryCount(stats1.getIndexedQueryCount());
        Assert.assertEquals((long)stats1.getIndexStats().size(), (long)stats2.getIndexStats().size());
        HashMap combinedIndexStatsMap = new HashMap();
        for (Map.Entry indexEntry : stats1.getIndexStats().entrySet()) {
            LocalIndexStats indexStats1 = (LocalIndexStats)indexEntry.getValue();
            LocalIndexStats indexStats2 = (LocalIndexStats)stats2.getIndexStats().get(indexEntry.getKey());
            Assert.assertNotNull((Object)indexStats2);
            LocalIndexStatsImpl combinedIndexStats = new LocalIndexStatsImpl();
            Assert.assertEquals((long)indexStats1.getHitCount(), (long)indexStats2.getHitCount());
            combinedIndexStats.setHitCount(indexStats1.getHitCount());
            Assert.assertEquals((long)indexStats1.getQueryCount(), (long)indexStats2.getQueryCount());
            combinedIndexStats.setQueryCount(indexStats1.getQueryCount());
            combinedIndexStats.setAverageHitLatency((indexStats1.getAverageHitLatency() + indexStats2.getAverageHitLatency()) / 2L);
            long totalHitCount = 0L;
            double totalNormalizedHitCardinality = 0.0;
            for (Indexes indexes : allIndexes) {
                PerIndexStats perIndexStats = indexes.getIndex((String)indexEntry.getKey()).getPerIndexStats();
                totalHitCount += perIndexStats.getHitCount();
                totalNormalizedHitCardinality += perIndexStats.getTotalNormalizedHitCardinality();
            }
            combinedIndexStats.setAverageHitSelectivity(totalHitCount == 0L ? 0.0 : 1.0 - totalNormalizedHitCardinality / (double)totalHitCount);
            combinedIndexStats.setInsertCount(indexStats1.getInsertCount() + indexStats2.getInsertCount());
            combinedIndexStats.setTotalInsertLatency(indexStats1.getTotalInsertLatency() + indexStats2.getTotalInsertLatency());
            combinedIndexStats.setUpdateCount(indexStats1.getUpdateCount() + indexStats2.getUpdateCount());
            combinedIndexStats.setTotalUpdateLatency(indexStats1.getTotalUpdateLatency() + indexStats2.getTotalUpdateLatency());
            combinedIndexStats.setRemoveCount(indexStats1.getRemoveCount() + indexStats2.getRemoveCount());
            combinedIndexStats.setTotalRemoveLatency(indexStats1.getTotalRemoveLatency() + indexStats2.getTotalRemoveLatency());
            combinedIndexStats.setMemoryCost(indexStats1.getMemoryCost() + indexStats2.getMemoryCost());
            combinedIndexStatsMap.put(indexEntry.getKey(), combinedIndexStats);
        }
        combinedStats.setIndexStats(combinedIndexStatsMap);
        return combinedStats;
    }
}

