/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.map.helpers.GenericEvent;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MapStoreAdapter;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.NamedPortable;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SampleTestObjects;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.query.impl.predicates.InstanceOfPredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private TestMapStore flushMapStore = new TestMapStore();
    private TestMapStore transientMapStore = new TestMapStore();
    private HazelcastInstance server;
    private HazelcastInstance client;

    @Before
    public void setup() {
        Config config = this.getConfig();
        config.getMapConfig("flushMap").setMapStoreConfig(new MapStoreConfig().setWriteDelaySeconds(1000).setImplementation((Object)this.flushMapStore));
        config.getMapConfig("putTransientMap").setMapStoreConfig(new MapStoreConfig().setWriteDelaySeconds(1000).setImplementation((Object)this.transientMapStore));
        this.server = this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.getClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(1, new PortableFactory(){

            public Portable create(int classId) {
                return new NamedPortable();
            }
        });
        this.client = this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testIssue537() {
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch nullLatch = new CountDownLatch(2);
        EntryAdapter<String, GenericEvent> listener = new EntryAdapter<String, GenericEvent>(){

            public void entryAdded(EntryEvent<String, GenericEvent> event) {
                latch.countDown();
            }

            public void entryEvicted(EntryEvent<String, GenericEvent> event) {
                GenericEvent value = (GenericEvent)event.getValue();
                GenericEvent oldValue = (GenericEvent)event.getOldValue();
                if (value == null) {
                    nullLatch.countDown();
                }
                if (oldValue != null) {
                    nullLatch.countDown();
                }
                latch.countDown();
            }
        };
        IMap map = this.createMap();
        String id = map.addEntryListener((EntryListener)listener, true);
        map.put((Object)"key1", (Object)new GenericEvent("value1"), 2L, TimeUnit.SECONDS);
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        ClientMapTest.assertOpenEventually((CountDownLatch)nullLatch);
        map.removeEntryListener(id);
        map.put((Object)"key2", (Object)new GenericEvent("value2"));
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testSerializationServiceNullClassLoaderProblem() {
        IMap map = this.client.getMap("test");
        map.values((Predicate)new InstanceOfPredicate(SampleTestObjects.PortableEmployee.class));
    }

    @Test
    public void testContains() {
        IMap map = this.createMap();
        this.fillMap(map);
        Assert.assertFalse((boolean)map.containsKey((Object)"key10"));
        Assert.assertTrue((boolean)map.containsKey((Object)"key1"));
        Assert.assertFalse((boolean)map.containsValue((Object)"value10"));
        Assert.assertTrue((boolean)map.containsValue((Object)"value1"));
    }

    @Test
    public void testGet() {
        IMap map = this.createMap();
        this.fillMap(map);
        for (int i = 0; i < 10; ++i) {
            String actual = (String)map.get((Object)("key" + i));
            Assert.assertEquals((Object)("value" + i), (Object)actual);
        }
    }

    @Test
    public void testRemoveAndDelete() {
        IMap map = this.createMap();
        this.fillMap(map);
        Assert.assertNull((Object)map.remove((Object)"key10"));
        map.delete((Object)"key9");
        Assert.assertEquals((long)9L, (long)map.size());
        for (int i = 0; i < 9; ++i) {
            String actual = (String)map.remove((Object)("key" + i));
            Assert.assertEquals((Object)("value" + i), (Object)actual);
        }
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testRemoveIfSame() {
        IMap map = this.createMap();
        this.fillMap(map);
        Assert.assertFalse((boolean)map.remove((Object)"key2", (Object)"value"));
        Assert.assertEquals((long)10L, (long)map.size());
        Assert.assertTrue((boolean)map.remove((Object)"key2", (Object)"value2"));
        Assert.assertEquals((long)9L, (long)map.size());
    }

    @Test
    public void testFlush() {
        this.flushMapStore.latch = new CountDownLatch(1);
        IMap map = this.client.getMap("flushMap");
        map.put((Object)1L, (Object)"value");
        map.flush();
        ClientMapTest.assertOpenEventually((CountDownLatch)this.flushMapStore.latch);
    }

    @Test
    public void testGetAllPutAll() {
        HashMap<Integer, Integer> expectedMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            expectedMap.put(i, i);
        }
        IMap map = this.createMap();
        map.putAll(expectedMap);
        Assert.assertEquals((long)map.size(), (long)100L);
        for (int i = 0; i < 100; ++i) {
            int actual = (Integer)map.get((Object)i);
            Assert.assertEquals((long)i, (long)actual);
        }
        HashSet<Integer> keySet = new HashSet<Integer>();
        keySet.add(1);
        keySet.add(3);
        Map getAllMap = map.getAll(keySet);
        Assert.assertEquals((long)2L, (long)getAllMap.size());
        Assert.assertEquals((Object)1, getAllMap.get(1));
        Assert.assertEquals((Object)3, getAllMap.get(3));
    }

    @Test
    public void testPutAllWithTooManyEntries() {
        HashMap<Integer, Integer> expectedMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedMap.put(i, i);
        }
        IMap map = this.createMap();
        map.putAll(expectedMap);
        Assert.assertEquals((long)map.size(), (long)1000L);
        for (int i = 0; i < 1000; ++i) {
            int actual = (Integer)map.get((Object)i);
            Assert.assertEquals((long)i, (long)actual);
        }
    }

    @Test
    public void testAsyncGet() throws Exception {
        IMap map = this.createMap();
        this.fillMap(map);
        ICompletableFuture future = map.getAsync((Object)"key1");
        Assert.assertEquals((Object)"value1", future.get());
    }

    @Test
    public void testAsyncPut() throws Exception {
        IMap map = this.createMap();
        this.fillMap(map);
        ICompletableFuture future = map.putAsync((Object)"key3", (Object)"value");
        Assert.assertEquals((Object)"value3", future.get());
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key3"));
    }

    @Test
    public void testAsyncPutWithTtl() throws Exception {
        IMap map = this.createMap();
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((EntryListener)new EntryAdapter<String, String>(){

            public void entryEvicted(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, true);
        ICompletableFuture future = map.putAsync((Object)"key", (Object)"value1", 3L, TimeUnit.SECONDS);
        Assert.assertNull(future.get());
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key"));
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)map.get((Object)"key"));
    }

    @Test
    public void testAsyncPutWithMaxIdle() throws Exception {
        IMap map = this.createMap();
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((EntryListener)new EntryAdapter<String, String>(){

            public void entryEvicted(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, true);
        ICompletableFuture future = map.putAsync((Object)"key", (Object)"value1", 0L, TimeUnit.SECONDS, 3L, TimeUnit.SECONDS);
        Assert.assertNull(future.get());
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key"));
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)map.get((Object)"key"));
    }

    @Test
    public void testAsyncSet() throws Exception {
        IMap map = this.createMap();
        this.fillMap(map);
        ICompletableFuture future = map.setAsync((Object)"key3", (Object)"value");
        future.get();
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key3"));
    }

    @Test
    public void testAsyncSetWithTtl() throws Exception {
        IMap map = this.createMap();
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((MapListener)new EntryEvictedListener<String, String>(){

            public void entryEvicted(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, true);
        ICompletableFuture future = map.setAsync((Object)"key", (Object)"value1", 3L, TimeUnit.SECONDS);
        future.get();
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key"));
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)map.get((Object)"key"));
    }

    @Test
    public void testAsyncSetWithMaxIdle() throws Exception {
        IMap map = this.createMap();
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((MapListener)new EntryEvictedListener<String, String>(){

            public void entryEvicted(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, true);
        ICompletableFuture future = map.setAsync((Object)"key", (Object)"value1", 0L, TimeUnit.SECONDS, 3L, TimeUnit.SECONDS);
        future.get();
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key"));
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)map.get((Object)"key"));
    }

    @Test
    public void testAsyncRemove() throws Exception {
        IMap map = this.createMap();
        this.fillMap(map);
        ICompletableFuture future = map.removeAsync((Object)"key4");
        Assert.assertEquals((Object)"value4", future.get());
        Assert.assertEquals((long)9L, (long)map.size());
    }

    @Test
    public void testTryPutRemove() throws Exception {
        final IMap map = this.createMap();
        Assert.assertTrue((boolean)map.tryPut((Object)"key1", (Object)"value1", 1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)map.tryPut((Object)"key2", (Object)"value2", 1L, TimeUnit.SECONDS));
        map.lock((Object)"key1");
        map.lock((Object)"key2");
        final CountDownLatch latch = new CountDownLatch(2);
        new Thread(){

            @Override
            public void run() {
                boolean result = map.tryPut((Object)"key1", (Object)"value3", 1L, TimeUnit.SECONDS);
                if (!result) {
                    latch.countDown();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                boolean result = map.tryRemove((Object)"key2", 1L, TimeUnit.SECONDS);
                if (!result) {
                    latch.countDown();
                }
            }
        }.start();
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)map.get((Object)"key2"));
        map.forceUnlock((Object)"key1");
        map.forceUnlock((Object)"key2");
    }

    @Test
    public void testPutTtl() {
        final IMap map = this.createMap();
        map.put((Object)"key1", (Object)"value1", 10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)map.get((Object)"key1"));
        ClientMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)map.get((Object)"key1"));
            }
        });
    }

    @Test
    public void testPutIfAbsent() {
        IMap map = this.createMap();
        Assert.assertNull((Object)map.putIfAbsent((Object)"key1", (Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)map.putIfAbsent((Object)"key1", (Object)"value3"));
    }

    @Test
    public void testPutIfAbsentTtl() {
        final IMap map = this.createMap();
        Assert.assertNull((Object)map.putIfAbsent((Object)"key1", (Object)"value1", 10L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)"value1", (Object)map.putIfAbsent((Object)"key1", (Object)"value3", 1L, TimeUnit.SECONDS));
        ClientMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)map.get((Object)"key1"));
            }
        });
        Assert.assertNull((Object)map.putIfAbsent((Object)"key1", (Object)"value3", 10L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)"value3", (Object)map.putIfAbsent((Object)"key1", (Object)"value4", 1L, TimeUnit.SECONDS));
    }

    @Test
    public void testSet() {
        final IMap map = this.createMap();
        map.set((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key1"));
        map.set((Object)"key1", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)map.get((Object)"key1"));
        map.set((Object)"key1", (Object)"value3", 1L, TimeUnit.SECONDS);
        ClientMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertNull((Object)map.get((Object)"key1"));
            }
        });
    }

    @Test
    public void testPutTransient() throws Exception {
        this.transientMapStore.latch = new CountDownLatch(1);
        IMap map = this.client.getMap("putTransientMap");
        map.putTransient((Object)3L, (Object)"value1", 100L, TimeUnit.SECONDS);
        map.flush();
        Assert.assertFalse((boolean)this.transientMapStore.latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testLock() throws Exception {
        final IMap map = this.createMap();
        map.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key1"));
        map.lock((Object)"key1");
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.tryPut((Object)"key1", (Object)"value2", 1L, TimeUnit.SECONDS);
                latch.countDown();
            }
        }.start();
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertEquals((Object)"value1", (Object)map.get((Object)"key1"));
        map.forceUnlock((Object)"key1");
    }

    @Test
    public void testTryLock() throws Exception {
        final IMap map = this.createMap();
        Assert.assertTrue((boolean)map.tryLock((Object)"key1", 2L, TimeUnit.SECONDS));
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (!map.tryLock((Object)"key1", 2L, TimeUnit.SECONDS)) {
                        latch.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertTrue((boolean)map.isLocked((Object)"key1"));
        final CountDownLatch latch2 = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (map.tryLock((Object)"key1", 20L, TimeUnit.SECONDS)) {
                        latch2.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread.sleep(1000L);
        map.unlock((Object)"key1");
        ClientMapTest.assertOpenEventually((CountDownLatch)latch2);
        Assert.assertTrue((boolean)map.isLocked((Object)"key1"));
        map.forceUnlock((Object)"key1");
    }

    @Test
    public void testForceUnlock() throws Exception {
        final IMap map = this.createMap();
        map.lock((Object)"key1");
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                map.forceUnlock((Object)"key1");
                latch.countDown();
            }
        }.start();
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertFalse((boolean)map.isLocked((Object)"key1"));
    }

    @Test
    public void testValuesWithPredicate() {
        IMap map = this.createMap();
        this.fillMap(map);
        Collection values = map.values((Predicate)new SqlPredicate("this == value1"));
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"value1", values.iterator().next());
    }

    @Test
    public void testValues() {
        IMap map = this.createMap();
        this.fillMap(map);
        Collection values = map.values();
        Assert.assertEquals((long)10L, (long)values.size());
    }

    @Test
    public void testReplace() {
        IMap map = this.createMap();
        Assert.assertNull((Object)map.replace((Object)"key1", (Object)"value1"));
        map.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)map.replace((Object)"key1", (Object)"value2"));
        Assert.assertEquals((Object)"value2", (Object)map.get((Object)"key1"));
        Assert.assertFalse((boolean)map.replace((Object)"key1", (Object)"value1", (Object)"value3"));
        Assert.assertEquals((Object)"value2", (Object)map.get((Object)"key1"));
        Assert.assertTrue((boolean)map.replace((Object)"key1", (Object)"value2", (Object)"value3"));
        Assert.assertEquals((Object)"value3", (Object)map.get((Object)"key1"));
    }

    @Test
    public void testExecuteOnKey() {
        IMap map = this.createMap();
        map.put((Object)1, (Object)1);
        Assert.assertEquals((Object)2, (Object)map.executeOnKey((Object)1, (EntryProcessor)new IncrementerEntryProcessor()));
    }

    @Test
    public void testSubmitToKey() throws Exception {
        IMap map = this.createMap();
        map.put((Object)1, (Object)1);
        ICompletableFuture future = map.submitToKey((Object)1, (EntryProcessor)new IncrementerEntryProcessor());
        Assert.assertEquals((Object)2, future.get());
        int actual = (Integer)map.get((Object)1);
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void testSubmitToNonExistentKey() throws Exception {
        IMap map = this.createMap();
        ICompletableFuture future = map.submitToKey((Object)11, (EntryProcessor)new IncrementerEntryProcessor());
        Assert.assertEquals((Object)1, future.get());
        int actual = (Integer)map.get((Object)11);
        Assert.assertEquals((long)1L, (long)actual);
    }

    @Test
    public void testSubmitToKeyWithCallback() throws Exception {
        IMap map = this.createMap();
        map.put((Object)1, (Object)1);
        final AtomicInteger result = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutionCallback<Integer> executionCallback = new ExecutionCallback<Integer>(){

            public void onResponse(Integer response) {
                result.set(response);
                latch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        };
        map.submitToKey((Object)1, (EntryProcessor)new IncrementerEntryProcessor(), (ExecutionCallback)executionCallback);
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertEquals((long)2L, (long)result.get());
        int actual = (Integer)map.get((Object)1);
        Assert.assertEquals((long)2L, (long)actual);
    }

    @Test
    public void testListener() throws Exception {
        IMap map = this.createMap();
        final CountDownLatch latch1Add = new CountDownLatch(5);
        final CountDownLatch latch1Remove = new CountDownLatch(2);
        EntryAdapter<String, String> listener1 = new EntryAdapter<String, String>(){

            public void entryAdded(EntryEvent<String, String> event) {
                latch1Add.countDown();
            }

            public void entryRemoved(EntryEvent<String, String> event) {
                latch1Remove.countDown();
            }
        };
        final CountDownLatch latch2Add = new CountDownLatch(1);
        final CountDownLatch latch2Remove = new CountDownLatch(1);
        EntryAdapter<String, String> listener2 = new EntryAdapter<String, String>(){

            public void entryAdded(EntryEvent<String, String> event) {
                latch2Add.countDown();
            }

            public void entryRemoved(EntryEvent<String, String> event) {
                latch2Remove.countDown();
            }
        };
        map.addEntryListener((EntryListener)listener1, false);
        map.addEntryListener((EntryListener)listener2, (Object)"key3", true);
        ClientMapTest.sleepSeconds((int)1);
        map.put((Object)"key1", (Object)"value1");
        map.put((Object)"key2", (Object)"value2");
        map.put((Object)"key3", (Object)"value3");
        map.put((Object)"key4", (Object)"value4");
        map.put((Object)"key5", (Object)"value5");
        map.remove((Object)"key1");
        map.remove((Object)"key3");
        ClientMapTest.assertOpenEventually((CountDownLatch)latch1Add);
        ClientMapTest.assertOpenEventually((CountDownLatch)latch1Remove);
        ClientMapTest.assertOpenEventually((CountDownLatch)latch2Add);
        ClientMapTest.assertOpenEventually((CountDownLatch)latch2Remove);
    }

    @Test
    public void testPredicateListenerWithPortableKey() throws Exception {
        IMap tradeMap = this.createMap();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        EntryAdapter listener = new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                atomicInteger.incrementAndGet();
                countDownLatch.countDown();
            }
        };
        NamedPortable key = new NamedPortable("a", 1);
        tradeMap.addEntryListener((EntryListener)listener, (Object)key, true);
        NamedPortable key2 = new NamedPortable("b", 2);
        tradeMap.put((Object)key2, (Object)1);
        Assert.assertFalse((boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)atomicInteger.get());
    }

    @Test
    public void testBasicPredicate() {
        IMap map = this.createMap();
        this.fillMap(map);
        Collection collection = map.values((Predicate)new SqlPredicate("this == value1"));
        Assert.assertEquals((Object)"value1", collection.iterator().next());
        Set set = map.keySet((Predicate)new SqlPredicate("this == value1"));
        Assert.assertEquals((Object)"key1", set.iterator().next());
        Set set1 = map.entrySet((Predicate)new SqlPredicate("this == value1"));
        Assert.assertEquals((Object)"key1", ((Map.Entry)set1.iterator().next()).getKey());
        Assert.assertEquals((Object)"value1", ((Map.Entry)set1.iterator().next()).getValue());
    }

    @Test
    public void testPartitionAwareKey() {
        String name = ClientMapTest.randomString();
        PartitionAwareKey key = new PartitionAwareKey("123");
        String value = "value";
        IMap map1 = this.server.getMap(name);
        map1.put((Object)key, (Object)value);
        Assert.assertEquals((Object)value, (Object)map1.get((Object)key));
        IMap map2 = this.client.getMap(name);
        Assert.assertEquals((Object)value, (Object)map2.get((Object)key));
    }

    @Test
    public void testExecuteOnKeys() throws Exception {
        this.testExecuteOnKeys(false);
    }

    @Test
    public void testSubmitToKeys() throws Exception {
        this.testExecuteOnKeys(true);
    }

    private void testExecuteOnKeys(boolean async) throws Exception {
        String name = ClientMapTest.randomString();
        IMap map = this.client.getMap(name);
        IMap map2 = this.client.getMap(name);
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)0);
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        keys.add(1);
        keys.add(4);
        keys.add(7);
        keys.add(9);
        Map resultMap = async ? (Map)((ClientMapProxy)map2).submitToKeys(keys, (EntryProcessor)new IncrementerEntryProcessor()).get() : map2.executeOnKeys(keys, (EntryProcessor)new IncrementerEntryProcessor());
        Assert.assertEquals((Object)1, resultMap.get(1));
        Assert.assertEquals((Object)1, resultMap.get(4));
        Assert.assertEquals((Object)1, resultMap.get(7));
        Assert.assertEquals((Object)1, resultMap.get(9));
        Assert.assertEquals((long)1L, (long)((Integer)map.get((Object)1)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get((Object)2)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get((Object)3)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)map.get((Object)4)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get((Object)5)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get((Object)6)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)map.get((Object)7)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get((Object)8)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)map.get((Object)9)).intValue());
    }

    @Test
    public void testListeners_clearAllFromNode() {
        CountDownLatch gateAdd = new CountDownLatch(1);
        CountDownLatch gateClearAll = new CountDownLatch(1);
        IntegerDealEntryListener listener = new IntegerDealEntryListener(gateAdd, null, null, null, gateClearAll, null);
        String name = ClientMapTest.randomString();
        MultiMap multiMap = this.client.getMultiMap(name);
        multiMap.addEntryListener((EntryListener)listener, false);
        multiMap.put((Object)1, (Object)new Deal(1));
        this.server.getMultiMap(name).clear();
        ClientMapTest.assertOpenEventually((CountDownLatch)gateAdd);
        ClientMapTest.assertOpenEventually((CountDownLatch)gateClearAll);
    }

    @Test
    public void testEntryListener() throws Exception {
        CountDownLatch gateAdd = new CountDownLatch(3);
        CountDownLatch gateRemove = new CountDownLatch(1);
        CountDownLatch gateEvict = new CountDownLatch(1);
        CountDownLatch gateUpdate = new CountDownLatch(1);
        CountDownLatch gateClearAll = new CountDownLatch(1);
        CountDownLatch gateEvictAll = new CountDownLatch(1);
        String mapName = ClientMapTest.randomString();
        IMap serverMap = this.server.getMap(mapName);
        serverMap.put((Object)3, (Object)new Deal(3));
        IMap clientMap = this.client.getMap(mapName);
        Assert.assertEquals((long)1L, (long)clientMap.size());
        IntegerDealEntryListener listener = new IntegerDealEntryListener(gateAdd, gateRemove, gateEvict, gateUpdate, gateClearAll, gateEvictAll);
        clientMap.addEntryListener((EntryListener)listener, (Predicate)new SqlPredicate("id=1"), (Object)2, true);
        clientMap.put((Object)2, (Object)new Deal(1));
        clientMap.put((Object)2, (Object)new Deal(1));
        clientMap.remove((Object)2);
        clientMap.put((Object)2, (Object)new Deal(1));
        clientMap.evict((Object)2);
        clientMap.clear();
        clientMap.put((Object)2, (Object)new Deal(1));
        clientMap.evictAll();
        ClientMapTest.assertOpenEventually((CountDownLatch)gateAdd);
        ClientMapTest.assertOpenEventually((CountDownLatch)gateRemove);
        ClientMapTest.assertOpenEventually((CountDownLatch)gateEvict);
        ClientMapTest.assertOpenEventually((CountDownLatch)gateUpdate);
        ClientMapTest.assertOpenEventually((CountDownLatch)gateClearAll);
        ClientMapTest.assertOpenEventually((CountDownLatch)gateEvictAll);
    }

    @Test
    public void testMapStatistics() {
        String name = ClientMapTest.randomString();
        IMap map = this.client.getMap(name);
        int operationCount = 1000;
        for (int i = 0; i < operationCount; ++i) {
            map.put((Object)i, (Object)i);
            map.get((Object)i);
            map.remove((Object)i);
        }
        LocalMapStats localMapStats = this.server.getMap(name).getLocalMapStats();
        Assert.assertEquals((String)"put count", (long)operationCount, (long)localMapStats.getPutOperationCount());
        Assert.assertEquals((String)"get count", (long)operationCount, (long)localMapStats.getGetOperationCount());
        Assert.assertEquals((String)"remove count", (long)operationCount, (long)localMapStats.getRemoveOperationCount());
        Assert.assertTrue((String)"put latency", (0L < localMapStats.getTotalPutLatency() ? 1 : 0) != 0);
        Assert.assertTrue((String)"get latency", (0L < localMapStats.getTotalGetLatency() ? 1 : 0) != 0);
        Assert.assertTrue((String)"remove latency", (0L < localMapStats.getTotalRemoveLatency() ? 1 : 0) != 0);
    }

    @Test
    public void testEntryListenerWithPredicateOnDeleteOperation() {
        IMap serverMap = this.server.getMap("A");
        IMap clientMap = this.client.getMap("A");
        final CountDownLatch latch = new CountDownLatch(1);
        clientMap.addEntryListener((EntryListener)new EntryAdapter<String, String>(){

            public void entryRemoved(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, (Predicate)new TestPredicate(), true);
        serverMap.put((Object)"A", (Object)"B");
        clientMap.delete((Object)"A");
        ClientMapTest.assertOpenEventually((CountDownLatch)latch);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> IMap<K, V> createMap() {
        return this.client.getMap(ClientMapTest.randomString());
    }

    private void fillMap(IMap<String, String> map) {
        for (int i = 0; i < 10; ++i) {
            map.put((Object)("key" + i), (Object)("value" + i));
        }
    }

    private static class TestMapStore
    extends MapStoreAdapter<Long, String> {
        public volatile CountDownLatch latch;

        private TestMapStore() {
        }

        public void store(Long key, String value) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public void storeAll(Map<Long, String> map) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public void deleteAll(Collection<Long> keys) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public void delete(Long key) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    private static class TestPredicate
    implements Predicate<String, String>,
    Serializable {
        private TestPredicate() {
        }

        public boolean apply(Map.Entry<String, String> mapEntry) {
            assert (mapEntry != null);
            return mapEntry.getKey().equals("A");
        }
    }

    private static class Deal
    implements Serializable {
        Integer id;

        Deal(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    private static class IntegerDealEntryListener
    implements EntryListener<Integer, Deal>,
    Serializable {
        private final CountDownLatch _gateAdd;
        private final CountDownLatch _gateRemove;
        private final CountDownLatch _gateEvict;
        private final CountDownLatch _gateUpdate;
        private final CountDownLatch _gateClearAll;
        private final CountDownLatch _gateEvictAll;

        IntegerDealEntryListener(CountDownLatch gateAdd, CountDownLatch gateRemove, CountDownLatch gateEvict, CountDownLatch gateUpdate, CountDownLatch gateClearAll, CountDownLatch gateEvictAll) {
            this._gateAdd = gateAdd;
            this._gateRemove = gateRemove;
            this._gateEvict = gateEvict;
            this._gateUpdate = gateUpdate;
            this._gateClearAll = gateClearAll;
            this._gateEvictAll = gateEvictAll;
        }

        public void entryAdded(EntryEvent<Integer, Deal> event) {
            this._gateAdd.countDown();
        }

        public void entryEvicted(EntryEvent<Integer, Deal> event) {
            this._gateEvict.countDown();
        }

        public void mapEvicted(MapEvent event) {
            this._gateEvictAll.countDown();
        }

        public void mapCleared(MapEvent event) {
            this._gateClearAll.countDown();
        }

        public void entryRemoved(EntryEvent<Integer, Deal> event) {
            this._gateRemove.countDown();
        }

        public void entryUpdated(EntryEvent<Integer, Deal> event) {
            this._gateUpdate.countDown();
        }
    }

    private static class PartitionAwareKey
    implements PartitionAware<String>,
    Serializable {
        private final String partitionKey;

        private PartitionAwareKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }
    }

    private static class IncrementerEntryProcessor
    extends AbstractEntryProcessor<Integer, Integer>
    implements DataSerializable {
        IncrementerEntryProcessor() {
            super(true);
        }

        public Object process(Map.Entry<Integer, Integer> entry) {
            Integer value = entry.getValue();
            if (value == null) {
                value = 0;
            }
            if (value == -1) {
                entry.setValue(null);
                return null;
            }
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
            entry.setValue(value);
            return value;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }
    }
}

