/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.IterationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientPagingPredicateTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private final SerializationService serializationService = new DefaultSerializationServiceBuilder().build();
    private HazelcastInstance client;
    private HazelcastInstance server;
    private IMap<Integer, Integer> map;
    private int pageSize = 5;
    private int size = 50;

    @Before
    public void setup() {
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.map = this.client.getMap(ClientPagingPredicateTest.randomString());
        for (int i = 0; i < this.size; ++i) {
            this.map.put((Object)i, (Object)i);
        }
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testWithoutAnchor() {
        PagingPredicate predicate = new PagingPredicate(this.pageSize);
        predicate.nextPage();
        predicate.nextPage();
        Collection values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{10, 11, 12, 13, 14});
        predicate.previousPage();
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{5, 6, 7, 8, 9});
        predicate.previousPage();
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{0, 1, 2, 3, 4});
    }

    @Test
    public void testGoToPreviousPageBeforeTheStart() {
        PagingPredicate predicate = new PagingPredicate(this.pageSize);
        predicate.previousPage();
        Collection values = this.map.values((Predicate)predicate);
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{0, 1, 2, 3, 4});
    }

    @Test
    public void testGoToNextPageAfterTheEnd() {
        PagingPredicate predicate = new PagingPredicate(this.pageSize);
        predicate.setPage(this.size / this.pageSize - 1);
        Collection values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{45, 46, 47, 48, 49});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void testPagingWithoutFilteringAndComparator() {
        HashSet set = new HashSet();
        PagingPredicate predicate = new PagingPredicate(this.pageSize);
        Collection values = this.map.values((Predicate)predicate);
        while (values.size() > 0) {
            Assert.assertEquals((long)this.pageSize, (long)values.size());
            set.addAll(values);
            predicate.nextPage();
            values = this.map.values((Predicate)predicate);
        }
        Assert.assertEquals((long)this.size, (long)set.size());
    }

    @Test
    public void testPagingWithFilteringAndComparator() {
        Predicate lessEqual = Predicates.lessEqual((String)"this", (Comparable)Integer.valueOf(8));
        TestComparator comparator = new TestComparator(false, IterationType.VALUE);
        PagingPredicate predicate = new PagingPredicate(lessEqual, (Comparator)comparator, this.pageSize);
        Collection values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{8, 7, 6, 5, 4});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{3, 2, 1, 0});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void testKeyPaging() {
        this.map.clear();
        for (int i = 0; i < this.size; ++i) {
            this.map.put((Object)(this.size - i), (Object)i);
        }
        Predicate lessEqual = Predicates.lessEqual((String)"this", (Comparable)Integer.valueOf(8));
        TestComparator comparator = new TestComparator(true, IterationType.KEY);
        PagingPredicate predicate = new PagingPredicate(lessEqual, (Comparator)comparator, this.pageSize);
        Set keySet = this.map.keySet((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)keySet, (Object[])new Object[]{42, 43, 44, 45, 46});
        predicate.nextPage();
        keySet = this.map.keySet((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)keySet, (Object[])new Object[]{47, 48, 49, 50});
        predicate.nextPage();
        keySet = this.map.keySet((Predicate)predicate);
        Assert.assertEquals((long)0L, (long)keySet.size());
    }

    @Test
    public void testEqualValuesPaging() {
        for (int i = this.size; i < 2 * this.size; ++i) {
            this.map.put((Object)i, (Object)(i - this.size));
        }
        Predicate lessEqual = Predicates.lessEqual((String)"this", (Comparable)Integer.valueOf(8));
        TestComparator comparator = new TestComparator(true, IterationType.VALUE);
        PagingPredicate predicate = new PagingPredicate(lessEqual, (Comparator)comparator, this.pageSize);
        Collection values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{0, 0, 1, 1, 2});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{2, 3, 3, 4, 4});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{5, 5, 6, 6, 7});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{7, 8, 8});
    }

    @Test
    public void testNextPageAfterResultSetEmpty() {
        Predicate lessEqual = Predicates.lessEqual((String)"this", (Comparable)Integer.valueOf(3));
        TestComparator comparator = new TestComparator(true, IterationType.VALUE);
        PagingPredicate predicate = new PagingPredicate(lessEqual, (Comparator)comparator, this.pageSize);
        Collection values = this.map.values((Predicate)predicate);
        ClientPagingPredicateTest.assertIterableEquals((Iterable)values, (Object[])new Object[]{0, 1, 2, 3});
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        Assert.assertEquals((long)0L, (long)values.size());
        predicate.nextPage();
        values = this.map.values((Predicate)predicate);
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void mapPagingPredicateEmployeeObjectWithOrderedIndexSmallTest() {
        this.mapPagingPredicateEmployeeObjectWithOrderedIndex(10);
    }

    @Test
    public void mapPagingPredicateEmployeeObjectWithOrderedIndexLargeTest() {
        this.mapPagingPredicateEmployeeObjectWithOrderedIndex(5000);
    }

    private void mapPagingPredicateEmployeeObjectWithOrderedIndex(int maxEmployee) {
        IMap<Integer, Employee> map = this.makeEmployeeMap(maxEmployee);
        map.addIndex("id", true);
        Predicate pred = Predicates.lessThan((String)"id", (Comparable)Integer.valueOf(2));
        PagingPredicate predicate = new PagingPredicate(pred, 2);
        Collection values = map.values((Predicate)predicate);
        System.out.println(values);
        Assert.assertEquals((long)2L, (long)values.size());
        predicate.nextPage();
        values = map.values((Predicate)predicate);
        System.out.println(values);
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void betweenPagingPredicateWithEmployeeTest() {
        int minId = 10;
        int maxId = 15;
        int pageSz = 5;
        IMap<Integer, Employee> map = this.makeEmployeeMap(1000);
        Predicate p = Predicates.between((String)"id", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15));
        ArrayList<Employee> expected = new ArrayList<Employee>();
        for (Employee e : map.values()) {
            if (e.getId() < 10 || e.getId() > 15) continue;
            expected.add(e);
        }
        List<Employee> actual = this.pagingPredicateWithEmployeeObjectTest(map, (Predicate<Integer, Employee>)p, 5);
        EmployeeIdComparitor compId = new EmployeeIdComparitor();
        Collections.sort(expected, compId);
        Collections.sort(actual, compId);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void lessThanPredicateWithEmployeeTest() {
        int maxId = 500;
        int pageSz = 5;
        IMap<Integer, Employee> map = this.makeEmployeeMap(1000);
        Predicate p = Predicates.lessThan((String)"id", (Comparable)Integer.valueOf(500));
        ArrayList<Employee> expected = new ArrayList<Employee>();
        for (Employee e : map.values()) {
            if (e.getId() >= 500) continue;
            expected.add(e);
        }
        List<Employee> actual = this.pagingPredicateWithEmployeeObjectTest(map, (Predicate<Integer, Employee>)p, 5);
        EmployeeIdComparitor compId = new EmployeeIdComparitor();
        Collections.sort(expected, compId);
        Collections.sort(actual, compId);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void equalsPredicateWithEmployeeTest() {
        String name = Employee.getRandomName();
        int pageSz = 5;
        IMap<Integer, Employee> map = this.makeEmployeeMap(1000);
        Predicate p = Predicates.equal((String)"name", (Comparable)((Object)name));
        ArrayList<Employee> expected = new ArrayList<Employee>();
        for (Employee e : map.values()) {
            if (!e.getName().equals(name)) continue;
            expected.add(e);
        }
        List<Employee> actual = this.pagingPredicateWithEmployeeObjectTest(map, (Predicate<Integer, Employee>)p, 5);
        EmployeeIdComparitor compId = new EmployeeIdComparitor();
        Collections.sort(expected, compId);
        Collections.sort(actual, compId);
        Assert.assertEquals(expected, actual);
    }

    private IMap<Integer, Employee> makeEmployeeMap(int maxEmployees) {
        IMap map = this.server.getMap(ClientPagingPredicateTest.randomString());
        for (int i = 0; i < maxEmployees; ++i) {
            Employee e = new Employee(i);
            map.put((Object)e.id, (Object)e);
        }
        return map;
    }

    private List<Employee> pagingPredicateWithEmployeeObjectTest(IMap<Integer, Employee> map, Predicate<Integer, Employee> predicate, int pageSize) {
        Set set;
        PagingPredicate pagingPredicate = new PagingPredicate(predicate, pageSize);
        ArrayList<Employee> results = new ArrayList<Employee>();
        do {
            set = map.entrySet((Predicate)pagingPredicate);
            for (Map.Entry entry : set) {
                Employee e = (Employee)entry.getValue();
                InternalSerializationService ss = (InternalSerializationService)this.serializationService;
                QueryEntry qe = new QueryEntry(ss, ss.toData((Object)e.getId()), (Object)e, Extractors.newBuilder((InternalSerializationService)ss).build());
                Assert.assertTrue((boolean)predicate.apply((Map.Entry)qe));
                results.add(e);
            }
            pagingPredicate.nextPage();
        } while (!set.isEmpty());
        return results;
    }

    @Test
    public void testIssue3047() {
        Collection values;
        IMap map = this.client.getMap("employeeMap");
        int PAGE_SIZE = 5;
        boolean START_ID_FOR_QUERY = false;
        int FINISH_ID_FOR_QUERY = 50;
        int queriedElementCount = 51;
        int expectedPageCount = 11;
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        map.addIndex("id", true);
        Predicate pred = Predicates.between((String)"id", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(50));
        PagingPredicate predicate = new PagingPredicate(pred, 5);
        int passedPageCount = 0;
        do {
            predicate.nextPage();
        } while (!(values = map.values((Predicate)predicate)).isEmpty() && ++passedPageCount <= 11);
        Assert.assertEquals((long)11L, (long)passedPageCount);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIssue3047ForNonComparableEntitiesThrowsIllegalArgumentException() {
        IMap map = this.client.getMap("baseEmployeeMap");
        int PAGE_SIZE = 5;
        boolean START_ID_FOR_QUERY = false;
        int FINISH_ID_FOR_QUERY = 50;
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)new BaseEmployee(i));
        }
        map.addIndex("id", true);
        Predicate pred = Predicates.between((String)"id", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(50));
        PagingPredicate predicate = new PagingPredicate(pred, 5);
        Collection values = map.values((Predicate)predicate);
        while (!values.isEmpty() && values != null) {
            predicate.nextPage();
            values = map.values((Predicate)predicate);
        }
    }

    @Test
    public void testLargePageSizeIsNotCausingIndexOutBoundsExceptions() {
        int[] pageSizesToCheck = new int[]{0x3FFFFFFF, 2147482647, 0x7FFFFFFE, Integer.MAX_VALUE};
        int[] pagesToCheck = new int[]{1, 1000, 0x3FFFFFFF, 2147482647, 0x7FFFFFFE, Integer.MAX_VALUE};
        for (int pageSize : pageSizesToCheck) {
            PagingPredicate predicate = new PagingPredicate(pageSize);
            Assert.assertEquals((long)this.size, (long)this.map.keySet((Predicate)predicate).size());
            for (int page : pagesToCheck) {
                predicate.setPage(page);
                Assert.assertEquals((long)0L, (long)this.map.keySet((Predicate)predicate).size());
            }
        }
    }

    private static class Employee
    extends BaseEmployee
    implements Comparable<Employee> {
        public Employee() {
        }

        public Employee(int id) {
            super(id);
        }

        @Override
        public int compareTo(Employee employee) {
            return this.id - employee.id;
        }
    }

    private static class BaseEmployee
    implements Serializable {
        public static final int MAX_AGE = 75;
        public static final double MAX_SALARY = 1000.0;
        public static final String[] names = new String[]{"aaa", "bbb", "ccc", "ddd", "eee", "fff", "ggg"};
        public static Random random = new Random();
        protected int id;
        protected String name;
        protected int age;
        protected boolean active;
        protected double salary;

        public BaseEmployee() {
        }

        public BaseEmployee(int id) {
            this.id = id;
            this.setAtributesRandomly();
        }

        public static String getRandomName() {
            return names[random.nextInt(names.length)];
        }

        public void setAtributesRandomly() {
            this.name = names[random.nextInt(names.length)];
            this.age = random.nextInt(75);
            this.active = random.nextBoolean();
            this.salary = random.nextDouble() * 1000.0;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int getAge() {
            return this.age;
        }

        public double getSalary() {
            return this.salary;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Employee) {
                return this.id == ((Employee)obj).getId();
            }
            return false;
        }

        public String toString() {
            return "Employee{id=" + this.id + ", name='" + this.name + '\'' + ", age=" + this.age + ", active=" + this.active + ", salary=" + this.salary + '}';
        }
    }

    private static class EmployeeIdComparitor
    implements Comparator<Employee> {
        private EmployeeIdComparitor() {
        }

        @Override
        public int compare(Employee e1, Employee e2) {
            return e1.getId() - e2.getId();
        }
    }

    private static class TestComparator
    implements Comparator<Map.Entry<Integer, Integer>>,
    Serializable {
        int ascending = 1;
        IterationType iterationType = IterationType.ENTRY;

        TestComparator() {
        }

        TestComparator(boolean ascending, IterationType iterationType) {
            this.ascending = ascending ? 1 : -1;
            this.iterationType = iterationType;
        }

        @Override
        public int compare(Map.Entry<Integer, Integer> e1, Map.Entry<Integer, Integer> e2) {
            Map.Entry<Integer, Integer> o1 = e1;
            Map.Entry<Integer, Integer> o2 = e2;
            switch (this.iterationType) {
                case KEY: {
                    return (o1.getKey() - o2.getKey()) * this.ascending;
                }
                case VALUE: {
                    return (o1.getValue() - o2.getValue()) * this.ascending;
                }
            }
            int result = (o1.getValue() - o2.getValue()) * this.ascending;
            if (result != 0) {
                return result;
            }
            return (o1.getKey() - o2.getKey()) * this.ascending;
        }
    }
}

