/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SampleTestObjects;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import com.hazelcast.test.bounce.BounceMemberRule;
import com.hazelcast.test.jitter.JitterRule;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={SlowTest.class})
public class ClientPutAllRemoveBounceTest
extends HazelcastTestSupport {
    private static final String TEST_MAP_NAME = "employees";
    private static final int CONCURRENCY = 1;
    @Rule
    public BounceMemberRule bounceMemberRule = BounceMemberRule.with((Config)this.getConfig()).clusterSize(4).driverCount(4).build();
    @Rule
    public JitterRule jitterRule = new JitterRule();

    @Before
    public void setup() {
        this.bounceMemberRule.getSteadyMember().getMap(TEST_MAP_NAME).addIndex("id", true);
    }

    @Test
    public void testQuery() {
        Runnable[] testTasks = new QueryRunnable[1];
        for (int i = 0; i < 1; ++i) {
            testTasks[i] = new QueryRunnable(this.bounceMemberRule.getNextTestDriver());
        }
        this.bounceMemberRule.testRepeatedly(testTasks, TimeUnit.MINUTES.toSeconds(1L));
    }

    @After
    public void assertMapEmpty() {
        IMap map = this.bounceMemberRule.getSteadyMember().getMap(TEST_MAP_NAME);
        Assert.assertEquals((String)"Map is not empty ", (long)0L, (long)map.size());
    }

    protected Config getConfig() {
        return ClientPutAllRemoveBounceTest.smallInstanceConfig();
    }

    public static class QueryRunnable
    implements Runnable {
        private final HazelcastInstance hazelcastInstance;
        private final Random random = new Random();
        private IMap<Integer, SampleTestObjects.Employee> map;
        int range = 10;
        int keyDomain = Integer.MAX_VALUE;

        QueryRunnable(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        @Override
        public void run() {
            if (this.map == null) {
                this.map = this.hazelcastInstance.getMap(ClientPutAllRemoveBounceTest.TEST_MAP_NAME);
            }
            int min = this.random.nextInt(this.keyDomain - this.range);
            int max = min + this.range;
            HashMap<Integer, SampleTestObjects.Employee> m = new HashMap<Integer, SampleTestObjects.Employee>();
            for (int i = min; i < max; ++i) {
                m.put(i, new SampleTestObjects.Employee((long)i, "name" + i, i, true, (double)i));
            }
            this.map.putAll(m);
            this.map.removeAll((Predicate)new SqlPredicate("id >= " + min + " and id < " + max));
        }
    }
}

