/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class MapMemoryUsageStressTest
extends HazelcastTestSupport {
    private final ILogger logger = Logger.getLogger(MapMemoryUsageStressTest.class);
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void launchHazelcastServer() {
        this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        this.client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
    }

    @After
    public void shutdownHazelcastServer() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(timeout=1800000L)
    public void voidCacher() {
        AtomicInteger counter = new AtomicInteger(200000);
        AtomicInteger errors = new AtomicInteger();
        List<String> errorList = Collections.synchronizedList(new LinkedList());
        Thread[] threads = new Thread[8];
        for (int i = 0; i < threads.length; ++i) {
            StressThread stressThread = new StressThread(counter, errors, errorList);
            threads[i] = stressThread;
            stressThread.start();
        }
        MapMemoryUsageStressTest.assertJoinable((long)TimeUnit.MINUTES.toSeconds(30L), (Thread[])threads);
        MapMemoryUsageStressTest.assertEqualsStringFormat((String)("Expected %d errors, but got %d (" + errorList + ")"), (Object)0, (Object)errors.get());
        Assert.assertTrue((String)String.format("Expected the counter to be <= 0, but was %d", counter.get()), (counter.get() <= 0 ? 1 : 0) != 0);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private class StressThread
    extends Thread {
        private final AtomicInteger counter;
        private final AtomicInteger errors;
        private final List<String> errorList;

        StressThread(AtomicInteger counter, AtomicInteger errors, List<String> errorList) {
            this.counter = counter;
            this.errors = errors;
            this.errorList = errorList;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int index;
                    if ((index = this.counter.decrementAndGet()) <= 0) {
                        return;
                    }
                    IMap map = MapMemoryUsageStressTest.this.client.getMap("juka" + index);
                    map.set((Object)"aaaa", (Object)"bbbb");
                    map.clear();
                    map.destroy();
                    if (index % 1000 != 0) continue;
                    MapMemoryUsageStressTest.this.logger.info("At: " + index);
                }
            }
            catch (Throwable t) {
                this.errors.incrementAndGet();
                this.errorList.add(t.getClass().getSimpleName() + ": " + t.getMessage());
                t.printStackTrace();
                return;
            }
        }
    }
}

