/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCacheInvalidationTest
extends ClientTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    private String mapName = ClientMapNearCacheInvalidationTest.randomMapName();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void testBatchInvalidationRemovesEntries() {
        int i;
        Config config = this.getConfig();
        ClientMapNearCacheInvalidationTest.configureBatching(config, 10, 1);
        ClientConfig clientConfig = this.getClientConfig(this.mapName);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.makeSureConnectedToServers(client, 2);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        ClientMapNearCacheInvalidationTest.assertNearCacheSizeEventually(clientMap, 0);
    }

    @Test
    public void testHigherBatchSize_shouldNotCauseAnyInvalidation_onClient() {
        int i;
        Config config = this.getConfig();
        ClientMapNearCacheInvalidationTest.configureBatching(config, Integer.MAX_VALUE, Integer.MAX_VALUE);
        ClientConfig clientConfig = this.getClientConfig(this.mapName);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.makeSureConnectedToServers(client, 2);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        ClientMapNearCacheInvalidationTest.assertNearCacheSizeEventually(clientMap, size);
    }

    @Test
    public void testMapClear_shouldClearNearCaches_onOwnerAndBackupNodes() {
        int i;
        Config config = this.getConfig();
        ClientMapNearCacheInvalidationTest.configureBatching(config, 10, 1);
        ClientConfig clientConfig = this.getClientConfig(this.mapName);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.makeSureConnectedToServers(client, 2);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        serverMap.clear();
        ClientMapNearCacheInvalidationTest.assertNearCacheSizeEventually(clientMap, 0);
    }

    @Test
    public void testMapEvictAll_shouldClearNearCaches_onOwnerAndBackupNodes() {
        int i;
        Config config = this.getConfig();
        ClientMapNearCacheInvalidationTest.configureBatching(config, 10, 1);
        ClientConfig clientConfig = this.getClientConfig(this.mapName);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.makeSureConnectedToServers(client, 2);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        serverMap.evictAll();
        ClientMapNearCacheInvalidationTest.assertNearCacheSizeEventually(clientMap, 0);
    }

    protected Config getConfig() {
        return NearCacheTestUtils.getBaseConfig();
    }

    protected ClientConfig getClientConfig(String mapName) {
        NearCacheConfig nearCacheConfig = this.getNearCacheConfig(mapName);
        return new ClientConfig().addNearCacheConfig(nearCacheConfig);
    }

    protected NearCacheConfig getNearCacheConfig(String mapName) {
        return new NearCacheConfig(mapName).setInMemoryFormat(InMemoryFormat.OBJECT).setInvalidateOnChange(true);
    }

    private static void configureBatching(Config config, int batchSize, int period) {
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true");
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(batchSize));
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(period));
    }

    private static void assertNearCacheSizeEventually(final IMap map, final int nearCacheSize) {
        ClientMapNearCacheInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                NearCache nearCache = ((NearCachedClientMapProxy)map).getNearCache();
                Assert.assertEquals((long)nearCacheSize, (long)nearCache.size());
            }
        });
    }
}

