/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCachePreloaderTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCachePreloaderTest
extends AbstractNearCachePreloaderTest<Data, String> {
    protected final File storeFile;
    protected final File storeLockFile;
    private final TestHazelcastFactory hazelcastFactory;

    public ClientMapNearCachePreloaderTest() {
        this.storeFile = new File("nearCache-" + this.defaultNearCache + ".store").getAbsoluteFile();
        this.storeLockFile = new File(this.storeFile.getName() + ".lock").getAbsoluteFile();
        this.hazelcastFactory = new TestHazelcastFactory();
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = this.getNearCacheConfig(NearCacheConfig.DEFAULT_MEMORY_FORMAT, false, true, 10023, this.storeFile.getParent());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected File getStoreFile() {
        return this.storeFile;
    }

    protected File getStoreLockFile() {
        return this.storeLockFile;
    }

    protected <K, V> DataStructureAdapter<K, V> getDataStructure(NearCacheTestContext<K, V, Data, String> context, String name) {
        IMap map = context.nearCacheInstance.getMap(name);
        return new IMapDataStructureAdapter(map);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(boolean createNearCacheInstance) {
        Config config = this.getConfig();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        IMap memberMap = member.getMap(this.nearCacheConfig.getName());
        IMapDataStructureAdapter dataAdapter = new IMapDataStructureAdapter(memberMap);
        if (createNearCacheInstance) {
            NearCacheTestContextBuilder<K, V, Data, String> contextBuilder = this.createNearCacheContextBuilder();
            return contextBuilder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).build();
        }
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)ClientMapNearCachePreloaderTest.getSerializationService((HazelcastInstance)member)).setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        NearCacheTestContextBuilder<K, V, Data, String> contextBuilder = this.createNearCacheContextBuilder();
        return contextBuilder.build();
    }

    protected Config getConfig() {
        return NearCacheTestUtils.getBaseConfig();
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder() {
        ClientConfig clientConfig = this.getClientConfig().addNearCacheConfig(this.nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap(this.nearCacheConfig.getName());
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache(this.nearCacheConfig.getName());
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new IMapDataStructureAdapter(clientMap)).setNearCache(nearCache).setNearCacheManager(nearCacheManager);
    }
}

