/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.map.impl.nearcache.MapNearCacheRecordStateStressTest;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientMapNearCacheRecordStateStressTest
extends HazelcastTestSupport {
    private static final int KEY_SPACE = 100;
    private static final int TEST_RUN_SECONDS = 60;
    private static final int GET_ALL_THREAD_COUNT = 3;
    private static final int GET_THREAD_COUNT = 2;
    private static final int PUT_THREAD_COUNT = 1;
    private static final int CLEAR_THREAD_COUNT = 1;
    private static final int REMOVE_THREAD_COUNT = 1;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final AtomicBoolean stop = new AtomicBoolean();
    private IMap<Integer, Integer> memberMap;
    private IMap<Integer, Integer> clientMap;

    @Before
    public void setUp() {
        String mapName = ClientMapNearCacheRecordStateStressTest.randomMapName();
        Config config = NearCacheTestUtils.getBaseConfig();
        ClientConfig clientConfig = new ClientConfig().addNearCacheConfig(this.newNearCacheConfig(mapName));
        HazelcastInstance member = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.memberMap = member.getMap(mapName);
        this.clientMap = client.getMap(mapName);
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void allRecordsAreInReadableStateInTheEnd() throws Exception {
        int i;
        for (int i2 = 0; i2 < 100; ++i2) {
            this.memberMap.put((Object)i2, (Object)i2);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < 1; ++i) {
            Put put = new Put(this.memberMap);
            threads.add(put);
        }
        for (i = 0; i < 3; ++i) {
            GetAll getAll = new GetAll(this.clientMap);
            threads.add(getAll);
        }
        for (i = 0; i < 2; ++i) {
            Get get = new Get(this.clientMap);
            threads.add(get);
        }
        for (i = 0; i < 1; ++i) {
            Remove remove = new Remove(this.clientMap);
            threads.add(remove);
        }
        for (i = 0; i < 1; ++i) {
            Clear clear = new Clear(this.clientMap);
            threads.add(clear);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        ClientMapNearCacheRecordStateStressTest.sleepSeconds((int)60);
        this.stop.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        ClientMapNearCacheRecordStateStressTest.assertFinalRecordStateIsReadPermitted(this.clientMap);
    }

    private NearCacheConfig newNearCacheConfig(String mapName) {
        return new NearCacheConfig(mapName).setSerializeKeys(false).setInvalidateOnChange(true);
    }

    private static void assertFinalRecordStateIsReadPermitted(IMap clientMap) {
        NearCachedClientMapProxy proxy = (NearCachedClientMapProxy)clientMap;
        DefaultNearCache nearCache = (DefaultNearCache)proxy.getNearCache().unwrap(DefaultNearCache.class);
        MapNearCacheRecordStateStressTest.assertNearCacheRecordStates((DefaultNearCache)nearCache, (int)100);
    }

    private class Get
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Get(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.map.get((Object)i);
                }
            } while (!ClientMapNearCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class GetAll
    extends Thread {
        private final IMap<Integer, Integer> map;

        private GetAll(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            HashSet<Integer> keys = new HashSet<Integer>();
            for (int i = 0; i < 100; ++i) {
                keys.add(i);
            }
            do {
                this.map.getAll(keys);
                HazelcastTestSupport.sleepAtLeastMillis((long)2L);
            } while (!ClientMapNearCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class Clear
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Clear(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                this.map.clear();
                HazelcastTestSupport.sleepAtLeastMillis((long)5000L);
            } while (!ClientMapNearCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class Remove
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Remove(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.map.remove((Object)i);
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)100L);
            } while (!ClientMapNearCacheRecordStateStressTest.this.stop.get());
        }
    }

    private class Put
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Put(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.map.put((Object)i, (Object)RandomPicker.getInt((int)100));
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)100L);
            } while (!ClientMapNearCacheRecordStateStressTest.this.stop.get());
        }
    }
}

