/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.SlowTest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class, ParallelTest.class})
public class ClientMapNearCacheStaleReadTest
extends HazelcastTestSupport {
    private static final int NUM_GETTERS = 7;
    private static final int MAX_RUNTIME = 30;
    private static final String KEY = "key123";
    private static final ILogger LOGGER = Logger.getLogger(ClientMapNearCacheStaleReadTest.class);
    private AtomicInteger valuePut = new AtomicInteger(0);
    private AtomicBoolean stop = new AtomicBoolean(false);
    private AtomicInteger assertionViolationCount = new AtomicInteger(0);
    private AtomicBoolean failed = new AtomicBoolean(false);
    private HazelcastInstance member;
    private HazelcastInstance client;
    private IMap<String, String> map;

    @Before
    public void setUp() {
        String mapName = ClientMapNearCacheStaleReadTest.randomMapName();
        TestHazelcastFactory factory = new TestHazelcastFactory();
        Config config = NearCacheTestUtils.getBaseConfig().setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "2");
        ClientConfig clientConfig = this.getClientConfig(mapName).setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0");
        this.member = factory.newHazelcastInstance(config);
        this.client = factory.newHazelcastClient(clientConfig);
        this.map = this.client.getMap(mapName);
    }

    @After
    public void tearDown() {
        this.client.shutdown();
        this.member.shutdown();
    }

    @Test
    public void testNoLostInvalidationsEventually() {
        this.testNoLostInvalidationsStrict(false);
    }

    @Test
    public void testNoLostInvalidationsStrict() {
        this.testNoLostInvalidationsStrict(true);
    }

    private void testNoLostInvalidationsStrict(boolean strict) {
        this.runTestInternal();
        if (!strict) {
            ClientMapNearCacheStaleReadTest.sleepSeconds((int)2);
        }
        int valuePutLast = this.valuePut.get();
        String valueMapStr = (String)this.map.get((Object)KEY);
        int valueMap = Integer.parseInt(valueMapStr);
        String msg = null;
        if (valueMap < valuePutLast) {
            msg = "Near Cache did *not* become consistent. (valueMap = " + valueMap + ", valuePut = " + valuePutLast + ").";
            this.flushClientNearCache(this.map);
            String valueMap2Str = (String)this.map.get((Object)KEY);
            int valueMap2 = Integer.parseInt(valueMap2Str);
            msg = valueMap2 < valuePutLast ? msg + " Unexpected inconsistency! (valueMap2 = " + valueMap2 + ", valuePut = " + valuePutLast + ")." : msg + " Flushing the Near Cache cleared the inconsistency. (valueMap2 = " + valueMap2 + ", valuePut = " + valuePutLast + ").";
        }
        this.client.getLifecycleService().terminate();
        if (msg != null) {
            LOGGER.warning(msg);
            Assert.fail(msg);
        }
        if (strict && this.assertionViolationCount.get() > 0) {
            msg = "Assertion violated " + this.assertionViolationCount.get() + " times.";
            LOGGER.warning(msg);
            Assert.fail((String)msg);
        }
    }

    protected ClientConfig getClientConfig(String mapName) {
        NearCacheConfig nearCacheConfig = this.getNearCacheConfig(mapName);
        return new ClientConfig().addNearCacheConfig(nearCacheConfig);
    }

    protected NearCacheConfig getNearCacheConfig(String mapName) {
        return new NearCacheConfig(mapName).setInMemoryFormat(InMemoryFormat.BINARY);
    }

    private void flushClientNearCache(IMap map) {
        if (!(map instanceof NearCachedClientMapProxy)) {
            return;
        }
        NearCachedClientMapProxy clientMapProxy = (NearCachedClientMapProxy)map;
        clientMapProxy.getNearCache().clear();
    }

    private void runTestInternal() {
        Thread threadPut = new Thread((Runnable)new PutRunnable(), "put0");
        threadPut.start();
        ClientMapNearCacheStaleReadTest.sleepMillis((int)300);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 7; ++i) {
            Thread thread = new Thread((Runnable)new GetRunnable(), "get" + i);
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        int i = 0;
        while (!this.stop.get() && i++ < 30) {
            ClientMapNearCacheStaleReadTest.sleepMillis((int)1000);
        }
        if (!this.stop.get()) {
            LOGGER.info("Problem did not occur within 30s.");
        }
        this.stop.set(true);
        ClientMapNearCacheStaleReadTest.assertJoinable((Thread[])new Thread[]{threadPut});
        for (Thread thread : threads) {
            ClientMapNearCacheStaleReadTest.assertJoinable((Thread[])new Thread[]{thread});
        }
    }

    private class GetRunnable
    implements Runnable {
        private GetRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info(Thread.currentThread().getName() + " started.");
            int n = 0;
            while (!ClientMapNearCacheStaleReadTest.this.stop.get()) {
                ++n;
                String valueMapStr = (String)ClientMapNearCacheStaleReadTest.this.map.get((Object)ClientMapNearCacheStaleReadTest.KEY);
                int i = Integer.parseInt(valueMapStr);
                Assert.assertEquals((Object)("" + i), (Object)valueMapStr);
            }
            LOGGER.info(Thread.currentThread().getName() + " performed " + n + " operations.");
        }
    }

    private class PutRunnable
    implements Runnable {
        private PutRunnable() {
        }

        @Override
        public void run() {
            LOGGER.info(Thread.currentThread().getName() + " started.");
            int i = 0;
            while (!ClientMapNearCacheStaleReadTest.this.stop.get()) {
                int valueMap;
                ClientMapNearCacheStaleReadTest.this.map.put((Object)ClientMapNearCacheStaleReadTest.KEY, (Object)String.valueOf(++i));
                ClientMapNearCacheStaleReadTest.this.valuePut.set(i);
                String valueMapStr = (String)ClientMapNearCacheStaleReadTest.this.map.get((Object)ClientMapNearCacheStaleReadTest.KEY);
                if (valueMapStr == null || (valueMap = Integer.parseInt(valueMapStr)) == i) continue;
                ClientMapNearCacheStaleReadTest.this.assertionViolationCount.incrementAndGet();
                LOGGER.warning("Assertion violated! (valueMap = " + valueMap + ", i = " + i + ")");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.warning("Interrupted: " + e.getMessage());
                }
                if ((valueMap = Integer.parseInt(valueMapStr = (String)ClientMapNearCacheStaleReadTest.this.map.get((Object)ClientMapNearCacheStaleReadTest.KEY))) == i) continue;
                LOGGER.warning("Near Cache invalidation lost! (valueMap = " + valueMap + ", i = " + i + ")");
                ClientMapNearCacheStaleReadTest.this.failed.set(true);
                ClientMapNearCacheStaleReadTest.this.stop.set(true);
            }
            LOGGER.info(Thread.currentThread().getName() + " performed " + i + " operations.");
        }
    }
}

