/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.map.impl.nearcache.MapNearCacheStalenessTest;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCacheStalenessTest
extends HazelcastTestSupport {
    private static final int ENTRY_COUNT = 10;
    private static final int NEAR_CACHE_INVALIDATOR_THREAD_COUNT = 3;
    private static final int NEAR_CACHE_PUTTER_THREAD_COUNT = 10;
    private static final int NEAR_CACHE_REMOVER_THREAD_COUNT = 3;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private IMap<Integer, Integer> clientMap;
    private IMap<Integer, Integer> memberMap;
    protected TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setUp() {
        String mapName = ClientMapNearCacheStalenessTest.randomMapName();
        Config config = this.getConfig();
        ClientConfig clientConfig = this.getClientConfig(mapName);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.memberMap = member.getMap(mapName);
        this.clientMap = client.getMap(mapName);
    }

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testNearCache_notContainsStaleValue_whenUpdatedByMultipleThreads() {
        int i;
        ArrayList<Object> threads = new ArrayList<Object>();
        for (i = 0; i < 3; ++i) {
            MapNearCacheStalenessTest.NearCacheInvalidator nearCacheInvalidator = new MapNearCacheStalenessTest.NearCacheInvalidator(this.stop, this.memberMap, 10);
            threads.add(nearCacheInvalidator);
        }
        for (i = 0; i < 10; ++i) {
            MapNearCacheStalenessTest.NearCachePutter nearCachePutter = new MapNearCacheStalenessTest.NearCachePutter(this.stop, this.clientMap, 10);
            threads.add(nearCachePutter);
        }
        for (i = 0; i < 3; ++i) {
            MapNearCacheStalenessTest.NearCacheRemover nearCacheRemover = new MapNearCacheStalenessTest.NearCacheRemover(this.stop, this.clientMap, 10);
            threads.add(nearCacheRemover);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        ClientMapNearCacheStalenessTest.sleepSeconds((int)5);
        this.stop.set(true);
        for (Thread thread : threads) {
            ClientMapNearCacheStalenessTest.assertJoinable((Thread[])new Thread[]{thread});
        }
        ClientMapNearCacheStalenessTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheStalenessTest.assertNoStaleDataExistInNearCache((IMap<Integer, Integer>)ClientMapNearCacheStalenessTest.this.clientMap);
            }
        });
    }

    protected Config getConfig() {
        return NearCacheTestUtils.getBaseConfig().setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "2");
    }

    protected ClientConfig getClientConfig(String mapName) {
        NearCacheConfig nearCacheConfig = this.getNearCacheConfig(mapName);
        return new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0").addNearCacheConfig(nearCacheConfig);
    }

    protected NearCacheConfig getNearCacheConfig(String mapName) {
        return new NearCacheConfig(mapName).setInvalidateOnChange(true);
    }

    private static void assertNoStaleDataExistInNearCache(IMap<Integer, Integer> map) {
        HashMap fromNearCache = MapNearCacheStalenessTest.getAllEntries(map, (int)10);
        ((NearCachedClientMapProxy)map).getNearCache().clear();
        HashMap fromIMap = MapNearCacheStalenessTest.getAllEntries(map, (int)10);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals(fromIMap.get(i), fromNearCache.get(i));
        }
    }
}

