/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapStoreAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.nearcache.NearCacheTestSupport;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCacheTest
extends NearCacheTestSupport {
    protected final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Test
    public void smoke_near_cache_population() {
        String mapName = "test";
        int mapSize = 1000;
        Config config = this.newConfig();
        HazelcastInstance server1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance server2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance server3 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientMapNearCacheTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{server1, server2, server3});
        IMap nodeMap = server1.getMap(mapName);
        for (int i = 0; i < mapSize; ++i) {
            nodeMap.put((Object)i, (Object)i);
        }
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig().setInvalidateOnChange(true).setName(mapName);
        ClientConfig clientConfig = this.newClientConfig().addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap(mapName);
        for (int i = 0; i < mapSize; ++i) {
            Assert.assertNotNull((Object)clientMap.get((Object)i));
        }
        Assert.assertEquals((long)mapSize, (long)((NearCachedClientMapProxy)clientMap).getNearCache().size());
    }

    @Test
    public void testGetAllChecksNearCacheFirst() {
        int i;
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        HashSet<Integer> keys = new HashSet<Integer>();
        int size = 1003;
        for (i = 0; i < size; ++i) {
            map.put((Object)i, (Object)i);
            keys.add(i);
        }
        for (i = 0; i < size; ++i) {
            map.get((Object)i);
        }
        map.getAll(keys);
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertEquals((long)size, (long)stats.getOwnedEntryCount());
        Assert.assertEquals((long)size, (long)stats.getHits());
    }

    @Test
    public void testGetAllPopulatesNearCache() {
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        HashSet<Integer> keys = new HashSet<Integer>();
        int size = 1214;
        for (int i = 0; i < size; ++i) {
            map.put((Object)i, (Object)i);
            keys.add(i);
        }
        map.getAll(keys);
        this.assertThatOwnedEntryCountEquals(map, size);
    }

    @Test
    public void testGetAsync() throws Exception {
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        int size = 1009;
        this.populateMap((Map)map, size);
        this.populateNearCache((Map)map, size);
        for (int i = 0; i < size; ++i) {
            ICompletableFuture future = map.getAsync((Object)i);
            future.get();
        }
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertEquals((long)size, (long)stats.getOwnedEntryCount());
        Assert.assertEquals((long)size, (long)stats.getHits());
    }

    @Test
    public void testAfterRemoveNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.remove((Object)i, (Object)i);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterDeleteNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.delete((Object)i);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterPutAsyncNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.putAsync((Object)i, (Object)i, 1L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterSetAsyncNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.setAsync((Object)i, (Object)i, 1L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterRemoveAsyncNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.removeAsync((Object)i);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterTryRemoveNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.tryRemove((Object)i, 5L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterTryPutNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.tryPut((Object)i, (Object)i, 5L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterPutTransientNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.putTransient((Object)i, (Object)i, 10L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterPutIfAbsentNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.putIfAbsent((Object)i, (Object)i, 1L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterSetNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.set((Object)i, (Object)i, 1L, TimeUnit.SECONDS);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterEvictNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        for (int i = 0; i < mapSize; ++i) {
            clientMap.evict((Object)i);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterEvictAllNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        clientMap.evictAll();
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterLoadAllNearCacheIsInvalidated() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        NearCacheTestSupport.SimpleMapStore store = new NearCacheTestSupport.SimpleMapStore();
        MapStoreConfig mapStoreConfig = new MapStoreConfig().setEnabled(true).setImplementation((Object)store);
        Config config = server.getConfig();
        config.getMapConfig(mapName).setMapStoreConfig(mapStoreConfig);
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        clientMap.loadAll(true);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testMemberLoadAll_invalidates_clientNearCache() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        NearCacheTestSupport.SimpleMapStore store = new NearCacheTestSupport.SimpleMapStore();
        MapStoreConfig mapStoreConfig = new MapStoreConfig().setEnabled(true).setImplementation((Object)store);
        Config config = member.getConfig();
        config.getMapConfig(mapName).setMapStoreConfig(mapStoreConfig);
        final IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        IMap map = member.getMap(mapName);
        map.loadAll(true);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterLoadAllWithDefinedKeysNearCacheIsInvalidated() {
        int i;
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        NearCacheTestSupport.SimpleMapStore store = new NearCacheTestSupport.SimpleMapStore();
        MapStoreConfig mapStoreConfig = new MapStoreConfig().setEnabled(true).setImplementation((Object)store);
        Config config = server.getConfig();
        config.getMapConfig(mapName).setMapStoreConfig(mapStoreConfig);
        final IMap clientMap = client.getMap(mapName);
        HashSet<Integer> keys = new HashSet<Integer>();
        for (i = 0; i < mapSize; ++i) {
            clientMap.put((Object)i, (Object)i);
            keys.add(i);
        }
        for (i = 0; i < mapSize; ++i) {
            clientMap.get((Object)i);
        }
        clientMap.loadAll(keys, false);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testMemberPutAll_invalidates_clientNearCache() {
        int i;
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (i = 0; i < mapSize; ++i) {
            clientMap.put((Object)i, (Object)i);
            hashMap.put(i, i);
        }
        for (i = 0; i < mapSize; ++i) {
            clientMap.get((Object)i);
        }
        IMap memberMap = member.getMap(mapName);
        memberMap.putAll(hashMap);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test
    public void testAfterSubmitToKeyKeyIsInvalidatedFromNearCache() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        Random random = new Random();
        Config config = this.newConfig();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "1");
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        IMap memberMap = member.getMap(mapName);
        this.populateMap((Map)memberMap, 1000);
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateNearCache((Map)clientMap, 1000);
        int randomKey = random.nextInt(1000);
        clientMap.submitToKey((Object)randomKey, (EntryProcessor)new NearCacheTestSupport.IncrementEntryProcessor());
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 999L);
            }
        });
    }

    @Test
    public void testAfterSubmitToKeyWithCallbackKeyIsInvalidatedFromNearCache() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName((String)"testAfterSubmitToKeyWithCallbackKeyIsInvalidatedFromNearCache");
        Random random = new Random();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        IMap memberMap = member.getMap(mapName);
        this.populateMap((Map)memberMap, 1000);
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateNearCache((Map)clientMap, 1000);
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutionCallback<Integer> callback = new ExecutionCallback<Integer>(){

            public void onResponse(Integer response) {
                latch.countDown();
            }

            public void onFailure(Throwable t) {
            }
        };
        int randomKey = random.nextInt(1000);
        clientMap.submitToKey((Object)randomKey, (EntryProcessor)new NearCacheTestSupport.IncrementEntryProcessor(), (ExecutionCallback)callback);
        ClientMapNearCacheTest.assertOpenEventually((CountDownLatch)latch);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 999L);
            }
        });
    }

    @Test
    public void testAfterExecuteOnKeyKeyIsInvalidatedFromNearCache() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        Random random = new Random();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        IMap memberMap = member.getMap(mapName);
        this.populateMap((Map)memberMap, 1000);
        HazelcastInstance client = this.getClient(this.hazelcastFactory, this.newInvalidationOnChangeEnabledNearCacheConfig(mapName));
        final IMap clientMap = client.getMap(mapName);
        this.populateNearCache((Map)clientMap, 1000);
        int randomKey = random.nextInt(1000);
        clientMap.executeOnKey((Object)randomKey, (EntryProcessor)new NearCacheTestSupport.IncrementEntryProcessor());
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 999L);
            }
        });
    }

    @Test
    public void testNearCacheIsRemoved_afterMapDestroy() {
        int mapSize = 1000;
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        NearCacheConfig nearCacheConfig = this.newInvalidationOnChangeEnabledNearCacheConfig(mapName);
        HazelcastInstance client = this.getClient(this.hazelcastFactory, nearCacheConfig);
        IMap clientMap = client.getMap(mapName);
        this.populateMap((Map)clientMap, mapSize);
        this.populateNearCache((Map)clientMap, mapSize);
        clientMap.destroy();
        final IMap map = client.getMap(mapName);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(map, 0L);
            }
        });
    }

    @Test
    public void testRemovedKeyValueNotInNearCache() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        int size = 1247;
        this.populateMap((Map)map, size);
        this.populateNearCache((Map)map, size);
        for (int i = 0; i < size; ++i) {
            map.remove((Object)i);
            Assert.assertNull((Object)map.get((Object)i));
        }
    }

    @Test
    public void testNearCachePopulatedAndHitsGenerated() {
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        int size = 1278;
        this.populateMap((Map)map, size);
        this.populateNearCache((Map)map, size);
        for (int i = 0; i < size; ++i) {
            map.get((Object)i);
        }
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertEquals((long)size, (long)stats.getOwnedEntryCount());
        Assert.assertEquals((long)size, (long)stats.getHits());
    }

    @Test
    public void testNearCachePopulatedAndHitsGenerated_withInterleavedCacheHitGeneration() {
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        int size = 1278;
        for (int i = 0; i < size; ++i) {
            map.put((Object)i, (Object)i);
            map.get((Object)i);
            map.get((Object)i);
        }
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertEquals((long)size, (long)stats.getOwnedEntryCount());
        Assert.assertEquals((long)size, (long)stats.getHits());
    }

    @Test
    public void testIssue2009() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertNotNull((Object)stats);
    }

    @Test
    public void testGetNearCacheStatsBeforePopulation() {
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        int size = 101;
        for (int i = 0; i < size; ++i) {
            map.put((Object)i, (Object)i);
        }
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertNotNull((Object)stats);
    }

    @Test
    public void testNearCacheMisses() {
        IMap map = this.getNearCachedMapFromClient(this.newNoInvalidationNearCacheConfig());
        int expectedCacheMisses = 1321;
        for (int i = 0; i < expectedCacheMisses; ++i) {
            map.get((Object)("NOT_THERE" + i));
        }
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertEquals((long)expectedCacheMisses, (long)stats.getMisses());
        Assert.assertEquals((long)expectedCacheMisses, (long)stats.getOwnedEntryCount());
    }

    @Test
    public void testMapRemove_WithNearCache() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        int size = 1113;
        this.populateMap((Map)map, size);
        this.populateNearCache((Map)map, size);
        for (int i = 0; i < size; ++i) {
            map.remove((Object)i);
        }
        NearCacheStats stats = this.getNearCacheStats(map);
        Assert.assertEquals((long)0L, (long)stats.getOwnedEntryCount());
        Assert.assertEquals((long)size, (long)stats.getMisses());
    }

    @Test
    public void testNearCacheTTLExpiration() {
        NearCacheConfig nearCacheConfig = this.newTTLNearCacheConfig();
        this.testClientNearCacheExpiration(nearCacheConfig);
    }

    @Test
    public void testNearCacheMaxIdleRecordsExpired() {
        NearCacheConfig nearCacheConfig = this.newMaxIdleSecondsNearCacheConfig();
        this.testClientNearCacheExpiration(nearCacheConfig);
    }

    private void testClientNearCacheExpiration(NearCacheConfig nearCacheConfig) {
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        IMap serverMap = server.getMap(mapName);
        this.populateMap((Map)serverMap, 1000);
        nearCacheConfig.setName(mapName + "*");
        ClientConfig clientConfig = this.newClientConfig().addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap(mapName);
        this.populateNearCache((Map)clientMap, 1000);
        this.assertNearCacheExpiration(clientMap, 1000, 2);
    }

    @Test
    public void testNearCacheInvalidateOnChange() {
        int i;
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        ClientConfig clientConfig = this.newClientConfig().addNearCacheConfig(this.newInvalidationEnabledNearCacheConfig());
        IMap serverMap = server.getMap(mapName);
        int size = 118;
        for (int i2 = 0; i2 < size; ++i2) {
            serverMap.put((Object)i2, (Object)i2);
        }
        HazelcastInstance newHazelcastClient = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final IMap clientMap = newHazelcastClient.getMap(mapName);
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        this.assertThatOwnedEntryCountEquals(clientMap, size);
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(clientMap, 0L);
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void testNearCacheContainsNullKey() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        map.containsKey(null);
    }

    @Test
    public void testNearCacheContainsKey() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        String key = "key";
        map.put((Object)key, (Object)"value");
        map.get((Object)key);
        Assert.assertTrue((String)String.format("map doesn't contain expected key %s (map size: %d)", key, map.size()), (boolean)map.containsKey((Object)key));
    }

    @Test
    public void testNearCacheContainsKey_whenKeyAbsent() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        Assert.assertFalse((String)String.format("map contains unexpected key NOT_THERE (map size: %d)", map.size()), (boolean)map.containsKey((Object)"NOT_THERE"));
    }

    @Test
    public void testNearCacheContainsKey_afterRemove() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        String key = "key";
        map.put((Object)key, (Object)"value");
        map.get((Object)key);
        map.remove((Object)key);
        Assert.assertFalse((String)String.format("map contains unexpected key %s (map size: %d)", key, map.size()), (boolean)map.containsKey((Object)key));
    }

    @Test
    public void testNearCache_clearFromRemote() {
        String mapName = ClientMapNearCacheTest.randomMapName();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        NearCacheConfig nearCacheConfig = this.newInvalidationEnabledNearCacheConfig();
        ClientConfig clientConfig = this.newClientConfig().addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final IMap map = client.getMap(mapName);
        int size = 147;
        this.populateMap((Map)map, 147);
        this.populateNearCache((Map)map, 147);
        server.getMap(mapName).clear();
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 147; ++i) {
                    Assert.assertNull((Object)map.get((Object)i));
                }
            }
        });
    }

    @Test
    public void testNearCache_clearFromClient() {
        IMap map = this.getNearCachedMapFromClient(this.newInvalidationEnabledNearCacheConfig());
        int size = 147;
        this.populateMap((Map)map, size);
        this.populateNearCache((Map)map, size);
        map.clear();
        for (int i = 0; i < size; ++i) {
            Assert.assertNull((Object)map.get((Object)i));
        }
    }

    @Test
    @Category(value={NightlyTest.class})
    public void ensure_receives_one_clearEvent_after_mapClear_call_from_client() {
        final ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapClearFromClient(handler);
        ClientMapNearCacheTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((String)"Expecting only 1 clear event", (long)1L, (long)handler.getClearEventCount());
            }
        }, (long)10L);
    }

    @Test
    public void receives_one_clearEvent_after_mapClear_call_from_client() {
        ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapClearFromClient(handler);
    }

    private void mapClearFromClient(final ClearEventCounterEventHandler handler) {
        IMap clientMap = this.getNearCachedMapFromClient(this.newNearCacheConfig(), 2);
        this.populateMap((Map)clientMap, 1000);
        this.populateNearCache((Map)clientMap, 1000);
        ((NearCachedClientMapProxy)clientMap).addNearCacheInvalidationListener((EventHandler)handler);
        HazelcastInstance anotherClient = this.hazelcastFactory.newHazelcastClient(this.newClientConfig());
        IMap anotherClientMap = anotherClient.getMap(clientMap.getName());
        anotherClientMap.clear();
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((String)"Expecting at least 1 clear event", (0 < handler.getClearEventCount() ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void receives_one_clearEvent_after_mapClear_call_from_member() {
        ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapClearFromMember(handler);
    }

    @Test
    @Category(value={NightlyTest.class})
    public void ensure_receives_one_clearEvent_after_mapClear_call_from_member() {
        final ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapClearFromMember(handler);
        ClientMapNearCacheTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((String)"Expecting only 1 clear event", (long)1L, (long)handler.getClearEventCount());
            }
        }, (long)10L);
    }

    private void mapClearFromMember(final ClearEventCounterEventHandler handler) {
        IMap clientMap = this.getNearCachedMapFromClient(this.newNearCacheConfig(), 2);
        this.populateMap((Map)clientMap, 1000);
        this.populateNearCache((Map)clientMap, 1000);
        ((NearCachedClientMapProxy)clientMap).addNearCacheInvalidationListener((EventHandler)handler);
        HazelcastInstance member = (HazelcastInstance)this.hazelcastFactory.getAllHazelcastInstances().iterator().next();
        IMap memberMap = member.getMap(clientMap.getName());
        memberMap.clear();
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((String)"Expecting at least 1 clear event", (0 < handler.getClearEventCount() ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void receives_one_clearEvent_after_mapEvictAll_call_from_client() {
        ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapEvictAllFromClient(handler);
    }

    @Test
    @Category(value={NightlyTest.class})
    public void ensure_receives_one_clearEvent_after_mapEvictAll_call_from_client() {
        final ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapEvictAllFromClient(handler);
        ClientMapNearCacheTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((String)"Expecting only 1 clear event", (long)1L, (long)handler.getClearEventCount());
            }
        }, (long)10L);
    }

    private void mapEvictAllFromClient(final ClearEventCounterEventHandler handler) {
        IMap clientMap = this.getNearCachedMapFromClient(this.newNearCacheConfig());
        this.populateMap((Map)clientMap, 1000);
        this.populateNearCache((Map)clientMap, 1000);
        ((NearCachedClientMapProxy)clientMap).addNearCacheInvalidationListener((EventHandler)handler);
        HazelcastInstance anotherClient = this.hazelcastFactory.newHazelcastClient(this.newClientConfig());
        IMap anotherClientMap = anotherClient.getMap(clientMap.getName());
        anotherClientMap.evictAll();
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((String)"Expecting at least 1 clear event", (0 < handler.getClearEventCount() ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void receives_one_clearEvent_after_mapEvictAll_call_from_member() {
        ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapEvictAllFromMember(handler);
    }

    @Test
    @Category(value={NightlyTest.class})
    public void ensure_receives_one_clearEvent_after_mapEvictAll_call_from_member() {
        final ClearEventCounterEventHandler handler = new ClearEventCounterEventHandler();
        this.mapEvictAllFromMember(handler);
        ClientMapNearCacheTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((String)"Expecting only 1 clear event", (long)1L, (long)handler.getClearEventCount());
            }
        }, (long)10L);
    }

    private void mapEvictAllFromMember(final ClearEventCounterEventHandler handler) {
        IMap clientMap = this.getNearCachedMapFromClient(this.newNearCacheConfig(), 2);
        this.populateMap((Map)clientMap, 1000);
        this.populateNearCache((Map)clientMap, 1000);
        ((NearCachedClientMapProxy)clientMap).addNearCacheInvalidationListener((EventHandler)handler);
        HazelcastInstance member = (HazelcastInstance)this.hazelcastFactory.getAllHazelcastInstances().iterator().next();
        IMap memberMap = member.getMap(clientMap.getName());
        memberMap.evictAll();
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((String)"Expecting at least 1 clear event", (0 < handler.getClearEventCount() ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void receives_one_clearEvent_after_mapLoadAll_call_from_client() {
        Config config = this.newConfig();
        config.getMapConfig("default").getMapStoreConfig().setEnabled(true).setImplementation((Object)new NearCacheTestSupport.SimpleMapStore());
        final IMap clientMap = this.getNearCachedMapFromClient(config, this.newNearCacheConfig(), 2);
        this.populateMap((Map)clientMap, 1000);
        this.populateNearCache((Map)clientMap, 1000);
        HazelcastInstance anotherClient = this.hazelcastFactory.newHazelcastClient(this.newClientConfig());
        IMap anotherClientMap = anotherClient.getMap(clientMap.getName());
        anotherClientMap.loadAll(true);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                NearCache nearCache = ((NearCachedClientMapProxy)clientMap).getNearCache();
                for (int i = 0; i < 1000; ++i) {
                    Assert.assertNull((String)"Near Cache should be empty", (Object)nearCache.get((Object)i));
                }
            }
        });
    }

    @Test
    public void receives_one_clearEvent_after_mapLoadAll_call_from_member() {
        Config config = this.newConfig();
        config.getMapConfig("default").getMapStoreConfig().setEnabled(true).setImplementation((Object)new NearCacheTestSupport.SimpleMapStore());
        final IMap clientMap = this.getNearCachedMapFromClient(config, this.newNearCacheConfig(), 2);
        this.populateMap((Map)clientMap, 1000);
        this.populateNearCache((Map)clientMap, 1000);
        HazelcastInstance member = (HazelcastInstance)this.hazelcastFactory.getAllHazelcastInstances().iterator().next();
        IMap memberMap = member.getMap(clientMap.getName());
        memberMap.loadAll(true);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                NearCache nearCache = ((NearCachedClientMapProxy)clientMap).getNearCache();
                for (int i = 0; i < 1000; ++i) {
                    Assert.assertNull((String)"Near Cache should be empty", (Object)nearCache.get((Object)i));
                }
            }
        });
    }

    @Test
    public void testNearCacheInvalidation_WithLFU_whenMaxSizeExceeded() {
        this.assertNearCacheInvalidation_whenMaxSizeExceeded(this.newLFUMaxSizeNearCacheConfig());
    }

    @Test
    public void testNearCacheInvalidation_WithLRU_whenMaxSizeExceeded() {
        this.assertNearCacheInvalidation_whenMaxSizeExceeded(this.newLRUMaxSizeConfig());
    }

    @Test
    public void testNearCacheInvalidation_WithRandom_whenMaxSizeExceeded() {
        this.assertNearCacheInvalidation_whenMaxSizeExceeded(this.newRandomNearCacheConfig());
    }

    @Test
    public void testNearCacheInvalidation_WithNone_whenMaxSizeExceeded() {
        final IMap map = this.getNearCachedMapFromClient(this.newNoneNearCacheConfig());
        int mapSize = 2000;
        this.populateMap((Map)map, mapSize);
        this.populateNearCache((Map)map, mapSize);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountEquals(map, 1000L);
            }
        });
    }

    @Test
    public void testMapDestroy_succeeds_when_writeBehind_and_nearCache_enabled() {
        Config config = this.newConfig();
        config.getMapConfig("default").getMapStoreConfig().setEnabled(true).setWriteDelaySeconds(1).setImplementation((Object)new MapStoreAdapter());
        IMap map = this.getNearCachedMapFromClient(config, this.newInvalidationEnabledNearCacheConfig());
        this.populateMap((Map)map, 10);
        this.populateNearCache((Map)map, 10);
        map.destroy();
    }

    @Test
    public void testNearCacheGetAsyncTwice() throws Exception {
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT);
        IMap map = this.getNearCachedMapFromClient(nearCacheConfig);
        map.getAsync((Object)1).get();
        ClientMapNearCacheTest.sleepMillis((int)1000);
        Assert.assertNull((Object)map.getAsync((Object)1).get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNearCache_whenInMemoryFormatIsNative_thenThrowIllegalArgumentException() {
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig().setInMemoryFormat(InMemoryFormat.NATIVE);
        this.getNearCachedMapFromClient(nearCacheConfig);
    }

    protected NearCacheConfig newNearCacheConfigWithEntryCountEviction(EvictionPolicy evictionPolicy, int size) {
        return super.newNearCacheConfigWithEntryCountEviction(evictionPolicy, size).setCacheLocalEntries(false);
    }

    protected NearCacheConfig newNoneNearCacheConfig() {
        return this.newNearCacheConfigWithEntryCountEviction(EvictionPolicy.NONE, 1000).setInvalidateOnChange(true);
    }

    protected NearCacheConfig newRandomNearCacheConfig() {
        return this.newNearCacheConfigWithEntryCountEviction(EvictionPolicy.RANDOM, 1000).setInvalidateOnChange(true);
    }

    protected NearCacheConfig newLRUMaxSizeConfig() {
        return this.newNearCacheConfigWithEntryCountEviction(EvictionPolicy.LRU, 1000).setInvalidateOnChange(true);
    }

    protected NearCacheConfig newLFUMaxSizeNearCacheConfig() {
        return this.newNearCacheConfigWithEntryCountEviction(EvictionPolicy.LFU, 1000).setInvalidateOnChange(true);
    }

    protected NearCacheConfig newTTLNearCacheConfig() {
        return this.newNearCacheConfig().setInvalidateOnChange(false).setTimeToLiveSeconds(2);
    }

    protected NearCacheConfig newMaxIdleSecondsNearCacheConfig() {
        return this.newNearCacheConfig().setInvalidateOnChange(false).setMaxIdleSeconds(1);
    }

    protected NearCacheConfig newInvalidationEnabledNearCacheConfig() {
        return this.newNearCacheConfig().setInvalidateOnChange(true);
    }

    protected NearCacheConfig newInvalidationOnChangeEnabledNearCacheConfig(String name) {
        return this.newNearCacheConfig().setInvalidateOnChange(true).setName(name);
    }

    protected Config newConfig() {
        return NearCacheTestUtils.getBaseConfig();
    }

    protected NearCacheConfig newNoInvalidationNearCacheConfig() {
        return this.newNearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT).setInvalidateOnChange(false);
    }

    protected HazelcastInstance getClient(TestHazelcastFactory testHazelcastFactory, NearCacheConfig nearCacheConfig) {
        ClientConfig clientConfig = this.newClientConfig().addNearCacheConfig(nearCacheConfig);
        return testHazelcastFactory.newHazelcastClient(clientConfig);
    }

    protected <K, V> IMap<K, V> getNearCachedMapFromClient(NearCacheConfig nearCacheConfig) {
        return this.getNearCachedMapFromClient(this.newConfig(), nearCacheConfig, 1);
    }

    protected <K, V> IMap<K, V> getNearCachedMapFromClient(NearCacheConfig nearCacheConfig, int clusterSize) {
        return this.getNearCachedMapFromClient(this.newConfig(), nearCacheConfig, clusterSize);
    }

    protected <K, V> IMap<K, V> getNearCachedMapFromClient(Config config, NearCacheConfig nearCacheConfig) {
        return this.getNearCachedMapFromClient(config, nearCacheConfig, 1);
    }

    protected <K, V> IMap<K, V> getNearCachedMapFromClient(Config config, NearCacheConfig nearCacheConfig, int clusterSize) {
        String mapName = ClientMapNearCacheTest.randomMapName();
        this.hazelcastFactory.newInstances(config, clusterSize);
        nearCacheConfig.setName(mapName + "*");
        ClientConfig clientConfig = this.newClientConfig().addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        return client.getMap(mapName);
    }

    protected ClientConfig newClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.internal.nearcache.expiration.task.initial.delay.seconds", "0");
        clientConfig.setProperty("hazelcast.internal.nearcache.expiration.task.period.seconds", "1");
        return clientConfig;
    }

    protected void assertNearCacheInvalidation_whenMaxSizeExceeded(NearCacheConfig config) {
        final IMap map = this.getNearCachedMapFromClient(config);
        this.populateMap((Map)map, 1000);
        this.populateNearCache((Map)map, 1000);
        this.triggerEviction(map);
        ClientMapNearCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                ClientMapNearCacheTest.this.assertThatOwnedEntryCountIsSmallerThan(map, 1000L);
            }
        });
    }

    private static class ClearEventCounterEventHandler
    extends MapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final AtomicInteger clearEventCount = new AtomicInteger();

        ClearEventCounterEventHandler() {
        }

        public void handleIMapInvalidationEventV10(Data key) {
            if (key == null) {
                this.clearEventCount.incrementAndGet();
            }
        }

        public void handleIMapInvalidationEventV14(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            if (key == null) {
                this.clearEventCount.incrementAndGet();
            }
        }

        public void handleIMapBatchInvalidationEventV10(Collection<Data> keys) {
        }

        public void handleIMapBatchInvalidationEventV14(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
        }

        public void beforeListenerRegister() {
        }

        public void onListenerRegister() {
        }

        int getClearEventCount() {
            return this.clearEventCount.get();
        }
    }
}

