/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.DataStructureAdapterMethod;
import com.hazelcast.internal.adapter.DataStructureLoader;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.adapter.IMapMapStore;
import com.hazelcast.internal.nearcache.AbstractNearCacheBasicTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.map.impl.nearcache.MapNearCacheBasicTest;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class LiteMemberClientMapNearCacheBasicTest
extends AbstractNearCacheBasicTest<Data, String> {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)NearCacheConfig.DEFAULT_MEMORY_FORMAT, (boolean)false);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected void assumeThatMethodIsAvailable(DataStructureAdapterMethod method) {
        NearCacheTestUtils.assumeThatMethodIsAvailable(IMapDataStructureAdapter.class, (DataStructureAdapterMethod)method);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(boolean loaderEnabled) {
        IMapMapStore mapStore = loaderEnabled ? new IMapMapStore() : null;
        Config config = this.getConfig(mapStore, false);
        ClientConfig clientConfig = this.getClientConfig();
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap("defaultNearCache");
        IMapDataStructureAdapter dataAdapter = new IMapDataStructureAdapter(clientMap);
        dataAdapter.waitUntilLoaded();
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder(mapStore);
        return builder.setDataInstance((HazelcastInstance)client).setDataAdapter((DataStructureAdapter)dataAdapter).setLoader((DataStructureLoader)mapStore).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder(null);
        return builder.build();
    }

    protected Config getConfig() {
        return NearCacheTestUtils.getBaseConfig();
    }

    protected Config getConfig(IMapMapStore mapStore, boolean liteMember) {
        Config config = this.getConfig().setLiteMember(liteMember);
        MapConfig mapConfig = config.getMapConfig("defaultNearCache");
        MapNearCacheBasicTest.addMapStoreConfig((IMapMapStore)mapStore, (MapConfig)mapConfig);
        if (liteMember) {
            mapConfig.setNearCacheConfig(this.nearCacheConfig);
        }
        return config;
    }

    protected ClientConfig getClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.internal.nearcache.expiration.task.initial.delay.seconds", "0");
        clientConfig.setProperty("hazelcast.internal.nearcache.expiration.task.period.seconds", "1");
        return clientConfig;
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder(IMapMapStore mapStore) {
        Config configWithNearCache = this.getConfig(mapStore, true);
        HazelcastInstance liteMember = this.hazelcastFactory.newHazelcastInstance(configWithNearCache);
        IMap liteMemberMap = liteMember.getMap("defaultNearCache");
        MapNearCacheManager nearCacheManager = NearCacheTestUtils.getMapNearCacheManager((HazelcastInstance)liteMember);
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)LiteMemberClientMapNearCacheBasicTest.getSerializationService((HazelcastInstance)liteMember)).setNearCacheInstance(liteMember).setNearCacheAdapter((DataStructureAdapter)new IMapDataStructureAdapter(liteMemberMap)).setNearCache(nearCache).setNearCacheManager((NearCacheManager)nearCacheManager).setLoader((DataStructureLoader)mapStore);
    }
}

