/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationMetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidator;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.RandomPicker;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapInvalidationMetaDataFetcherTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void fetches_sequence_and_uuid() {
        String mapName = "test";
        int partition = 1;
        long givenSequence = RandomPicker.getInt((int)1, (int)Integer.MAX_VALUE);
        UUID givenUuid = UuidUtil.newUnsecureUUID();
        RepairingTask repairingTask = this.getRepairingTask(mapName, partition, givenSequence, givenUuid);
        InvalidationMetaDataFetcher invalidationMetaDataFetcher = repairingTask.getInvalidationMetaDataFetcher();
        ConcurrentMap handlers = repairingTask.getHandlers();
        invalidationMetaDataFetcher.fetchMetadata(handlers);
        RepairingHandler repairingHandler = (RepairingHandler)handlers.get(mapName);
        MetaDataContainer metaDataContainer = repairingHandler.getMetaDataContainer(partition);
        UUID foundUuid = metaDataContainer.getUuid();
        long foundSequence = metaDataContainer.getSequence();
        Assert.assertEquals((long)givenSequence, (long)foundSequence);
        Assert.assertEquals((Object)givenUuid, (Object)foundUuid);
    }

    private RepairingTask getRepairingTask(String mapName, int partition, long givenSequence, UUID givenUuid) {
        Config config = NearCacheTestUtils.getBaseConfig();
        HazelcastInstance member = this.factory.newHazelcastInstance(config);
        this.distortRandomPartitionSequence(mapName, partition, givenSequence, member);
        this.distortRandomPartitionUuid(partition, givenUuid, member);
        ClientConfig clientConfig = new ClientConfig().addNearCacheConfig(new NearCacheConfig(mapName));
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap(mapName);
        ClientContext clientContext = ((ClientProxy)clientMap).getContext();
        return clientContext.getRepairingTask("hz:impl:mapService");
    }

    private void distortRandomPartitionSequence(String mapName, int partition, long sequence, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientMapInvalidationMetaDataFetcherTest.getNodeEngineImpl((HazelcastInstance)member);
        MapService mapService = (MapService)nodeEngineImpl.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        MetaDataGenerator metaDataGenerator = invalidator.getMetaDataGenerator();
        metaDataGenerator.setCurrentSequence(mapName, partition, sequence);
    }

    private void distortRandomPartitionUuid(int partition, UUID uuid, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientMapInvalidationMetaDataFetcherTest.getNodeEngineImpl((HazelcastInstance)member);
        MapService mapService = (MapService)nodeEngineImpl.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        MetaDataGenerator metaDataGenerator = invalidator.getMetaDataGenerator();
        metaDataGenerator.setUuid(partition, uuid);
    }
}

