/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidator;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.nearcache.NearCacheTestSupport;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import com.hazelcast.util.UuidUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientMapInvalidationMetadataDistortionTest
extends NearCacheTestSupport {
    private static final int MAP_SIZE = 100000;
    private static final String MAP_NAME = "ClientMapInvalidationMetadataDistortionTest";
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final AtomicBoolean stopTest = new AtomicBoolean();

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void lostInvalidation() {
        Config config = this.createConfig().addMapConfig(this.createMapConfig(MAP_NAME));
        final HazelcastInstance member = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        final IMap memberMap = member.getMap(MAP_NAME);
        for (int i = 0; i < 100000; ++i) {
            memberMap.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(this.createNearCacheConfig(MAP_NAME));
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        final IMap clientMap = client.getMap(MAP_NAME);
        Thread populateNearCache = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientMapInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    for (int i = 0; i < 100000; ++i) {
                        clientMap.get((Object)i);
                    }
                }
            }
        });
        Thread distortSequence = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientMapInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    ClientMapInvalidationMetadataDistortionTest.this.distortRandomPartitionSequence(ClientMapInvalidationMetadataDistortionTest.MAP_NAME, member);
                    HazelcastTestSupport.sleepSeconds((int)1);
                }
            }
        });
        Thread distortUuid = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientMapInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    ClientMapInvalidationMetadataDistortionTest.this.distortRandomPartitionUuid(member);
                    HazelcastTestSupport.sleepSeconds((int)5);
                }
            }
        });
        Thread put = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ClientMapInvalidationMetadataDistortionTest.this.stopTest.get()) {
                    int key = RandomPicker.getInt((int)100000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberMap.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)100L);
                }
            }
        });
        put.start();
        populateNearCache.start();
        distortSequence.start();
        distortUuid.start();
        ClientMapInvalidationMetadataDistortionTest.sleepSeconds((int)60);
        this.stopTest.set(true);
        ClientMapInvalidationMetadataDistortionTest.assertJoinable((Thread[])new Thread[]{distortUuid, distortSequence, populateNearCache, put});
        ClientMapInvalidationMetadataDistortionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 100000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberMap.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientMap.get((Object)i);
                    Assert.assertEquals((Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }
        });
    }

    private Config createConfig() {
        return ClientMapInvalidationMetadataDistortionTest.smallInstanceConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "271").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), "10");
    }

    private MapConfig createMapConfig(String mapName) {
        return new MapConfig(mapName).setBackupCount(0);
    }

    private NearCacheConfig createNearCacheConfig(String mapName) {
        EvictionConfig evictionConfig = new EvictionConfig().setSize(Integer.MAX_VALUE).setEvictionPolicy(EvictionPolicy.NONE);
        return this.newNearCacheConfig().setName(mapName).setInvalidateOnChange(true).setEvictionConfig(evictionConfig);
    }

    private ClientConfig createClientConfig() {
        return new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0");
    }

    private void distortRandomPartitionSequence(String mapName, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientMapInvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        MapService mapService = (MapService)nodeEngineImpl.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        MetaDataGenerator metaDataGenerator = invalidator.getMetaDataGenerator();
        InternalPartitionService partitionService = nodeEngineImpl.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        metaDataGenerator.setCurrentSequence(mapName, RandomPicker.getInt((int)partitionCount), (long)RandomPicker.getInt((int)Integer.MAX_VALUE));
    }

    private void distortRandomPartitionUuid(HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = ClientMapInvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        int partitionCount = nodeEngineImpl.getPartitionService().getPartitionCount();
        int partitionId = RandomPicker.getInt((int)partitionCount);
        MapService mapService = (MapService)nodeEngineImpl.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        MetaDataGenerator metaDataGenerator = invalidator.getMetaDataGenerator();
        metaDataGenerator.setUuid(partitionId, UuidUtil.newUnsecureUUID());
    }
}

