/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.map.impl.nearcache.invalidation.MemberMapReconciliationTest;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapReconciliationTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "ClientMapReconciliationTest";
    private static final int RECONCILIATION_INTERVAL_SECS = 3;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private ClientConfig clientConfig;
    private IMap<Integer, Integer> serverMap;
    private IMap<Integer, Integer> clientMap;

    @Before
    public void setUp() {
        Config config = NearCacheTestUtils.getBaseConfig().setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE)).setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(Integer.MAX_VALUE));
        NearCacheConfig nearCacheConfig = new NearCacheConfig(MAP_NAME).setInvalidateOnChange(true);
        this.clientConfig = new ClientConfig().setProperty(RepairingTask.MAX_TOLERATED_MISS_COUNT.getName(), "0").setProperty(RepairingTask.RECONCILIATION_INTERVAL_SECONDS.getName(), String.valueOf(3)).setProperty(RepairingTask.MIN_RECONCILIATION_INTERVAL_SECONDS.getName(), String.valueOf(3)).addNearCacheConfig(nearCacheConfig);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.serverMap = server.getMap(MAP_NAME);
        this.clientMap = this.createMapFromNewClient();
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void test_reconciliation_does_not_cause_premature_removal() {
        int i;
        int total = 100;
        for (i = 0; i < total; ++i) {
            this.serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < total; ++i) {
            this.clientMap.get((Object)i);
        }
        IMap<Integer, Integer> mapFromNewClient = this.createMapFromNewClient();
        for (int i2 = 0; i2 < total; ++i2) {
            mapFromNewClient.get((Object)i2);
        }
        NearCacheStats nearCacheStats = mapFromNewClient.getLocalMapStats().getNearCacheStats();
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)0, (int)total);
        ClientMapReconciliationTest.sleepSeconds((int)6);
        for (int i3 = 0; i3 < total; ++i3) {
            mapFromNewClient.get((Object)i3);
        }
        MemberMapReconciliationTest.assertStats((NearCacheStats)nearCacheStats, (int)total, (int)total, (int)total);
    }

    private IMap<Integer, Integer> createMapFromNewClient() {
        HazelcastInstance client = this.factory.newHazelcastClient(this.clientConfig);
        IMap map = client.getMap(MAP_NAME);
        ClientMapReconciliationTest.assertInstanceOf(NearCachedClientMapProxy.class, (Object)map);
        return map;
    }
}

