/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.mapreduce.helpers.Employee;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheListenerTest
extends HazelcastTestSupport {
    private static final Predicate<Integer, Employee> TRUE_PREDICATE = TruePredicate.INSTANCE;
    private static final Predicate<Integer, Integer> INTEGER_TRUE_PREDICATE = TruePredicate.INSTANCE;
    private static TestHazelcastFactory factory = new TestHazelcastFactory();

    @BeforeClass
    public static void setUp() {
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
    }

    @AfterClass
    public static void tearDown() {
        factory.shutdownAll();
    }

    @Test
    public void shouldReceiveEvent_whenListening_withPredicate() {
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance instance = factory.newHazelcastClient();
        IMap map = instance.getMap(mapName);
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        final QueryCacheAdditionListener listener = new QueryCacheAdditionListener();
        cache.addEntryListener((MapListener)listener, (Predicate)new SqlPredicate("id > 100"), true);
        int putCount = 111;
        for (int i = 0; i < 111; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)10L, (long)listener.getAddedEventCount());
            }
        });
    }

    @Test
    public void shouldReceiveEvent_whenListeningKey_withPredicate() {
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance instance = factory.newHazelcastClient();
        IMap map = instance.getMap(mapName);
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        int keyToListen = 109;
        final QueryCacheAdditionListener listener = new QueryCacheAdditionListener();
        cache.addEntryListener((MapListener)listener, (Predicate)new SqlPredicate("id > 100"), (Object)keyToListen, true);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)listener.getAddedEventCount());
            }
        });
    }

    @Test
    public void shouldReceiveEvent_whenListeningKey_withMultipleListener() {
        int i;
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance instance = factory.newHazelcastClient();
        IMap map = instance.getMap(mapName);
        final QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        int keyToListen = 109;
        final QueryCacheAdditionListener addListener = new QueryCacheAdditionListener();
        cache.addEntryListener((MapListener)addListener, (Predicate)new SqlPredicate("id > 100"), (Object)keyToListen, true);
        final QueryCacheRemovalListener removeListener = new QueryCacheRemovalListener();
        cache.addEntryListener((MapListener)removeListener, (Predicate)new SqlPredicate("id > 100"), (Object)keyToListen, true);
        int count = 111;
        for (i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        for (i = 0; i < count; ++i) {
            map.remove((Object)i);
        }
        for (i = 0; i < count; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        for (i = 0; i < count; ++i) {
            map.remove((Object)i);
        }
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                int cacheSize = cache.size();
                String message = "Cache size is=" + cacheSize;
                Assert.assertEquals((String)message, (long)0L, (long)cacheSize);
                Assert.assertEquals((String)message, (long)2L, (long)addListener.getAddedEventCount());
                Assert.assertEquals((String)message, (long)2L, (long)removeListener.getRemovedEventCount());
            }
        });
    }

    @Test
    public void shouldReceiveValue_whenIncludeValue_enabled() {
        boolean includeValue = true;
        this.testIncludeValue(includeValue);
    }

    @Test
    public void shouldNotReceiveValue_whenIncludeValue_disabled() {
        boolean includeValue = false;
        this.testIncludeValue(includeValue);
    }

    @Test
    public void listenerShouldBeRegistered_whenConfiguredProgrammatically() {
        int valueCount = 100;
        String mapName = ClientQueryCacheListenerTest.randomString();
        String qcName = ClientQueryCacheListenerTest.randomString();
        final QueryCacheAdditionListener listener = new QueryCacheAdditionListener();
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(qcName).setPredicateConfig(new PredicateConfig(TRUE_PREDICATE)).addEntryListenerConfig(new EntryListenerConfig((MapListener)listener, true, true));
        ClientConfig config = new ClientConfig().addQueryCacheConfig(mapName, queryCacheConfig);
        HazelcastInstance instance = factory.newHazelcastClient(config);
        IMap map = instance.getMap(mapName);
        map.getQueryCache(qcName);
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)100L, (long)listener.getAddedEventCount());
            }
        });
    }

    private void testIncludeValue(final boolean includeValue) {
        String mapName = ClientQueryCacheListenerTest.randomString();
        String cacheName = ClientQueryCacheListenerTest.randomString();
        HazelcastInstance client = factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        final QueryCache cache = map.getQueryCache(cacheName, INTEGER_TRUE_PREDICATE, true);
        final TestIncludeValueListener listener = new TestIncludeValueListener();
        cache.addEntryListener((MapListener)listener, includeValue);
        int putCount = 10;
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)i);
        }
        ClientQueryCacheListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)10L, (long)cache.size());
                if (includeValue) {
                    Assert.assertTrue((String)"There should not be any null value", (boolean)listener.hasValue);
                } else {
                    Assert.assertFalse((String)"There should not be any non-null value", (boolean)listener.hasValue);
                }
            }
        });
    }

    private class QueryCacheRemovalListener
    implements EntryRemovedListener {
        private final AtomicInteger removedEventCount = new AtomicInteger(0);

        QueryCacheRemovalListener() {
        }

        public void entryRemoved(EntryEvent event) {
            this.removedEventCount.incrementAndGet();
        }

        public int getRemovedEventCount() {
            return this.removedEventCount.get();
        }
    }

    private class QueryCacheAdditionListener
    implements EntryAddedListener {
        private final AtomicInteger addedEventCount = new AtomicInteger(0);

        QueryCacheAdditionListener() {
        }

        public void entryAdded(EntryEvent event) {
            this.addedEventCount.incrementAndGet();
        }

        public int getAddedEventCount() {
            return this.addedEventCount.get();
        }
    }

    private class TestIncludeValueListener
    implements EntryAddedListener {
        volatile boolean hasValue = false;

        private TestIncludeValueListener() {
        }

        public void entryAdded(EntryEvent event) {
            Object value = event.getValue();
            this.hasValue = value != null;
        }
    }
}

