/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheRecreationTest
extends HazelcastTestSupport {
    private final String mapName = "mapName";
    private final String queryCacheName = "queryCacheName";
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance server;

    protected Config getConfig() {
        return ClientQueryCacheRecreationTest.smallInstanceConfig();
    }

    @Before
    public void setUp() {
        this.server = this.factory.newHazelcastInstance(this.getConfig());
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig("queryCacheName");
        ClientConfig config = new ClientConfig();
        config.addQueryCacheConfig("mapName", queryCacheConfig);
        config.getConnectionStrategyConfig().getConnectionRetryConfig().setEnabled(true).setMaxBackoffMillis((int)TimeUnit.SECONDS.toMillis(5L));
        this.client = this.factory.newHazelcastClient(config);
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void query_cache_recreates_itself_after_server_restart() {
        int i;
        IMap map = this.client.getMap("mapName");
        for (int i2 = 0; i2 < 100; ++i2) {
            map.put((Object)i2, (Object)i2);
        }
        final QueryCache queryCache = map.getQueryCache("queryCacheName", Predicates.alwaysTrue(), true);
        for (i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
        this.server.shutdown();
        this.server = this.factory.newHazelcastInstance(this.getConfig());
        for (i = 100; i < 200; ++i) {
            map.put((Object)i, (Object)i);
        }
        InternalQueryCache internalQueryCache = (InternalQueryCache)queryCache;
        internalQueryCache.recreate();
        for (int i3 = 200; i3 < 300; ++i3) {
            map.put((Object)i3, (Object)i3);
        }
        ClientQueryCacheRecreationTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                TestCase.assertEquals((int)200, (int)queryCache.size());
            }
        });
        Set keySet = queryCache.keySet();
        for (int i4 = 0; i4 < 300; ++i4) {
            if (i4 < 100) {
                TestCase.assertFalse((boolean)keySet.contains(i4));
                continue;
            }
            TestCase.assertTrue((boolean)keySet.contains(i4));
        }
    }

    @Test
    public void listeners_still_works_after_query_cache_recreation() {
        IMap map = this.client.getMap("mapName");
        QueryCache queryCache = map.getQueryCache("queryCacheName", Predicates.alwaysTrue(), true);
        final AtomicInteger entryAddedCounter = new AtomicInteger();
        queryCache.addEntryListener((MapListener)new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                entryAddedCounter.incrementAndGet();
            }
        }, (Predicate)new SqlPredicate("__key >= 10"), true);
        this.server.shutdown();
        this.server = this.factory.newHazelcastInstance(this.getConfig());
        ((InternalQueryCache)queryCache).recreate();
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
        AssertTask assertTask = new AssertTask(){

            public void run() {
                TestCase.assertEquals((int)90, (int)entryAddedCounter.get());
            }
        };
        ClientQueryCacheRecreationTest.assertTrueEventually((AssertTask)assertTask);
        ClientQueryCacheRecreationTest.assertTrueAllTheTime((AssertTask)assertTask, (long)3L);
    }
}

