/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheUpdateTest
extends HazelcastTestSupport {
    private final String mapName = "mapName";
    private final String queryCacheName = "queryCacheName";
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void setUp() {
        this.factory.newHazelcastInstance(this.getConfig());
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig("queryCacheName");
        queryCacheConfig.getPredicateConfig().setImplementation((Predicate)new SqlPredicate("id=1"));
        ClientConfig config = new ClientConfig();
        config.addQueryCacheConfig("mapName", queryCacheConfig);
        this.client = this.factory.newHazelcastClient(config);
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void query_cache_gets_latest_updated_value_when_map_is_updated_via_set_method() {
        IMap clientMap = this.client.getMap("mapName");
        final QueryCache queryCache = clientMap.getQueryCache("queryCacheName");
        int id = 1;
        for (int value = 0; value < 10; ++value) {
            clientMap.set((Object)id, (Object)new IdWrapper(id, value));
        }
        ClientQueryCacheUpdateTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                IdWrapper idWrapper = (IdWrapper)queryCache.get((Object)1);
                Assert.assertNotNull((Object)idWrapper);
                Assert.assertEquals((long)9L, (long)idWrapper.value);
            }
        });
    }

    public static class IdWrapper
    implements Serializable {
        public int id;
        public int value;

        public IdWrapper(int id, int value) {
            this.id = id;
            this.value = value;
        }
    }
}

