/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache.subscriber;

import com.hazelcast.client.impl.querycache.subscriber.ClientSubscriberContext;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.accumulator.Accumulator;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.event.DefaultQueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.sequence.Sequenced;
import com.hazelcast.map.impl.querycache.subscriber.MapSubscriberRegistry;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberAccumulator;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberAccumulatorFactory;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberRegistry;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TestClientSubscriberContext
extends ClientSubscriberContext {
    private final MapSubscriberRegistry mapSubscriberRegistry;
    private final int eventCount;
    private final boolean allowEventLoss;

    public TestClientSubscriberContext(QueryCacheContext context, int eventCount, boolean allowEventLoss) {
        super(context);
        this.eventCount = eventCount;
        this.allowEventLoss = allowEventLoss;
        this.mapSubscriberRegistry = new TestMapSubscriberRegistry(context);
    }

    public MapSubscriberRegistry getMapSubscriberRegistry() {
        return this.mapSubscriberRegistry;
    }

    private class TestSubscriberAccumulator
    extends SubscriberAccumulator {
        private final Set<Long> lostSequenceNumber;

        TestSubscriberAccumulator(QueryCacheContext context, AccumulatorInfo info) {
            super(context, info);
            this.lostSequenceNumber = Collections.newSetFromMap(new ConcurrentHashMap());
            if (TestClientSubscriberContext.this.allowEventLoss) {
                this.lostSequenceNumber.add((long)new Random().nextInt(TestClientSubscriberContext.this.eventCount) + 1L);
            }
        }

        protected boolean isNextEvent(Sequenced event) {
            DefaultQueryCacheEventData eventData = (DefaultQueryCacheEventData)event;
            if (this.lostSequenceNumber.remove(event.getSequence())) {
                DefaultQueryCacheEventData copy = new DefaultQueryCacheEventData(eventData);
                copy.setSequence(eventData.getSequence() * 2L);
                eventData = copy;
            }
            return super.isNextEvent((Sequenced)eventData);
        }

        public void reset() {
            this.lostSequenceNumber.clear();
            super.reset();
        }
    }

    private class TestSubscriberAccumulatorFactory
    extends SubscriberAccumulatorFactory {
        TestSubscriberAccumulatorFactory(QueryCacheContext context) {
            super(context);
        }

        public Accumulator createAccumulator(AccumulatorInfo info) {
            return new TestSubscriberAccumulator(this.getContext(), info);
        }
    }

    private class TestSubscriberRegistry
    extends SubscriberRegistry {
        TestSubscriberRegistry(QueryCacheContext context, String mapName) {
            super(context, mapName);
        }

        protected SubscriberAccumulatorFactory createSubscriberAccumulatorFactory() {
            return new TestSubscriberAccumulatorFactory(this.getContext());
        }
    }

    private class TestMapSubscriberRegistry
    extends MapSubscriberRegistry {
        TestMapSubscriberRegistry(QueryCacheContext context) {
            super(context);
        }

        protected SubscriberRegistry createSubscriberRegistry(String mapName) {
            return new TestSubscriberRegistry(this.getContext(), mapName);
        }
    }
}

