/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce;

import com.hazelcast.client.mapreduce.AbstractClientMapReduceJobTest;
import com.hazelcast.client.mapreduce.ClientMapReduceTest;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.Combiner;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Context;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.Reducer;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
@Ignore
public class DistributedMapperClientMapReduceTest
extends AbstractClientMapReduceJobTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(timeout=120000L)
    public void testMapperReducer() throws Exception {
        int i;
        Config config = this.buildConfig();
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h3 = this.hazelcastFactory.newHazelcastInstance(config);
        DistributedMapperClientMapReduceTest.assertClusterSize((int)3, (HazelcastInstance[])new HazelcastInstance[]{h1, h3});
        DistributedMapperClientMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{h2});
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(null);
        IMap m1 = client.getMap(DistributedMapperClientMapReduceTest.randomString());
        for (int i2 = 0; i2 < 100; ++i2) {
            m1.put((Object)i2, (Object)i2);
        }
        JobTracker tracker = client.getJobTracker("default");
        Job job = tracker.newJob(ClientMapReduceTest.integerKvSource((IMap<Integer, Integer>)m1));
        JobCompletableFuture future = job.mapper((Mapper)new GroupingTestMapper()).combiner((CombinerFactory)new TestCombinerFactory()).reducer((ReducerFactory)new TestReducerFactory()).submit();
        Map result = (Map)future.get();
        int[] expectedResults = new int[4];
        for (i = 0; i < 100; ++i) {
            int index;
            int n = index = i % 4;
            expectedResults[n] = expectedResults[n] + i;
        }
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals((long)expectedResults[i], (long)((Integer)result.get(String.valueOf(i))).intValue());
        }
    }

    @Test(timeout=120000L)
    public void testMapperReducerCollator() throws Exception {
        int i;
        Config config = this.buildConfig();
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h3 = this.hazelcastFactory.newHazelcastInstance(config);
        DistributedMapperClientMapReduceTest.assertClusterSize((int)3, (HazelcastInstance[])new HazelcastInstance[]{h1, h3});
        DistributedMapperClientMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{h2});
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(null);
        IMap m1 = client.getMap(DistributedMapperClientMapReduceTest.randomString());
        for (int i2 = 0; i2 < 100; ++i2) {
            m1.put((Object)i2, (Object)i2);
        }
        JobTracker tracker = client.getJobTracker("default");
        Job job = tracker.newJob(ClientMapReduceTest.integerKvSource((IMap<Integer, Integer>)m1));
        JobCompletableFuture future = job.mapper((Mapper)new GroupingTestMapper()).combiner((CombinerFactory)new TestCombinerFactory()).reducer((ReducerFactory)new TestReducerFactory()).submit((Collator)new TestCollator());
        int result = (Integer)future.get();
        int expectedResult = 0;
        for (i = 0; i < 100; ++i) {
            expectedResult += i;
        }
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals((long)expectedResult, (long)result);
        }
    }

    @Test(timeout=120000L)
    public void testAsyncMapperReducer() throws Exception {
        int i;
        Config config = this.buildConfig();
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h3 = this.hazelcastFactory.newHazelcastInstance(config);
        DistributedMapperClientMapReduceTest.assertClusterSize((int)3, (HazelcastInstance[])new HazelcastInstance[]{h1, h3});
        DistributedMapperClientMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{h2});
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(null);
        IMap m1 = client.getMap(DistributedMapperClientMapReduceTest.randomString());
        for (int i2 = 0; i2 < 100; ++i2) {
            m1.put((Object)i2, (Object)i2);
        }
        final HashMap listenerResults = new HashMap();
        final Semaphore semaphore = new Semaphore(1);
        semaphore.acquire();
        JobTracker tracker = client.getJobTracker("default");
        Job job = tracker.newJob(ClientMapReduceTest.integerKvSource((IMap<Integer, Integer>)m1));
        JobCompletableFuture future = job.mapper((Mapper)new GroupingTestMapper()).combiner((CombinerFactory)new TestCombinerFactory()).reducer((ReducerFactory)new TestReducerFactory()).submit();
        future.andThen((ExecutionCallback)new ExecutionCallback<Map<String, Integer>>(){

            public void onResponse(Map<String, Integer> response) {
                try {
                    listenerResults.putAll(response);
                }
                finally {
                    semaphore.release();
                }
            }

            public void onFailure(Throwable t) {
                semaphore.release();
            }
        });
        int[] expectedResults = new int[4];
        for (i = 0; i < 100; ++i) {
            int index;
            int n = index = i % 4;
            expectedResults[n] = expectedResults[n] + i;
        }
        semaphore.acquire();
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals((long)expectedResults[i], (long)((Integer)listenerResults.get(String.valueOf(i))).intValue());
        }
    }

    @Test(timeout=120000L)
    public void testAsyncMapperReducerCollator() throws Exception {
        int i;
        Config config = this.buildConfig();
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h3 = this.hazelcastFactory.newHazelcastInstance(config);
        DistributedMapperClientMapReduceTest.assertClusterSize((int)3, (HazelcastInstance[])new HazelcastInstance[]{h1, h3});
        DistributedMapperClientMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{h2});
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(null);
        IMap m1 = client.getMap(DistributedMapperClientMapReduceTest.randomString());
        for (int i2 = 0; i2 < 100; ++i2) {
            m1.put((Object)i2, (Object)i2);
        }
        final int[] result = new int[1];
        final Semaphore semaphore = new Semaphore(1);
        semaphore.acquire();
        JobTracker tracker = client.getJobTracker("default");
        Job job = tracker.newJob(ClientMapReduceTest.integerKvSource((IMap<Integer, Integer>)m1));
        JobCompletableFuture future = job.mapper((Mapper)new GroupingTestMapper()).combiner((CombinerFactory)new TestCombinerFactory()).reducer((ReducerFactory)new TestReducerFactory()).submit((Collator)new TestCollator());
        future.andThen((ExecutionCallback)new ExecutionCallback<Integer>(){

            public void onResponse(Integer response) {
                try {
                    result[0] = response;
                }
                finally {
                    semaphore.release();
                }
            }

            public void onFailure(Throwable t) {
                semaphore.release();
            }
        });
        int expectedResult = 0;
        for (i = 0; i < 100; ++i) {
            expectedResult += i;
        }
        semaphore.acquire();
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals((long)expectedResult, (long)result[0]);
        }
    }

    public static class TestCollator
    implements Collator<Map.Entry<String, Integer>, Integer> {
        public Integer collate(Iterable<Map.Entry<String, Integer>> values) {
            int sum = 0;
            for (Map.Entry<String, Integer> entry : values) {
                sum += entry.getValue().intValue();
            }
            return sum;
        }
    }

    public static class TestReducerFactory
    implements ReducerFactory<String, Integer, Integer> {
        public Reducer<Integer, Integer> newReducer(String key) {
            return new TestReducer();
        }
    }

    public static class TestReducer
    extends Reducer<Integer, Integer> {
        private int sum;

        public void reduce(Integer value) {
            this.sum += value.intValue();
        }

        public Integer finalizeReduce() {
            return this.sum;
        }
    }

    public static class GroupingTestMapper
    implements Mapper<Integer, Integer, String, Integer> {
        public void map(Integer key, Integer value, Context<String, Integer> collector) {
            collector.emit((Object)String.valueOf(key % 4), (Object)value);
        }
    }

    public static class TestCombinerFactory
    implements CombinerFactory<String, Integer, Integer> {
        public Combiner<Integer, Integer> newCombiner(String key) {
            return new TestCombiner();
        }
    }

    public static class TestCombiner
    extends Combiner<Integer, Integer> {
        private transient int sum;

        public void combine(Integer value) {
            this.sum += value.intValue();
        }

        public Integer finalizeChunk() {
            int v = this.sum;
            this.sum = 0;
            return v;
        }
    }
}

