/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.partitionservice;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class PartitionServiceProxyTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddMigrationListener() throws Exception {
        PartitionService p = this.client.getPartitionService();
        p.addMigrationListener((MigrationListener)new DumMigrationListener());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveMigrationListener() throws Exception {
        PartitionService p = this.client.getPartitionService();
        p.removeMigrationListener("");
    }

    @Test
    public void testRandomPartitionKeyNotNull() {
        PartitionService p = this.client.getPartitionService();
        String key = p.randomPartitionKey();
        Assert.assertNotNull((Object)key);
    }

    @Test
    public void testGetPartition() {
        String key = "Key";
        PartitionService clientPartitionService = this.client.getPartitionService();
        Partition clientPartition = clientPartitionService.getPartition((Object)key);
        PartitionService serverPartitionService = this.server.getPartitionService();
        Partition serverPartition = serverPartitionService.getPartition((Object)key);
        Assert.assertEquals((long)clientPartition.getPartitionId(), (long)serverPartition.getPartitionId());
    }

    @Test
    public void testGetPartitions() {
        String key = "Key";
        PartitionService clientPartitionService = this.client.getPartitionService();
        Set clientPartitions = clientPartitionService.getPartitions();
        PartitionService serverPartitionService = this.server.getPartitionService();
        Set serverPartitions = serverPartitionService.getPartitions();
        Assert.assertEquals((long)clientPartitions.size(), (long)serverPartitions.size());
    }

    class DumMigrationListener
    implements MigrationListener {
        DumMigrationListener() {
        }

        public void migrationStarted(MigrationEvent migrationEvent) {
        }

        public void migrationCompleted(MigrationEvent migrationEvent) {
        }

        public void migrationFailed(MigrationEvent migrationEvent) {
        }
    }
}

