/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.projection;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.projection.MapProjectionTest;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapProjectionTest
extends MapProjectionTest {
    private TestHazelcastFactory factory;

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    public <K, V> IMap<K, V> getMapWithNodeCount(int nodeCount) {
        if (nodeCount < 1) {
            throw new IllegalArgumentException("node count < 1");
        }
        this.factory = new TestHazelcastFactory();
        MapConfig mapConfig = new MapConfig().setName("aggr").setInMemoryFormat(InMemoryFormat.OBJECT);
        Config config = new Config().setProperty(GroupProperty.PARTITION_COUNT.getName(), "3").addMapConfig(mapConfig);
        this.factory.newInstances(config, nodeCount);
        HazelcastInstance client = this.factory.newHazelcastClient();
        return client.getMap("aggr");
    }
}

