/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionOptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientClusterProxyTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory;

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    private HazelcastInstance client() {
        this.factory = new TestHazelcastFactory();
        Config config = new Config();
        String groupAName = "HZ:GROUP";
        config.getGroupConfig().setName(groupAName);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setGroupConfig(new GroupConfig(config.getGroupConfig().getName()));
        return this.factory.newHazelcastClient(clientConfig);
    }

    @Test
    public void addMembershipListener() throws Exception {
        String regId = this.client().getCluster().addMembershipListener((MembershipListener)new MembershipAdapter());
        Assert.assertNotNull((Object)regId);
    }

    @Test
    public void removeMembershipListener() throws Exception {
        Cluster cluster = this.client().getCluster();
        String regId = cluster.addMembershipListener((MembershipListener)new MembershipAdapter());
        Assert.assertTrue((boolean)cluster.removeMembershipListener(regId));
    }

    @Test
    public void getMembers() throws Exception {
        Assert.assertEquals((long)1L, (long)this.client().getCluster().getMembers().size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getLocalMember() throws Exception {
        this.client().getCluster().getLocalMember();
    }

    @Test
    public void getClusterTime() throws Exception {
        Assert.assertTrue((this.client().getCluster().getClusterTime() > 0L ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getClusterState() throws Exception {
        this.client().getCluster().getClusterState();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void changeClusterState() throws Exception {
        this.client().getCluster().changeClusterState(ClusterState.FROZEN);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getClusterVersion() throws Exception {
        this.client().getCluster().getClusterVersion();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void changeClusterStateWithOptions() throws Exception {
        this.client().getCluster().changeClusterState(ClusterState.FROZEN, new TransactionOptions());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shutdown() throws Exception {
        this.client().getCluster().shutdown();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shutdownWithOptions() throws Exception {
        this.client().getCluster().shutdown(new TransactionOptions());
    }
}

