/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.ClientTestUtil;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ProxyManagerTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory;

    @Before
    public void init() {
        this.factory = new TestHazelcastFactory();
    }

    @After
    public void destroy() {
        this.factory.terminateAll();
    }

    @Test
    public void testNextAddressToSendCreateRequestOnSingleDataMember() {
        List<HazelcastInstance> instances = this.createNodes(3, 1);
        Address dataInstanceAddress = ProxyManagerTest.getAddress((HazelcastInstance)instances.get(3));
        HazelcastInstance client = this.factory.newHazelcastClient();
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        ProxyManager proxyManager = clientInstanceImpl.getProxyManager();
        for (int i = 0; i < instances.size(); ++i) {
            Assert.assertEquals((Object)dataInstanceAddress, (Object)proxyManager.findNextAddressToSendCreateRequest());
        }
    }

    @Test
    public void testNextAddressToSendCreateRequestOnMultipleDataMembers() {
        List<HazelcastInstance> instances = this.createNodes(3, 3);
        HazelcastInstance client = this.factory.newHazelcastClient();
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        HashSet<Address> addresses = new HashSet<Address>();
        ProxyManager proxyManager = clientInstanceImpl.getProxyManager();
        for (int i = 0; i < instances.size() * 100; ++i) {
            addresses.add(proxyManager.findNextAddressToSendCreateRequest());
        }
        Assert.assertEquals((long)3L, (long)addresses.size());
        for (HazelcastInstance lite : instances.subList(3, 6)) {
            ProxyManagerTest.assertContains(addresses, (Object)ProxyManagerTest.getAddress((HazelcastInstance)lite));
        }
    }

    @Test
    public void testNextAddressToSendCreateRequestOnMultipleLiteMembers() {
        List<HazelcastInstance> instances = this.createNodes(3, 0);
        HazelcastInstance client = this.factory.newHazelcastClient();
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        HashSet<Address> addresses = new HashSet<Address>();
        ProxyManager proxyManager = clientInstanceImpl.getProxyManager();
        for (int i = 0; i < instances.size() * 100; ++i) {
            addresses.add(proxyManager.findNextAddressToSendCreateRequest());
        }
        Assert.assertEquals((long)1L, (long)addresses.size());
    }

    private List<HazelcastInstance> createNodes(int numberOfLiteNodes, int numberOfDataNodes) {
        int i;
        ArrayList<HazelcastInstance> instances = new ArrayList<HazelcastInstance>();
        Config liteConfig = new Config().setLiteMember(true);
        for (i = 0; i < numberOfLiteNodes; ++i) {
            instances.add(this.factory.newHazelcastInstance(liteConfig));
        }
        for (i = 0; i < numberOfDataNodes; ++i) {
            instances.add(this.factory.newHazelcastInstance());
        }
        int clusterSize = numberOfLiteNodes + numberOfDataNodes;
        for (HazelcastInstance instance : instances) {
            ProxyManagerTest.assertClusterSizeEventually((int)clusterSize, (HazelcastInstance[])new HazelcastInstance[]{instance});
        }
        return instances;
    }

    @Test(expected=OperationTimeoutException.class)
    public void testProxyCreateTimeout_whenClusterIsNotReachable() {
        HazelcastInstance instance = this.factory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "1");
        config.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.factory.newHazelcastClient(config);
        instance.shutdown();
        client.getMap("test");
    }
}

