/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.queue;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueueTest
extends HazelcastTestSupport {
    private static final int MAX_SIZE_FOR_QUEUE = 8;
    private static final String QUEUE_WITH_MAX_SIZE = "queueWithMaxSize*";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void setup() {
        Config config = new Config();
        QueueConfig queueConfig = config.getQueueConfig(QUEUE_WITH_MAX_SIZE);
        queueConfig.setMaxSize(8);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testOffer() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Assert.assertTrue((boolean)q.offer((Object)1));
        Assert.assertEquals((long)1L, (long)q.size());
    }

    @Test(expected=NullPointerException.class)
    public void testOffer_whenNullItem() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer(null);
    }

    @Test(expected=NullPointerException.class)
    public void testOfferWithTimeout_whenNullItem() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer(null, 1L, TimeUnit.SECONDS);
    }

    @Test
    public void testAdd() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Assert.assertTrue((boolean)q.add((Object)1));
        Assert.assertEquals((long)1L, (long)q.size());
    }

    @Test
    public void testAdd_whenReachingMaximumCapacity() {
        IQueue q = this.client.getQueue(QUEUE_WITH_MAX_SIZE + ClientQueueTest.randomString());
        for (int i = 0; i < 8; ++i) {
            q.add((Object)1);
        }
        Assert.assertEquals((long)8L, (long)q.size());
    }

    @Test(expected=IllegalStateException.class)
    public void testAdd_whenExceedingMaximumCapacity() {
        IQueue q = this.client.getQueue(QUEUE_WITH_MAX_SIZE + ClientQueueTest.randomString());
        for (int i = 0; i < 8; ++i) {
            q.add((Object)1);
        }
        q.add((Object)1);
    }

    @Test(expected=NullPointerException.class)
    public void testAdd_whenNullItem() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.add(null);
    }

    @Test
    public void testPut() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.put((Object)1);
        Assert.assertEquals((long)1L, (long)q.size());
    }

    @Test(expected=NullPointerException.class)
    public void testPut_whenNullItem() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.put(null);
    }

    @Test
    public void testTake() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.put((Object)1);
        Assert.assertEquals((long)1L, (long)((Integer)q.take()).intValue());
    }

    @Test(expected=InterruptedException.class)
    public void testTake_whenInterruptedWhileBlocking() throws InterruptedException {
        IQueue queue = this.client.getQueue(ClientQueueTest.randomString());
        ClientQueueTest.interruptCurrentThread((int)2000);
        queue.take();
    }

    @Test
    public void testEmptyPeak() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Assert.assertNull((Object)q.peek());
    }

    @Test
    public void testPeak() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        Assert.assertEquals((long)1L, (long)((Integer)q.peek()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)q.peek()).intValue());
        Assert.assertEquals((long)1L, (long)q.size());
    }

    @Test(expected=NoSuchElementException.class)
    public void testEmptyElement() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.element();
    }

    @Test
    public void testElement() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        Assert.assertEquals((long)1L, (long)((Integer)q.element()).intValue());
    }

    @Test
    public void testPoll() throws InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        Assert.assertEquals((long)1L, (long)((Integer)q.poll()).intValue());
    }

    @Test(expected=InterruptedException.class)
    public void testPoll_whenInterruptedWhileBlocking() throws InterruptedException {
        IQueue queue = this.client.getQueue(ClientQueueTest.randomString());
        ClientQueueTest.interruptCurrentThread((int)2000);
        queue.poll(1L, TimeUnit.MINUTES);
    }

    @Test
    public void testOfferWithTimeOut() throws IOException, InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        boolean result = q.offer((Object)1, 50L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testRemainingCapacity() throws IOException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)q.remainingCapacity());
        q.offer((Object)"one");
        Assert.assertEquals((long)0x7FFFFFFEL, (long)q.remainingCapacity());
    }

    @Test(expected=NoSuchElementException.class)
    public void testEmptyRemove() throws IOException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.remove();
    }

    @Test
    public void testRemoveTop() throws IOException, InterruptedException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        Assert.assertEquals((long)1L, (long)((Integer)q.remove()).intValue());
    }

    @Test
    public void testRemove() throws IOException {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        Assert.assertTrue((boolean)q.remove((Object)1));
        Assert.assertFalse((boolean)q.remove((Object)2));
    }

    @Test
    public void testContains() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        ClientQueueTest.assertContains((Collection)q, (Object)1);
        ClientQueueTest.assertNotContains((Collection)q, (Object)2);
    }

    @Test
    public void testContainsAll() {
        int maxItems = 11;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        ArrayList<Integer> trueList = new ArrayList<Integer>();
        ArrayList<Integer> falseList = new ArrayList<Integer>();
        for (int i = 0; i < 11; ++i) {
            q.offer((Object)i);
            trueList.add(i);
            falseList.add(i + 1);
        }
        ClientQueueTest.assertContainsAll((Collection)q, trueList);
        ClientQueueTest.assertNotContainsAll((Collection)q, falseList);
    }

    @Test
    public void testDrain() {
        int maxItems = 12;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> offeredList = new LinkedList<Integer>();
        for (int i = 0; i < 12; ++i) {
            q.offer((Object)i);
            offeredList.add(i);
        }
        LinkedList drainedList = new LinkedList();
        int totalDrained = q.drainTo(drainedList);
        Assert.assertEquals((long)12L, (long)totalDrained);
        Assert.assertEquals(offeredList, drainedList);
    }

    @Test
    public void testPartialDrain() {
        int maxItems = 15;
        int itemsToDrain = 7;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> expectedList = new LinkedList<Integer>();
        for (int i = 0; i < 15; ++i) {
            q.offer((Object)i);
            if (i >= 7) continue;
            expectedList.add(i);
        }
        LinkedList drainedList = new LinkedList();
        int totalDrained = q.drainTo(drainedList, 7);
        Assert.assertEquals((long)7L, (long)totalDrained);
        Assert.assertEquals(expectedList, drainedList);
    }

    @Test
    public void testIterator() {
        int i;
        int maxItems = 18;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        for (i = 0; i < 18; ++i) {
            q.offer((Object)i);
        }
        i = 0;
        for (Object o : q) {
            Assert.assertEquals((Object)i++, o);
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testQueueRemoveFromIterator() {
        IQueue queue = this.client.getQueue(ClientQueueTest.randomString());
        queue.add((Object)"one");
        Iterator iterator = queue.iterator();
        iterator.next();
        iterator.remove();
    }

    @Test
    public void testToArray() {
        int maxItems = 19;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Object[] offered = new Object[19];
        for (int i = 0; i < 19; ++i) {
            q.offer((Object)i);
            offered[i] = i;
        }
        Object[] result = q.toArray();
        Assert.assertArrayEquals((Object[])offered, (Object[])result);
    }

    @Test
    public void testToEmptyArray() {
        int maxItems = 23;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Object[] offered = new Object[23];
        for (int i = 0; i < 23; ++i) {
            q.offer((Object)i);
            offered[i] = i;
        }
        Object[] result = q.toArray(new Object[0]);
        Assert.assertArrayEquals((Object[])offered, (Object[])result);
    }

    @Test
    public void testToPreSizedArray() {
        int maxItems = 74;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Object[] offered = new Object[74];
        for (int i = 0; i < 74; ++i) {
            q.offer((Object)i);
            offered[i] = i;
        }
        Object[] result = q.toArray(new Object[37]);
        Assert.assertArrayEquals((Object[])offered, (Object[])result);
    }

    @Test
    public void testAddAll() throws IOException {
        int maxItems = 13;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        ArrayList<Integer> coll = new ArrayList<Integer>(13);
        for (int i = 0; i < 13; ++i) {
            coll.add(i);
        }
        Assert.assertTrue((boolean)q.addAll(coll));
        Assert.assertEquals((long)coll.size(), (long)q.size());
        ArrayList actual = new ArrayList();
        actual.addAll(q);
        Assert.assertEquals(coll, actual);
    }

    @Test
    public void testRemoveList() throws IOException {
        int maxItems = 131;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> removeList = new LinkedList<Integer>();
        for (int i = 0; i < 131; ++i) {
            q.add((Object)i);
            removeList.add(i);
        }
        Assert.assertTrue((boolean)q.removeAll(removeList));
        Assert.assertEquals((long)0L, (long)q.size());
    }

    @Test
    public void testRemoveList_whereNotFound() throws IOException {
        int maxItems = 131;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> removeList = new LinkedList<Integer>();
        for (int i = 0; i < 131; ++i) {
            q.add((Object)i);
        }
        removeList.add(132);
        removeList.add(133);
        Assert.assertFalse((boolean)q.removeAll(removeList));
        Assert.assertEquals((long)131L, (long)q.size());
    }

    @Test
    public void testRetainEmptyList() throws IOException {
        int maxItems = 131;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        for (int i = 0; i < 131; ++i) {
            q.add((Object)i);
        }
        List retain = Collections.emptyList();
        Assert.assertTrue((boolean)q.retainAll(retain));
        Assert.assertEquals((long)0L, (long)q.size());
    }

    @Test
    public void testRetainAllList() throws IOException {
        int maxItems = 181;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> retain = new LinkedList<Integer>();
        for (int i = 0; i < 181; ++i) {
            q.add((Object)i);
            retain.add(i);
        }
        Assert.assertFalse((boolean)q.retainAll(retain));
        Assert.assertEquals((long)181L, (long)q.size());
    }

    @Test
    public void testRetainAll_ListNotFound() throws IOException {
        int maxItems = 181;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> retain = new LinkedList<Integer>();
        for (int i = 0; i < 181; ++i) {
            q.add((Object)i);
        }
        retain.add(182);
        retain.add(183);
        Assert.assertTrue((boolean)q.retainAll(retain));
        Assert.assertEquals((long)0L, (long)q.size());
    }

    @Test
    public void testRetainAll_mixedList() throws IOException {
        int maxItems = 181;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        LinkedList<Integer> retain = new LinkedList<Integer>();
        for (int i = 0; i < 181; ++i) {
            q.add((Object)i);
        }
        retain.add(180);
        retain.add(182);
        Assert.assertTrue((boolean)q.retainAll(retain));
        Assert.assertEquals((long)1L, (long)q.size());
    }

    @Test
    public void testSize() {
        int maxItems = 143;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        for (int i = 0; i < 143; ++i) {
            q.add((Object)i);
        }
        Assert.assertEquals((long)143L, (long)q.size());
    }

    @Test
    public void testIsEmpty() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        Assert.assertTrue((boolean)q.isEmpty());
    }

    @Test
    public void testNotIsEmpty() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.offer((Object)1);
        Assert.assertFalse((boolean)q.isEmpty());
    }

    @Test
    public void testClear() {
        int maxItems = 123;
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        for (int i = 0; i < 123; ++i) {
            q.add((Object)i);
        }
        Assert.assertEquals((long)123L, (long)q.size());
        q.clear();
        Assert.assertEquals((long)0L, (long)q.size());
    }

    @Test
    public void testListener() throws Exception {
        int maxItems = 10;
        final CountDownLatch itemAddedLatch = new CountDownLatch(10);
        final CountDownLatch itemRemovedLatch = new CountDownLatch(10);
        final IQueue queue = this.client.getQueue(ClientQueueTest.randomString());
        String id = queue.addItemListener((ItemListener)new ItemListener<Integer>(){

            public void itemAdded(ItemEvent<Integer> itemEvent) {
                itemAddedLatch.countDown();
            }

            public void itemRemoved(ItemEvent<Integer> item) {
                itemRemovedLatch.countDown();
            }
        }, true);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    queue.offer((Object)i);
                    queue.remove((Object)i);
                }
            }
        }.start();
        Assert.assertTrue((boolean)itemAddedLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)itemRemovedLatch.await(5L, TimeUnit.SECONDS));
        queue.removeItemListener(id);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetLocalQueueStats() {
        IQueue q = this.client.getQueue(ClientQueueTest.randomString());
        q.getLocalQueueStats();
    }

    @Test
    public void testOffer_whenExceedingMaxCapacity() {
        IQueue q = this.client.getQueue(QUEUE_WITH_MAX_SIZE + ClientQueueTest.randomString());
        for (int i = 0; i < 8; ++i) {
            q.offer((Object)i);
        }
        Assert.assertFalse((boolean)q.offer((Object)8));
    }

    @Test
    public void testOfferPoll() throws IOException, InterruptedException {
        final IQueue q = this.client.getQueue(QUEUE_WITH_MAX_SIZE + ClientQueueTest.randomString());
        for (int i = 0; i < 10; ++i) {
            boolean result = q.offer((Object)"item");
            if (i < 8) {
                Assert.assertTrue((boolean)result);
                continue;
            }
            Assert.assertFalse((boolean)result);
        }
        Assert.assertEquals((long)8L, (long)q.size());
        ClientQueueTest.spawn((Runnable)new Runnable(){

            @Override
            public void run() {
                HazelcastTestSupport.sleepSeconds((int)1);
                q.poll();
            }
        });
        boolean result = q.offer((Object)"item", 15L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result);
        for (int i = 0; i < 10; ++i) {
            Object o = q.poll();
            if (i < 8) {
                Assert.assertNotNull((Object)o);
                continue;
            }
            Assert.assertNull((Object)o);
        }
        Assert.assertEquals((long)0L, (long)q.size());
        ClientQueueTest.spawn((Runnable)new Runnable(){

            @Override
            public void run() {
                HazelcastTestSupport.sleepSeconds((int)1);
                q.offer((Object)"item1");
            }
        });
        Object o = q.poll(15L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"item1", (Object)o);
    }
}

