/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum.executor;

import com.hazelcast.client.quorum.PartitionedClusterClients;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.quorum.executor.ExecutorQuorumWriteTest;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExecutorQuorumWriteTest
extends ExecutorQuorumWriteTest {
    private static PartitionedClusterClients clients;

    @BeforeClass
    public static void setUp() {
        TestHazelcastFactory factory = new TestHazelcastFactory();
        ClientExecutorQuorumWriteTest.initTestEnvironment((Config)new Config(), (TestHazelcastInstanceFactory)factory);
        clients = new PartitionedClusterClients(cluster, factory);
    }

    @AfterClass
    public static void tearDown() {
        if (clients != null) {
            clients.terminateAll();
        }
        ClientExecutorQuorumWriteTest.shutdownTestEnvironment();
    }

    protected IExecutorService exec(int index, QuorumType quorumType) {
        return this.exec(index, quorumType, "");
    }

    protected IExecutorService exec(int index, QuorumType quorumType, String postfix) {
        return clients.client(index).getExecutorService(EXEC_NAME + quorumType.name() + postfix);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void invokeAll_timeout_quorum_short_timeout() throws Exception {
        super.invokeAll_timeout_quorum_short_timeout();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void invokeAll_timeout_quorum_long_timeout() throws Exception {
        super.invokeAll_timeout_quorum_long_timeout();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void invokeAll_timeout_noQuorum() throws Exception {
        super.invokeAll_timeout_noQuorum();
    }
}

