/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.DataStructureAdapterMethod;
import com.hazelcast.internal.adapter.ReplicatedMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheBasicTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReplicatedMapNearCacheBasicTest
extends AbstractNearCacheBasicTest<Data, String> {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY}, {InMemoryFormat.OBJECT});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.inMemoryFormat, (boolean)true);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected void assumeThatMethodIsAvailable(DataStructureAdapterMethod method) {
        NearCacheTestUtils.assumeThatMethodIsAvailable(ReplicatedMapDataStructureAdapter.class, (DataStructureAdapterMethod)method);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(boolean loaderEnabled) {
        Config config = this.getConfig();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        ReplicatedMap memberMap = member.getReplicatedMap("defaultNearCache");
        ReplicatedMapDataStructureAdapter dataAdapter = new ReplicatedMapDataStructureAdapter(memberMap);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.build();
    }

    protected Config getConfig() {
        Config config = NearCacheTestUtils.getBaseConfig();
        config.getReplicatedMapConfig("defaultNearCache").setInMemoryFormat(this.nearCacheConfig.getInMemoryFormat());
        return config;
    }

    protected ClientConfig getClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.internal.nearcache.expiration.task.initial.delay.seconds", "0");
        clientConfig.setProperty("hazelcast.internal.nearcache.expiration.task.period.seconds", "1");
        return clientConfig.addNearCacheConfig(this.nearCacheConfig);
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder() {
        ClientConfig clientConfig = this.getClientConfig();
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        ReplicatedMap clientMap = client.getReplicatedMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ReplicatedMapDataStructureAdapter(clientMap)).setNearCache(nearCache).setNearCacheManager(nearCacheManager);
    }
}

