/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.DataStructureAdapterMethod;
import com.hazelcast.internal.adapter.ReplicatedMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheSerializationCountTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheSerializationCountConfigBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class ClientReplicatedMapNearCacheSerializationCountTest
extends AbstractNearCacheSerializationCountTest<Data, String> {
    @Parameterized.Parameter
    public DataStructureAdapter.DataStructureMethods method;
    @Parameterized.Parameter(value=1)
    public int[] keySerializationCounts;
    @Parameterized.Parameter(value=2)
    public int[] keyDeserializationCounts;
    @Parameterized.Parameter(value=3)
    public int[] valueSerializationCounts;
    @Parameterized.Parameter(value=4)
    public int[] valueDeserializationCounts;
    @Parameterized.Parameter(value=5)
    public InMemoryFormat replicatedMapInMemoryFormat;
    @Parameterized.Parameter(value=6)
    public InMemoryFormat nearCacheInMemoryFormat;
    @Parameterized.Parameter(value=7)
    public Boolean serializeKeys;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="method:{0} replicatedMapFormat:{5} nearCacheFormat:{6} serializeKeys:{7}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, null, null}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, true}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)1), InMemoryFormat.BINARY, InMemoryFormat.BINARY, false}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, true}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)0, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)0, (int)1, (int)0), InMemoryFormat.BINARY, InMemoryFormat.OBJECT, false}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, null, null}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)2, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, true}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)2, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)1), InMemoryFormat.OBJECT, InMemoryFormat.BINARY, false}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, true}, {DataStructureAdapter.DataStructureMethods.GET, ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), ClientReplicatedMapNearCacheSerializationCountTest.newInt((int)1, (int)1, (int)0), InMemoryFormat.OBJECT, InMemoryFormat.OBJECT, false});
    }

    @Before
    public void setUp() {
        this.testMethod = this.method;
        this.expectedKeySerializationCounts = this.keySerializationCounts;
        this.expectedKeyDeserializationCounts = this.keyDeserializationCounts;
        this.expectedValueSerializationCounts = this.valueSerializationCounts;
        this.expectedValueDeserializationCounts = this.valueDeserializationCounts;
        if (this.nearCacheInMemoryFormat != null) {
            this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.nearCacheInMemoryFormat, (boolean)this.serializeKeys).setInvalidateOnChange(false);
        }
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected void addConfiguration(NearCacheSerializationCountConfigBuilder configBuilder) {
        configBuilder.append(this.method);
        configBuilder.append((Object)this.replicatedMapInMemoryFormat);
        configBuilder.append((Object)this.nearCacheInMemoryFormat);
        configBuilder.append((Object)this.serializeKeys);
    }

    protected void assumeThatMethodIsAvailable(DataStructureAdapterMethod method) {
        NearCacheTestUtils.assumeThatMethodIsAvailable(ReplicatedMapDataStructureAdapter.class, (DataStructureAdapterMethod)method);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext() {
        Config config = this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "1").setProperty(GroupProperty.PARTITION_OPERATION_THREAD_COUNT.getName(), "1");
        config.getReplicatedMapConfig("defaultNearCache").setInMemoryFormat(this.replicatedMapInMemoryFormat);
        ClientReplicatedMapNearCacheSerializationCountTest.prepareSerializationConfig((SerializationConfig)config.getSerializationConfig());
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        ReplicatedMap memberMap = member.getReplicatedMap("defaultNearCache");
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)new ReplicatedMapDataStructureAdapter(memberMap)).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.build();
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder() {
        ClientConfig clientConfig = this.getClientConfig();
        if (this.nearCacheConfig != null) {
            clientConfig.addNearCacheConfig(this.nearCacheConfig);
        }
        ClientReplicatedMapNearCacheSerializationCountTest.prepareSerializationConfig((SerializationConfig)clientConfig.getSerializationConfig());
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        ReplicatedMap clientMap = client.getReplicatedMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ReplicatedMapDataStructureAdapter(clientMap)).setNearCache(nearCache).setNearCacheManager(nearCacheManager);
    }
}

