/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.semaphore;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientSemaphoreThreadedTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void concurrent_trySemaphoreTest() {
        this.concurrent_trySemaphoreTest(false);
    }

    @Test
    public void concurrent_trySemaphoreWithTimeOutTest() {
        this.concurrent_trySemaphoreTest(true);
    }

    public void concurrent_trySemaphoreTest(boolean tryWithTimeOut) {
        ISemaphore semaphore = this.client.getSemaphore(HazelcastTestSupport.randomString());
        semaphore.init(1);
        AtomicInteger upTotal = new AtomicInteger(0);
        AtomicInteger downTotal = new AtomicInteger(0);
        Thread[] threads = new SemaphoreTestThread[8];
        for (int i = 0; i < threads.length; ++i) {
            SemaphoreTestThread t = tryWithTimeOut ? new TrySemaphoreTimeOutThread(semaphore, upTotal, downTotal) : new TrySemaphoreThread(semaphore, upTotal, downTotal);
            t.start();
            threads[i] = t;
        }
        HazelcastTestSupport.assertJoinable((Thread[])threads);
        for (Thread t : threads) {
            Assert.assertNull((String)("thread " + t + " has error " + ((SemaphoreTestThread)t).error), (Object)((SemaphoreTestThread)t).error);
        }
        Assert.assertEquals((String)"concurrent access to locked code caused wrong total", (long)0L, (long)(upTotal.get() + downTotal.get()));
    }

    static abstract class SemaphoreTestThread
    extends Thread {
        private static final int MAX_ITTERATIONS = 10000;
        public volatile Throwable error;
        protected final ISemaphore semaphore;
        protected final AtomicInteger upTotal;
        protected final AtomicInteger downTotal;
        private final Random random = new Random();

        public SemaphoreTestThread(ISemaphore semaphore, AtomicInteger upTotal, AtomicInteger downTotal) {
            this.semaphore = semaphore;
            this.upTotal = upTotal;
            this.downTotal = downTotal;
        }

        @Override
        public final void run() {
            try {
                for (int i = 0; i < 10000; ++i) {
                    this.iterativelyRun();
                }
            }
            catch (Throwable e) {
                this.error = e;
            }
        }

        abstract void iterativelyRun() throws Exception;

        protected void work() {
            int delta = this.random.nextInt(1000);
            this.upTotal.addAndGet(delta);
            this.downTotal.addAndGet(-delta);
        }
    }

    static class TrySemaphoreTimeOutThread
    extends SemaphoreTestThread {
        public TrySemaphoreTimeOutThread(ISemaphore semaphore, AtomicInteger upTotal, AtomicInteger downTotal) {
            super(semaphore, upTotal, downTotal);
        }

        @Override
        public void iterativelyRun() throws Exception {
            if (this.semaphore.tryAcquire(1L, TimeUnit.MILLISECONDS)) {
                this.work();
                this.semaphore.release();
            }
        }
    }

    static class TrySemaphoreThread
    extends SemaphoreTestThread {
        public TrySemaphoreThread(ISemaphore semaphore, AtomicInteger upTotal, AtomicInteger downTotal) {
            super(semaphore, upTotal, downTotal);
        }

        @Override
        public void iterativelyRun() throws Exception {
            if (this.semaphore.tryAcquire()) {
                this.work();
                this.semaphore.release();
            }
        }
    }
}

