/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.serialization;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.Config;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import example.serialization.TestDeserialized;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientDeserializationProtectionTest
extends HazelcastTestSupport {
    protected static TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @AfterClass
    public static final void stopHazelcastInstances() {
        hazelcastFactory.terminateAll();
    }

    @Before
    public void killAllHazelcastInstances() throws IOException {
        hazelcastFactory.terminateAll();
        TestDeserialized.isDeserialized = false;
    }

    @Test
    public void testDefaultDeserializationFilter_readOnMember() {
        JavaSerializationFilterConfig filterConfig = new JavaSerializationFilterConfig();
        Config config = new Config();
        config.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance member = hazelcastFactory.newInstances(config, 1)[0];
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance client = hazelcastFactory.newHazelcastClient(clientConfig);
        client.getMap("test").put((Object)"key", (Object)new TestDeserialized());
        try {
            member.getMap("test").get((Object)"key");
            Assert.fail((String)"Deserialization should have failed");
        }
        catch (HazelcastSerializationException e) {
            Assert.assertFalse((boolean)TestDeserialized.isDeserialized);
        }
    }

    @Test
    public void testDefaultDeserializationFilter_readOnClient() {
        JavaSerializationFilterConfig filterConfig = new JavaSerializationFilterConfig();
        Config config = new Config();
        config.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance member = hazelcastFactory.newInstances(config, 1)[0];
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance client = hazelcastFactory.newHazelcastClient(clientConfig);
        member.getMap("test").put((Object)"key", (Object)new TestDeserialized());
        try {
            client.getMap("test").get((Object)"key");
            Assert.fail((String)"Deserialization should have failed");
        }
        catch (HazelcastSerializationException e) {
            Assert.assertFalse((boolean)TestDeserialized.isDeserialized);
        }
    }

    @Test
    public void testClassBlacklisted() {
        ClassFilter blacklist = new ClassFilter().addClasses(new String[]{TestDeserialized.class.getName()});
        JavaSerializationFilterConfig filterConfig = new JavaSerializationFilterConfig().setDefaultsDisabled(true).setBlacklist(blacklist);
        Config config = new Config();
        config.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance member = hazelcastFactory.newInstances(config, 1)[0];
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance client = hazelcastFactory.newHazelcastClient(clientConfig);
        member.getMap("test").put((Object)"key", (Object)new TestDeserialized());
        try {
            client.getMap("test").get((Object)"key");
            Assert.fail((String)"Deserialization should have failed");
        }
        catch (HazelcastSerializationException e) {
            Assert.assertFalse((boolean)TestDeserialized.isDeserialized);
        }
    }

    @Test
    public void testNoDeserializationFilter() {
        Config config = new Config();
        HazelcastInstance member = hazelcastFactory.newInstances(config, 1)[0];
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = hazelcastFactory.newHazelcastClient(clientConfig);
        member.getMap("test").put((Object)"key", (Object)new TestDeserialized());
        Assert.assertNotNull((Object)client.getMap("test").get((Object)"key"));
        Assert.assertTrue((boolean)TestDeserialized.isDeserialized);
    }

    @Test
    public void testClassWhitelisted() {
        JavaSerializationFilterConfig filterConfig = new JavaSerializationFilterConfig();
        filterConfig.getWhitelist().addClasses(new String[]{TestDeserialized.class.getName()});
        Config config = new Config();
        config.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance member = hazelcastFactory.newInstances(config, 1)[0];
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().setJavaSerializationFilterConfig(filterConfig);
        HazelcastInstance client = hazelcastFactory.newHazelcastClient(clientConfig);
        member.getMap("test").put((Object)"key", (Object)new TestDeserialized());
        Assert.assertNotNull((Object)client.getMap("test").get((Object)"key"));
        Assert.assertTrue((boolean)TestDeserialized.isDeserialized);
    }
}

