/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.google.common.collect.ImmutableList;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.connection.nio.DefaultCredentialsFactory;
import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelInitializerProvider;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.net.UnknownHostException;
import java.util.Collection;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientConnectionManagerTranslateTest
extends ClientTestSupport {
    private Address privateAddress;
    private Address publicAddress;
    private ClientConnectionManagerImpl clientConnectionManager;

    @Before
    public void setup() throws Exception {
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        TestAddressProvider provider = new TestAddressProvider();
        TestAddressTranslator translator = new TestAddressTranslator();
        final HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        this.clientConnectionManager = new ClientConnectionManagerImpl(clientInstanceImpl);
        DefaultCredentialsFactory factory = new DefaultCredentialsFactory(new ClientSecurityConfig(), new GroupConfig(), ClassLoader.getSystemClassLoader());
        this.clientConnectionManager.start();
        ChannelInitializerProvider channelInitializerProvider = new ChannelInitializerProvider(){

            public ChannelInitializer provide(EndpointQualifier qualifier) {
                return clientInstanceImpl.getClientExtension().createChannelInitializer();
            }
        };
        this.clientConnectionManager.beforeClusterSwitch(new CandidateClusterContext((AddressProvider)provider, (AddressTranslator)translator, null, (ICredentialsFactory)factory, null, channelInitializerProvider));
        this.clientConnectionManager.getOrConnect(new Address("127.0.0.1", 5701), true);
        translator.shouldTranslate = true;
        this.privateAddress = new Address("127.0.0.1", 5701);
        this.publicAddress = new Address("192.168.0.1", 5701);
    }

    @After
    public void teardown() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testTranslatorIsNotUsedGetActiveConnection() throws Exception {
        Connection connection = this.clientConnectionManager.getActiveConnection(this.privateAddress);
        TestCase.assertNotNull((Object)connection);
    }

    @Test
    public void testTranslatorIsNotUsedOnTriggerConnect() throws Exception {
        Connection connection = this.clientConnectionManager.getOrTriggerConnect(this.privateAddress, false);
        TestCase.assertNotNull((Object)connection);
    }

    @Test
    public void testTranslatorIsNotUsedOnGetConnection() throws Exception {
        Connection connection = this.clientConnectionManager.getOrConnect(this.privateAddress);
        TestCase.assertNotNull((Object)connection);
    }

    private class TestAddressProvider
    implements AddressProvider {
        private TestAddressProvider() {
        }

        public Addresses loadAddresses() {
            try {
                return new Addresses((Collection)ImmutableList.of((Object)new Address("127.0.0.1", 5701)));
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
    }

    private class TestAddressTranslator
    implements AddressTranslator {
        volatile boolean shouldTranslate = false;

        private TestAddressTranslator() {
        }

        public Address translate(Address address) {
            if (!this.shouldTranslate) {
                return address;
            }
            if (address.equals((Object)ClientConnectionManagerTranslateTest.this.privateAddress)) {
                return ClientConnectionManagerTranslateTest.this.publicAddress;
            }
            return null;
        }

        public void refresh() {
        }
    }
}

