/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.config.Config;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExecutionServiceImplTest {
    private static ClientExecutionServiceImpl executionService;

    @BeforeClass
    public static void setUp() {
        String name = "ClientExecutionServiceImplTest";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HazelcastProperties properties = new HazelcastProperties(new Config());
        ClientLoggingService loggingService = new ClientLoggingService(name, "jdk", BuildInfoProvider.getBuildInfo(), name);
        executionService = new ClientExecutionServiceImpl(name, classLoader, properties, 1, (LoggingService)loggingService);
    }

    @AfterClass
    public static void tearDown() {
        executionService.shutdown();
    }

    @Test
    public void testExecuteInternal() {
        TestRunnable runnable = new TestRunnable();
        executionService.execute((Runnable)runnable);
        runnable.await();
    }

    @Test
    public void testExecute() {
        TestRunnable runnable = new TestRunnable();
        executionService.execute((Runnable)runnable);
        runnable.await();
    }

    @Test
    public void testSchedule() throws Exception {
        TestRunnable runnable = new TestRunnable();
        ScheduledFuture future = executionService.schedule((Runnable)runnable, 0L, TimeUnit.SECONDS);
        Object result = future.get();
        Assert.assertTrue((boolean)runnable.isExecuted());
        Assert.assertNull(result);
    }

    @Test
    public void testScheduleWithRepetition() throws Exception {
        TestRunnable runnable = new TestRunnable(5);
        ScheduledFuture future = executionService.scheduleWithRepetition((Runnable)runnable, 0L, 100L, TimeUnit.MILLISECONDS);
        runnable.await();
        boolean result = future.cancel(true);
        Assert.assertTrue((boolean)result);
    }

    public void testGetAsyncExecutor() {
        Assert.assertNotNull((Object)executionService.getUserExecutor());
    }

    private static class TestRunnable
    implements Runnable {
        private final CountDownLatch isExecuted;

        TestRunnable() {
            this(1);
        }

        TestRunnable(int executions) {
            this.isExecuted = new CountDownLatch(executions);
        }

        @Override
        public void run() {
            this.isExecuted.countDown();
        }

        private boolean isExecuted() {
            return this.isExecuted.getCount() == 0L;
        }

        private void await() {
            try {
                this.isExecuted.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

