/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientResponseHandlerSupplier;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.function.Consumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientResponseHandlerSupplierTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void before() {
        this.hazelcastFactory.newHazelcastInstance();
    }

    @After
    public void after() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenNegativeResponseThreads() {
        this.getResponseHandler(-1, false);
    }

    @Test
    public void whenZeroResponseThreads() {
        Consumer<ClientMessage> handler = this.getResponseHandler(0, false);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.SyncResponseHandler.class, handler);
    }

    @Test
    public void whenOneResponseThreads_andStatic() {
        Consumer<ClientMessage> handler = this.getResponseHandler(1, false);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.AsyncResponseHandler.class, handler);
    }

    @Test
    public void whenMultipleResponseThreads_andStatic() {
        Consumer<ClientMessage> handler = this.getResponseHandler(2, false);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.AsyncResponseHandler.class, handler);
    }

    @Test
    public void whenOneResponseThreads_andDynamic() {
        Consumer<ClientMessage> handler = this.getResponseHandler(1, true);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.DynamicResponseHandler.class, handler);
    }

    @Test
    public void whenMultipleResponseThreads_andDynamic() {
        Consumer<ClientMessage> handler = this.getResponseHandler(2, true);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.DynamicResponseHandler.class, handler);
    }

    private Consumer<ClientMessage> getResponseHandler(int threadCount, boolean dynamic) {
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(new ClientConfig().setProperty(ClientProperty.RESPONSE_THREAD_COUNT.getName(), "" + threadCount).setProperty(ClientProperty.RESPONSE_THREAD_DYNAMIC.getName(), "" + dynamic));
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        AbstractClientInvocationService invocationService = (AbstractClientInvocationService)clientInstanceImpl.getInvocationService();
        ClientResponseHandlerSupplier responseHandlerSupplier = new ClientResponseHandlerSupplier(invocationService);
        return responseHandlerSupplier.get();
    }
}

