/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.client.spi.impl.DefaultAddressProvider;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class DefaultAddressProviderTest {
    @Test
    public void whenNoAddresses() throws UnknownHostException {
        ClientNetworkConfig config = new ClientNetworkConfig();
        DefaultAddressProvider provider = new DefaultAddressProvider(config);
        Addresses addresses = provider.loadAddresses();
        this.assertPrimary(addresses, new Address("127.0.0.1", 5701));
        this.assertSecondary(addresses, new Address("127.0.0.1", 5702), new Address("127.0.0.1", 5703));
    }

    @Test
    public void whenExplicitNoPortAddress() throws UnknownHostException {
        ClientNetworkConfig config = new ClientNetworkConfig();
        config.addAddress(new String[]{"10.0.0.1"});
        DefaultAddressProvider provider = new DefaultAddressProvider(config);
        Addresses addresses = provider.loadAddresses();
        this.assertPrimary(addresses, new Address("10.0.0.1", 5701));
        this.assertSecondary(addresses, new Address("10.0.0.1", 5702), new Address("10.0.0.1", 5703));
    }

    @Test
    public void whenExplicitPorts() throws UnknownHostException {
        ClientNetworkConfig config = new ClientNetworkConfig();
        config.addAddress(new String[]{"10.0.0.1:5703"});
        config.addAddress(new String[]{"10.0.0.1:5702"});
        DefaultAddressProvider provider = new DefaultAddressProvider(config);
        Addresses addresses = provider.loadAddresses();
        this.assertPrimary(addresses, new Address("10.0.0.1", 5703), new Address("10.0.0.1", 5702));
        this.assertSecondaryEmpty(addresses);
    }

    @Test
    public void whenMix() throws UnknownHostException {
        ClientNetworkConfig config = new ClientNetworkConfig();
        config.addAddress(new String[]{"10.0.0.1:5701"});
        config.addAddress(new String[]{"10.0.0.1:5702"});
        config.addAddress(new String[]{"10.0.0.2"});
        DefaultAddressProvider provider = new DefaultAddressProvider(config);
        Addresses addresses = provider.loadAddresses();
        this.assertPrimary(addresses, new Address("10.0.0.1", 5701), new Address("10.0.0.1", 5702), new Address("10.0.0.2", 5701));
        this.assertSecondary(addresses, new Address("10.0.0.2", 5702), new Address("10.0.0.2", 5703));
    }

    @Test
    public void whenBogusAddress() {
        ClientNetworkConfig config = new ClientNetworkConfig();
        config.addAddress(new String[]{UUID.randomUUID().toString()});
        DefaultAddressProvider provider = new DefaultAddressProvider(config);
        Addresses addresses = provider.loadAddresses();
        this.assertPrimaryEmpty(addresses);
        this.assertSecondaryEmpty(addresses);
    }

    public void assertPrimary(Addresses addresses, Address ... expected) {
        Assert.assertEquals(Arrays.asList(expected), (Object)addresses.primary());
    }

    public void assertSecondaryEmpty(Addresses addresses) {
        Assert.assertTrue((boolean)addresses.secondary().isEmpty());
    }

    public void assertPrimaryEmpty(Addresses addresses) {
        Assert.assertTrue((boolean)addresses.primary().isEmpty());
    }

    public void assertSecondary(Addresses addresses, Address ... expected) {
        Assert.assertEquals(Arrays.asList(expected), (Object)addresses.secondary());
    }
}

