/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class HazelcastCloudConfigTest
extends ClientTestSupport {
    @Test
    public void testCustomCloudUrlEndpoint() {
        ClientConfig config = new ClientConfig();
        String token = "TOKEN";
        config.setProperty(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN.getName(), token);
        config.setProperty(HazelcastCloudDiscovery.CLOUD_URL_BASE_PROPERTY.getName(), "https://dev.hazelcast.cloud");
        HazelcastProperties hazelcastProperties = new HazelcastProperties(config.getProperties());
        String cloudUrlBase = hazelcastProperties.getString(HazelcastCloudDiscovery.CLOUD_URL_BASE_PROPERTY);
        String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint((String)cloudUrlBase, (String)token);
        Assert.assertEquals((Object)"https://dev.hazelcast.cloud/cluster/discovery?token=TOKEN", (Object)urlEndpoint);
    }

    @Test
    public void testDefaultCloudUrlEndpoint() {
        ClientConfig config = new ClientConfig();
        String token = "TOKEN";
        config.setProperty(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN.getName(), token);
        HazelcastProperties hazelcastProperties = new HazelcastProperties(config.getProperties());
        String cloudUrlBase = hazelcastProperties.getString(HazelcastCloudDiscovery.CLOUD_URL_BASE_PROPERTY);
        String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint((String)cloudUrlBase, (String)token);
        Assert.assertEquals((Object)"https://coordinator.hazelcast.cloud/cluster/discovery?token=TOKEN", (Object)urlEndpoint);
    }
}

