/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class HazelcastCloudDiscoveryTest
extends ClientTestSupport {
    private static final String response = "[ {\"private-address\":\"10.47.0.8\",\"public-address\":\"54.213.63.142:32298\"},\n {\"private-address\":\"10.47.0.9\",\"public-address\":\"54.245.77.185:32298\"},\n {\"private-address\":\"10.47.0.10\",\"public-address\":\"54.186.232.37:32298\"}\n]";
    private static final String notFoundResponse = "HTTP/1.1 404 Not Found\nContent-Length: 0\n\n";
    private Map<Address, Address> addresses = new HashMap<Address, Address>();
    private HttpServer httpsServer;
    private static String validToken = "validToken";

    @Before
    public void setUp() throws IOException {
        this.addresses.put(new Address("10.47.0.8", 32298), new Address("54.213.63.142", 32298));
        this.addresses.put(new Address("10.47.0.9", 32298), new Address("54.245.77.185", 32298));
        this.addresses.put(new Address("10.47.0.10", 32298), new Address("54.186.232.37", 32298));
        this.httpsServer = HttpServer.create(new InetSocketAddress(0), 0);
        this.httpsServer.createContext("/", new MyHandler());
        this.httpsServer.setExecutor(null);
        this.httpsServer.start();
    }

    @After
    public void tearDown() {
        this.httpsServer.stop(0);
    }

    @Test
    public void testWithValidToken() {
        String cloudBaseUrl = "http://127.0.0.1:" + this.httpsServer.getAddress().getPort();
        String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint((String)cloudBaseUrl, (String)validToken);
        HazelcastCloudDiscovery cloudDiscovery = new HazelcastCloudDiscovery(urlEndpoint, Integer.MAX_VALUE);
        Map addressMap = cloudDiscovery.discoverNodes();
        Assert.assertEquals((long)addressMap.size(), (long)this.addresses.size());
        for (Map.Entry entry : addressMap.entrySet()) {
            Assert.assertEquals((Object)this.addresses.get(entry.getKey()), entry.getValue());
        }
    }

    @Test(expected=HazelcastException.class)
    public void testWithInvalidToken() {
        String cloudBaseUrl = "http://127.0.0.1:" + this.httpsServer.getAddress().getPort();
        String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint((String)cloudBaseUrl, (String)"invalid");
        HazelcastCloudDiscovery cloudDiscovery = new HazelcastCloudDiscovery(urlEndpoint, Integer.MAX_VALUE);
        cloudDiscovery.discoverNodes();
    }

    static class MyHandler
    implements HttpHandler {
        MyHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String[] split;
            URI requestURI = t.getRequestURI();
            if (requestURI.getPath().equals("/cluster/discovery") && "token".equals((split = requestURI.getQuery().split("="))[0]) && validToken.equals(split[1])) {
                t.sendResponseHeaders(200, HazelcastCloudDiscoveryTest.response.getBytes().length);
                OutputStream os = t.getResponseBody();
                os.write(HazelcastCloudDiscoveryTest.response.getBytes());
                os.close();
                return;
            }
            t.sendResponseHeaders(404, HazelcastCloudDiscoveryTest.notFoundResponse.getBytes().length);
            OutputStream os = t.getResponseBody();
            os.write(HazelcastCloudDiscoveryTest.notFoundResponse.getBytes());
            os.close();
        }
    }
}

