/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.spi.impl.discovery.HazelcastCloudAddressProvider;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class HazelcastCloudProviderTest {
    private Map<Address, Address> expectedAddresses = new ConcurrentHashMap<Address, Address>();
    private HazelcastCloudDiscovery hazelcastCloudDiscovery;
    private HazelcastCloudAddressProvider provider;

    @Before
    public void setUp() throws UnknownHostException {
        this.expectedAddresses.put(new Address("10.0.0.1", 5701), new Address("198.51.100.1", 5701));
        this.expectedAddresses.put(new Address("10.0.0.1", 5702), new Address("198.51.100.1", 5702));
        this.expectedAddresses.put(new Address("10.0.0.2", 5701), new Address("198.51.100.2", 5701));
        this.hazelcastCloudDiscovery = (HazelcastCloudDiscovery)Mockito.mock(HazelcastCloudDiscovery.class);
        Mockito.when((Object)this.hazelcastCloudDiscovery.discoverNodes()).thenReturn(this.expectedAddresses);
        LoggingService loggingService = (LoggingService)Mockito.mock(LoggingService.class);
        Mockito.when((Object)loggingService.getLogger((Class)Matchers.eq(HazelcastCloudAddressProvider.class))).thenReturn((Object)Logger.getLogger(HazelcastCloudProviderTest.class));
        this.provider = new HazelcastCloudAddressProvider(this.hazelcastCloudDiscovery, loggingService);
    }

    @Test
    public void testLoadAddresses() {
        List addresses = this.provider.loadAddresses().primary();
        Assert.assertEquals((long)3L, (long)addresses.size());
        for (Address address : this.expectedAddresses.keySet()) {
            addresses.remove(address);
        }
        Assert.assertTrue((boolean)addresses.isEmpty());
    }

    @Test
    public void testLoadAddresses_whenExceptionIsThrown() {
        Mockito.when((Object)this.hazelcastCloudDiscovery.discoverNodes()).thenThrow(new Throwable[]{new IllegalStateException("Expected exception")});
        List addresses = this.provider.loadAddresses().primary();
        Assert.assertEquals((String)"Expected that no addresses are loaded", (long)0L, (long)addresses.size());
    }
}

