/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.spi.impl.discovery.HazelcastCloudAddressTranslator;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class HazelcastCloudTranslatorTest {
    private final Map<Address, Address> lookup = new HashMap<Address, Address>();
    private Address privateAddress;
    private Address publicAddress;
    private LoggingService loggingService;
    private HazelcastCloudAddressTranslator translator;

    @Before
    public void setUp() throws Exception {
        this.privateAddress = new Address("127.0.0.1", 5701);
        this.publicAddress = new Address("192.168.0.1", 5701);
        this.lookup.put(this.privateAddress, this.publicAddress);
        this.lookup.put(new Address("127.0.0.2", 5701), new Address("192.168.0.2", 5701));
        HazelcastCloudDiscovery cloudDiscovery = (HazelcastCloudDiscovery)Mockito.mock(HazelcastCloudDiscovery.class);
        Mockito.when((Object)cloudDiscovery.discoverNodes()).thenReturn(this.lookup);
        ILogger logger = Logger.getLogger(HazelcastCloudTranslatorTest.class);
        this.loggingService = (LoggingService)Mockito.mock(LoggingService.class);
        Mockito.when((Object)this.loggingService.getLogger((Class)Matchers.eq(HazelcastCloudAddressTranslator.class))).thenReturn((Object)logger);
        this.translator = new HazelcastCloudAddressTranslator(cloudDiscovery, this.loggingService);
    }

    @Test
    public void testTranslate_whenAddressIsNull_thenReturnNull() {
        Address actual = this.translator.translate(null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testTranslate() {
        Address actual = this.translator.translate(this.privateAddress);
        Assert.assertEquals((Object)this.publicAddress.getHost(), (Object)actual.getHost());
        Assert.assertEquals((long)this.privateAddress.getPort(), (long)actual.getPort());
    }

    @Test
    public void testRefreshAndTranslate() {
        this.translator.refresh();
        Address actual = this.translator.translate(this.privateAddress);
        Assert.assertEquals((Object)this.publicAddress.getHost(), (Object)actual.getHost());
        Assert.assertEquals((long)this.privateAddress.getPort(), (long)actual.getPort());
    }

    @Test
    public void testTranslate_whenNotFound_thenReturnNull() throws UnknownHostException {
        Address notAvailableAddress = new Address("127.0.0.3", 5701);
        Address actual = this.translator.translate(notAvailableAddress);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testRefresh_whenException_thenLogWarning() {
        HazelcastCloudDiscovery cloudDiscovery = (HazelcastCloudDiscovery)Mockito.mock(HazelcastCloudDiscovery.class);
        Mockito.when((Object)cloudDiscovery.discoverNodes()).thenReturn(this.lookup);
        this.translator = new HazelcastCloudAddressTranslator(cloudDiscovery, this.loggingService);
        this.translator.refresh();
    }
}

