/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.clientside.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientProtocolBuffer;
import com.hazelcast.client.test.TwoWayBlockableExecutor;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.nio.NioNetworking;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.mocknetwork.MockConnection;
import com.hazelcast.test.mocknetwork.TestNodeRegistry;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class TestClientRegistry {
    private static final AtomicInteger CLIENT_PORTS = new AtomicInteger(40000);
    private static final ILogger LOGGER = Logger.getLogger(HazelcastClient.class);
    private final TestNodeRegistry nodeRegistry;

    TestClientRegistry(TestNodeRegistry nodeRegistry) {
        this.nodeRegistry = nodeRegistry;
    }

    ClientConnectionManagerFactory createClientServiceFactory() {
        return new MockClientConnectionManagerFactory("127.0.0.1", CLIENT_PORTS);
    }

    private class MockedNodeConnection
    extends MockConnection {
        private final AtomicBoolean alive;
        private final MockedClientConnection responseConnection;
        private final int connectionId;
        private volatile long lastReadTimeMillis;
        private volatile long lastWriteTimeMillis;

        MockedNodeConnection(int connectionId, Address localEndpoint, Address remoteEndpoint, NodeEngineImpl nodeEngine, MockedClientConnection responseConnection) {
            super(localEndpoint, remoteEndpoint, nodeEngine);
            this.alive = new AtomicBoolean(true);
            this.responseConnection = responseConnection;
            this.connectionId = connectionId;
            this.register();
            this.lastReadTimeMillis = System.currentTimeMillis();
            this.lastWriteTimeMillis = System.currentTimeMillis();
        }

        private void register() {
            Node node = this.remoteNodeEngine.getNode();
            node.getEndpointManager(EndpointQualifier.CLIENT).registerConnection(this.getEndPoint(), (Connection)this);
        }

        public boolean write(OutboundFrame frame) {
            ClientMessage packet = (ClientMessage)frame;
            if (this.isAlive()) {
                this.lastWriteTimeMillis = System.currentTimeMillis();
                ClientMessage newPacket = this.readFromPacket(packet);
                newPacket.setConnection((Connection)this.responseConnection);
                this.responseConnection.handleClientMessage(newPacket);
                return true;
            }
            return false;
        }

        void handleClientMessage(ClientMessage newPacket) {
            this.lastReadTimeMillis = System.currentTimeMillis();
            this.remoteNodeEngine.getNode().clientEngine.accept((Object)newPacket);
        }

        public boolean isClient() {
            return true;
        }

        private ClientMessage readFromPacket(ClientMessage packet) {
            return ClientMessage.createForDecode((ClientProtocolBuffer)packet.buffer(), (int)0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MockedNodeConnection that = (MockedNodeConnection)((Object)o);
            if (this.connectionId != that.connectionId) {
                return false;
            }
            Address remoteEndpoint = this.getEndPoint();
            return !(remoteEndpoint == null ? that.getEndPoint() != null : !remoteEndpoint.equals((Object)that.getEndPoint()));
        }

        public void close(String reason, Throwable cause) {
            if (!this.alive.compareAndSet(true, false)) {
                return;
            }
            Logger.getLogger(MockedNodeConnection.class).warning("Server connection closed: " + reason, cause);
            super.close(reason, cause);
            this.responseConnection.onServerClose(reason);
        }

        public int hashCode() {
            int result = this.connectionId;
            Address remoteEndpoint = this.getEndPoint();
            result = 31 * result + (remoteEndpoint != null ? remoteEndpoint.hashCode() : 0);
            return result;
        }

        public long lastReadTimeMillis() {
            return this.lastReadTimeMillis;
        }

        public long lastWriteTimeMillis() {
            return this.lastWriteTimeMillis;
        }

        public ConnectionType getType() {
            return ConnectionType.JAVA_CLIENT;
        }

        public String toString() {
            return "MockedNodeConnection{ remoteEndpoint = " + this.getEndPoint() + ", localEndpoint = " + this.localEndpoint + ", connectionId = " + this.connectionId + '}';
        }
    }

    private class MockedClientConnection
    extends ClientConnection {
        private final NodeEngineImpl serverNodeEngine;
        private final Address remoteAddress;
        private final Address localAddress;
        private final TwoWayBlockableExecutor executor;
        private final MockedNodeConnection serverSideConnection;
        private volatile long lastReadTime;
        private volatile long lastWriteTime;

        MockedClientConnection(HazelcastClientInstanceImpl client, int connectionId, NodeEngineImpl serverNodeEngine, Address address, Address localAddress, TwoWayBlockableExecutor.LockPair lockPair) {
            super(client, connectionId);
            this.serverNodeEngine = serverNodeEngine;
            this.remoteAddress = address;
            this.localAddress = localAddress;
            this.executor = new TwoWayBlockableExecutor(lockPair);
            this.serverSideConnection = new MockedNodeConnection(connectionId, this.remoteAddress, localAddress, serverNodeEngine, this);
        }

        public void handleClientMessage(final ClientMessage clientMessage) {
            this.executor.executeIncoming(new Runnable(){

                @Override
                public void run() {
                    MockedClientConnection.this.lastReadTime = System.currentTimeMillis();
                    MockedClientConnection.super.handleClientMessage(clientMessage);
                }

                public String toString() {
                    return "Runnable message " + clientMessage + ", " + (Object)((Object)MockedClientConnection.this);
                }
            });
        }

        public boolean write(final OutboundFrame frame) {
            if (!this.isAlive()) {
                return false;
            }
            Node node = this.serverNodeEngine.getNode();
            if (node.getState() == NodeState.SHUT_DOWN) {
                return false;
            }
            this.executor.executeOutgoing(new Runnable(){

                public String toString() {
                    return "Runnable message " + frame + ", " + (Object)((Object)MockedClientConnection.this);
                }

                @Override
                public void run() {
                    ClientMessage clientMessage = MockedClientConnection.this.readFromPacket((ClientMessage)frame);
                    MockedClientConnection.this.lastWriteTime = System.currentTimeMillis();
                    clientMessage.setConnection((Connection)MockedClientConnection.this.serverSideConnection);
                    MockedClientConnection.this.serverSideConnection.handleClientMessage(clientMessage);
                }
            });
            return true;
        }

        private ClientMessage readFromPacket(ClientMessage packet) {
            return ClientMessage.createForDecode((ClientProtocolBuffer)packet.buffer(), (int)0);
        }

        public long lastReadTimeMillis() {
            return this.lastReadTime;
        }

        public long lastWriteTimeMillis() {
            return this.lastWriteTime;
        }

        public InetAddress getInetAddress() {
            try {
                return this.remoteAddress.getInetAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        public InetSocketAddress getRemoteSocketAddress() {
            try {
                return this.remoteAddress.getInetSocketAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getPort() {
            return this.remoteAddress.getPort();
        }

        public InetSocketAddress getLocalSocketAddress() {
            try {
                return this.localAddress.getInetSocketAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void innerClose() {
            this.executor.executeOutgoing(new Runnable(){

                @Override
                public void run() {
                    MockedClientConnection.this.serverSideConnection.close(null, null);
                }

                public String toString() {
                    return "Client Closed EOF. " + (Object)((Object)MockedClientConnection.this);
                }
            });
            this.executor.shutdownIncoming();
        }

        void onServerClose(final String reason) {
            this.executor.executeIncoming(new Runnable(){

                public String toString() {
                    return "Server Closed EOF. " + (Object)((Object)MockedClientConnection.this);
                }

                @Override
                public void run() {
                    MockedClientConnection.this.close(reason, new TargetDisconnectedException("Mocked Remote socket closed"));
                }
            });
            this.executor.shutdownOutgoing();
        }

        public String toString() {
            return "MockedClientConnection{localAddress=" + this.localAddress + ", super=" + super.toString() + '}';
        }
    }

    class MockClientConnectionManager
    extends ClientConnectionManagerImpl {
        private final ConcurrentHashMap<Address, TwoWayBlockableExecutor.LockPair> addressBlockMap;
        private final HazelcastClientInstanceImpl client;
        private final String host;
        private final AtomicInteger ports;

        MockClientConnectionManager(HazelcastClientInstanceImpl client, String host, AtomicInteger ports) {
            super(client);
            this.addressBlockMap = new ConcurrentHashMap();
            this.client = client;
            this.host = host;
            this.ports = ports;
        }

        protected NioNetworking initNetworking(HazelcastClientInstanceImpl client) {
            return null;
        }

        protected void startNetworking() {
        }

        protected void stopNetworking() {
        }

        protected ClientConnection createSocketConnection(Address address) throws IOException {
            if (!this.alive) {
                throw new HazelcastException("ConnectionManager is not active!!!");
            }
            try {
                HazelcastInstance instance = TestClientRegistry.this.nodeRegistry.getInstance(address);
                if (instance == null) {
                    throw new IOException("Can not connected to " + address + ": instance does not exist");
                }
                Address localAddress = new Address(this.host, this.ports.incrementAndGet());
                TwoWayBlockableExecutor.LockPair lockPair = this.getLockPair(address);
                MockedClientConnection connection = new MockedClientConnection(this.client, this.connectionIdGen.incrementAndGet(), HazelcastTestSupport.getNodeEngineImpl((HazelcastInstance)instance), address, localAddress, lockPair);
                LOGGER.info("Created connection to endpoint: " + address + ", connection: " + (Object)((Object)connection));
                return connection;
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
            }
        }

        private TwoWayBlockableExecutor.LockPair getLockPair(Address address) {
            return (TwoWayBlockableExecutor.LockPair)ConcurrencyUtil.getOrPutIfAbsent(this.addressBlockMap, (Object)address, (ConstructorFunction)new ConstructorFunction<Address, TwoWayBlockableExecutor.LockPair>(){

                public TwoWayBlockableExecutor.LockPair createNew(Address arg) {
                    return new TwoWayBlockableExecutor.LockPair(new ReentrantReadWriteLock(), new ReentrantReadWriteLock());
                }
            });
        }

        void blockFrom(Address address) {
            LOGGER.info("Blocked messages from " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.getLockPair(address);
            lockPair.blockIncoming();
        }

        void unblockFrom(Address address) {
            LOGGER.info("Unblocked messages from " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.getLockPair(address);
            lockPair.unblockIncoming();
        }

        void blockTo(Address address) {
            LOGGER.info("Blocked messages to " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.getLockPair(address);
            lockPair.blockOutgoing();
        }

        void unblockTo(Address address) {
            LOGGER.info("Unblocked messages to " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.getLockPair(address);
            lockPair.unblockOutgoing();
        }
    }

    private class MockClientConnectionManagerFactory
    implements ClientConnectionManagerFactory {
        private final String host;
        private final AtomicInteger ports;

        MockClientConnectionManagerFactory(String host, AtomicInteger ports) {
            this.host = host;
            this.ports = ports;
        }

        public ClientConnectionManager createConnectionManager(HazelcastClientInstanceImpl client) {
            return new MockClientConnectionManager(client, this.host, this.ports);
        }
    }
}

