/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.logging.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

class TwoWayBlockableExecutor {
    private final ExecutorService incomingMessages = Executors.newSingleThreadExecutor();
    private final ExecutorService outgoingMessages = Executors.newSingleThreadExecutor();
    private final LockPair lockPair;

    TwoWayBlockableExecutor(LockPair lockPair) {
        this.lockPair = lockPair;
    }

    void shutdownIncoming() {
        this.incomingMessages.shutdown();
    }

    void shutdownOutgoing() {
        this.outgoingMessages.shutdown();
    }

    void executeIncoming(Runnable runnable) {
        try {
            this.incomingMessages.execute(new BlockableRunnable(runnable, this.lockPair.incomingLock.readLock()));
        }
        catch (RejectedExecutionException rejected) {
            Logger.getLogger(this.getClass()).warning("Dropping incoming runnable since other end closed. " + runnable);
        }
    }

    void executeOutgoing(Runnable runnable) {
        try {
            this.outgoingMessages.execute(new BlockableRunnable(runnable, this.lockPair.outgoingLock.readLock()));
        }
        catch (RejectedExecutionException rejected) {
            Logger.getLogger(this.getClass()).warning("Dropping outgoing runnable since other end closed. " + runnable);
        }
    }

    class BlockableRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Lock lock;

        BlockableRunnable(Runnable runnable, Lock lock) {
            this.runnable = runnable;
            this.lock = lock;
        }

        @Override
        public void run() {
            this.lock.lock();
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    static class LockPair {
        ReadWriteLock incomingLock;
        ReadWriteLock outgoingLock;

        LockPair(ReadWriteLock incomingLock, ReadWriteLock outgoingLock) {
            this.incomingLock = incomingLock;
            this.outgoingLock = outgoingLock;
        }

        void blockIncoming() {
            this.incomingLock.writeLock().lock();
        }

        void unblockIncoming() {
            this.incomingLock.writeLock().unlock();
        }

        void blockOutgoing() {
            this.outgoingLock.writeLock().lock();
        }

        void unblockOutgoing() {
            this.outgoingLock.writeLock().unlock();
        }
    }
}

