/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientUtil;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientTxnOwnerDisconnectedTest
extends ClientTestSupport {
    @After
    public void after() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Before
    public void before() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TransactionException.class)
    public void testTransactionBeginShouldFail_onDisconnectedState() {
        HazelcastInstance instance = Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        final AtomicBoolean waitFlag = new AtomicBoolean();
        final CountDownLatch testFinished = new CountDownLatch(1);
        AddressProvider addressProvider = new AddressProvider(){

            public Addresses loadAddresses() {
                if (waitFlag.get()) {
                    try {
                        testFinished.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return AddressHelper.getSocketAddresses((String)"127.0.0.1");
            }
        };
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
        HazelcastInstance client = HazelcastClientUtil.newHazelcastClient(addressProvider, clientConfig);
        Hazelcast.newHazelcastInstance();
        TransactionContext context = client.newTransactionContext();
        final CountDownLatch clientDisconnected = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                clientDisconnected.countDown();
            }
        });
        waitFlag.set(true);
        instance.shutdown();
        ClientTxnOwnerDisconnectedTest.assertOpenEventually((CountDownLatch)clientDisconnected);
        try {
            context.beginTransaction();
        }
        finally {
            testFinished.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TransactionException.class)
    public void testNewTransactionContextShouldFail_onDisconnectedState() {
        HazelcastInstance instance = Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        final AtomicBoolean waitFlag = new AtomicBoolean();
        final CountDownLatch testFinished = new CountDownLatch(1);
        AddressProvider addressProvider = new AddressProvider(){

            public Addresses loadAddresses() {
                if (waitFlag.get()) {
                    try {
                        testFinished.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return AddressHelper.getSocketAddresses((String)"127.0.0.1");
            }
        };
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
        HazelcastInstance client = HazelcastClientUtil.newHazelcastClient(addressProvider, clientConfig);
        Hazelcast.newHazelcastInstance();
        final CountDownLatch clientDisconnected = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                clientDisconnected.countDown();
            }
        });
        waitFlag.set(true);
        instance.shutdown();
        ClientTxnOwnerDisconnectedTest.assertOpenEventually((CountDownLatch)clientDisconnected);
        try {
            client.newTransactionContext();
        }
        finally {
            testFinished.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TransactionException.class)
    public void testXAShouldFail_onDisconnectedState() throws Throwable {
        HazelcastInstance instance = Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        final AtomicBoolean waitFlag = new AtomicBoolean();
        final CountDownLatch testFinished = new CountDownLatch(1);
        AddressProvider addressProvider = new AddressProvider(){

            public Addresses loadAddresses() {
                if (waitFlag.get()) {
                    try {
                        testFinished.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return AddressHelper.getSocketAddresses((String)"127.0.0.1");
            }
        };
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
        clientConfig.setProperty(ClientProperty.ALLOW_INVOCATIONS_WHEN_DISCONNECTED.getName(), "true");
        HazelcastInstance client = HazelcastClientUtil.newHazelcastClient(addressProvider, clientConfig);
        Hazelcast.newHazelcastInstance();
        HazelcastXAResource xaResource = client.getXAResource();
        UserTransactionManager tm = new UserTransactionManager();
        this.cleanAtomikosLogs();
        tm.setTransactionTimeout(3);
        tm.begin();
        Transaction transaction = tm.getTransaction();
        final CountDownLatch clientDisconnected = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                clientDisconnected.countDown();
            }
        });
        waitFlag.set(true);
        instance.shutdown();
        ClientTxnOwnerDisconnectedTest.assertOpenEventually((CountDownLatch)clientDisconnected);
        try {
            transaction.enlistResource((XAResource)xaResource);
        }
        finally {
            transaction.rollback();
            tm.close();
            this.cleanAtomikosLogs();
            testFinished.countDown();
        }
    }

    public void cleanAtomikosLogs() {
        try {
            File[] tmLogs;
            File currentDir = new File(".");
            for (File tmLog : tmLogs = currentDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".epoch") || name.startsWith("tmlog");
                }
            })) {
                tmLog.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

