/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.atomikos.datasource.xa.XID;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import java.util.concurrent.CountDownLatch;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientXACompatibilityTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance instance;
    private HazelcastInstance secondInstance;
    private HazelcastInstance client;
    private HazelcastInstance secondClient;
    private HazelcastXAResource xaResource;
    private HazelcastXAResource secondXaResource;
    private HazelcastXAResource instanceXaResource;
    private Xid xid;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    private static Xid createXid() {
        return new XID(ClientXACompatibilityTest.randomString(), "test");
    }

    @Before
    public void setUp() throws Exception {
        this.instance = this.hazelcastFactory.newHazelcastInstance();
        this.instanceXaResource = this.instance.getXAResource();
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.secondClient = this.hazelcastFactory.newHazelcastClient();
        this.xaResource = this.client.getXAResource();
        this.secondXaResource = this.secondClient.getXAResource();
        this.xid = ClientXACompatibilityTest.createXid();
    }

    @Test
    public void testRecoveryRequiresRollbackOfPreparedXidOnSecondXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.performRollbackWithXa((XAResource)this.secondXaResource);
    }

    @Test
    public void testRecoveryRequiresRollbackOfPreparedXidOnInstanceXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.performRollbackWithXa((XAResource)this.instanceXaResource);
    }

    @Test
    public void testRecoveryRequiresCommitOfPreparedXidOnSecondXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.performCommitWithXa((XAResource)this.secondXaResource);
    }

    @Test
    public void testRecoveryRequiresCommitOfPreparedXidOnInstanceXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.performCommitWithXa((XAResource)this.instanceXaResource);
    }

    @Test
    public void testRecoveryReturnsPreparedXidOnXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.assertRecoversXid((XAResource)this.xaResource);
    }

    @Test
    public void testRecoveryReturnsPreparedXidOnSecondXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.assertRecoversXid((XAResource)this.secondXaResource);
    }

    @Test
    public void testRecoveryReturnsPreparedXidOnInstanceXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.assertRecoversXid((XAResource)this.instanceXaResource);
    }

    @Test
    public void testRecoveryRequiresRollbackOfUnknownXid() throws Exception {
        this.performRollbackWithXa((XAResource)this.xaResource);
    }

    @Test
    public void testIsSameRm() throws Exception {
        Assert.assertTrue((boolean)this.xaResource.isSameRM((XAResource)this.secondXaResource));
    }

    @Test
    public void testIsSameRmWithInstanceXaResource() throws Exception {
        Assert.assertTrue((boolean)this.xaResource.isSameRM((XAResource)this.instanceXaResource));
    }

    @Test
    public void testRecoveryAllowedAtAnyTime() throws Exception {
        this.recover((XAResource)this.xaResource);
        this.doSomeWorkWithXa(this.xaResource);
        this.recover((XAResource)this.xaResource);
        this.performPrepareWithXa((XAResource)this.xaResource);
        this.recover((XAResource)this.xaResource);
        this.performCommitWithXa((XAResource)this.xaResource);
        this.recover((XAResource)this.xaResource);
    }

    private void assertRecoversXid(XAResource xaResource) throws XAException {
        Xid[] xids = xaResource.recover(0x1800000);
        Assert.assertTrue((String)("" + xids.length), (xids.length == 1 ? 1 : 0) != 0);
    }

    private void performCommitWithXa(XAResource xaResource) throws XAException {
        xaResource.commit(this.xid, false);
    }

    private void performRollbackWithXa(XAResource secondXaResource) throws XAException {
        try {
            secondXaResource.rollback(this.xid);
        }
        catch (XAException xaerr) {
            Assert.assertTrue((String)("rollback of unknown xid gives unexpected errorCode: " + xaerr.errorCode), (100 <= xaerr.errorCode && xaerr.errorCode <= 107 || xaerr.errorCode == -4 ? 1 : 0) != 0);
        }
    }

    private void doSomeWorkWithXa(HazelcastXAResource xaResource) throws Exception {
        xaResource.start(this.xid, 0);
        TransactionContext context = xaResource.getTransactionContext();
        TransactionalMap map = context.getMap("map");
        map.put((Object)"key", (Object)"value");
        TransactionalQueue queue = context.getQueue("queue");
        queue.offer((Object)"item");
        TransactionalList list = context.getList("list");
        list.add((Object)"item");
        TransactionalSet set = context.getSet("set");
        set.add((Object)"item");
        TransactionalMultiMap mm = context.getMultiMap("mm");
        mm.put((Object)"key", (Object)"value");
        xaResource.end(this.xid, 0x4000000);
    }

    private void performPrepareWithXa(XAResource xaResource) throws XAException {
        xaResource.prepare(this.xid);
    }

    private void recover(XAResource xaResource) throws XAException {
        xaResource.recover(0x1800000);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testManualBeginShouldThrowException() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext transactionContext = this.xaResource.getTransactionContext();
        transactionContext.beginTransaction();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testManualCommitShouldThrowException() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext transactionContext = this.xaResource.getTransactionContext();
        transactionContext.commitTransaction();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testManualRollbackShouldThrowException() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext transactionContext = this.xaResource.getTransactionContext();
        transactionContext.rollbackTransaction();
    }

    @Test
    public void testTransactionTimeout() throws XAException {
        boolean timeoutSet = this.xaResource.setTransactionTimeout(2);
        Assert.assertTrue((boolean)timeoutSet);
        this.xaResource.start(this.xid, 0);
        TransactionContext context = this.xaResource.getTransactionContext();
        TransactionalMap map = context.getMap("map");
        map.put((Object)"key", (Object)"val");
        this.xaResource.end(this.xid, 0x4000000);
        ClientXACompatibilityTest.sleepSeconds((int)3);
        try {
            this.xaResource.commit(this.xid, true);
            Assert.fail();
        }
        catch (XAException e) {
            Assert.assertEquals((long)106L, (long)e.errorCode);
        }
    }

    @Test
    public void testRollbackWithoutPrepare() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performRollbackWithXa((XAResource)this.xaResource);
    }

    @Test
    public void testRollbackWithoutPrepare_EmptyTransactionLog() throws Exception {
        this.xaResource.start(this.xid, 0);
        this.xaResource.end(this.xid, 0x4000000);
        this.performRollbackWithXa((XAResource)this.xaResource);
    }

    @Test
    public void testRollbackWithoutPrepare_SecondXAResource() throws Exception {
        this.doSomeWorkWithXa(this.xaResource);
        this.performRollbackWithXa((XAResource)this.secondXaResource);
    }

    @Test
    public void testRollbackWithoutPrepare_SecondXAResource_EmptyTransactionLog() throws Exception {
        this.xaResource.start(this.xid, 0);
        this.xaResource.end(this.xid, 0x4000000);
        this.performRollbackWithXa((XAResource)this.secondXaResource);
    }

    @Test
    public void testEnd_FromDifferentThread() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext context = this.xaResource.getTransactionContext();
        TransactionalMap map = context.getMap("map");
        map.put((Object)"key", (Object)"value");
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    ClientXACompatibilityTest.this.xaResource.end(ClientXACompatibilityTest.this.xid, 0x20000000);
                    latch.countDown();
                }
                catch (XAException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        ClientXACompatibilityTest.assertOpenEventually((CountDownLatch)latch, (long)10L);
    }

    @Test(expected=XAException.class)
    public void testStart_NoFlag_ExistingXid() throws Exception {
        this.xaResource.start(this.xid, 0);
        this.xaResource.start(this.xid, 0);
    }

    @Test(expected=XAException.class)
    public void testStart_JoinFlag_TransactionNotExists() throws Exception {
        this.xaResource.start(this.xid, 0x200000);
    }

    @Test(expected=XAException.class)
    public void testStart_InvalidFlag() throws Exception {
        this.xaResource.start(this.xid, -1);
    }

    @Test(expected=XAException.class)
    public void testPrepare_TransactionNotExists() throws Exception {
        this.xaResource.prepare(this.xid);
    }

    @Test(expected=XAException.class)
    public void testCommit_OnePhase_TransactionNotExists() throws Exception {
        this.xaResource.commit(this.xid, true);
    }

    @Test(expected=XAException.class)
    public void testForget_TransactionNotExists() throws Exception {
        this.xaResource.forget(this.xid);
    }

    @Test(expected=XAException.class)
    public void testForget() throws Exception {
        this.xaResource.start(this.xid, 0);
        this.xaResource.forget(this.xid);
        this.xaResource.commit(this.xid, true);
    }

    @Test
    public void testDefaultTransactionTimeout() throws Exception {
        Assert.assertEquals((long)120L, (long)this.xaResource.getTransactionTimeout());
    }

    @Test
    public void testSetTransactionTimeout() throws Exception {
        Assert.assertTrue((boolean)this.xaResource.setTransactionTimeout(10));
        Assert.assertEquals((long)10L, (long)this.xaResource.getTransactionTimeout());
    }

    @Test
    public void testSetTransactionTimeoutToDefault() throws Exception {
        this.xaResource.setTransactionTimeout(10);
        Assert.assertTrue((boolean)this.xaResource.setTransactionTimeout(0));
        Assert.assertEquals((long)120L, (long)this.xaResource.getTransactionTimeout());
    }

    @Test
    public void testJoin_DifferentThread() throws Exception {
        final String name = ClientXACompatibilityTest.randomString();
        String key1 = ClientXACompatibilityTest.randomString();
        final String key2 = ClientXACompatibilityTest.randomString();
        String val1 = ClientXACompatibilityTest.randomString();
        final String val2 = ClientXACompatibilityTest.randomString();
        this.xaResource.start(this.xid, 0);
        TransactionContext context = this.xaResource.getTransactionContext();
        TransactionalMap map = context.getMap(name);
        map.put((Object)key1, (Object)val1);
        this.xaResource.end(this.xid, 0x4000000);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ClientXACompatibilityTest.this.xaResource.start(ClientXACompatibilityTest.this.xid, 0x200000);
                    TransactionContext transactionContext = ClientXACompatibilityTest.this.xaResource.getTransactionContext();
                    TransactionalMap m = transactionContext.getMap(name);
                    m.put((Object)key2, (Object)val2);
                    ClientXACompatibilityTest.this.xaResource.end(ClientXACompatibilityTest.this.xid, 0x4000000);
                }
                catch (XAException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        thread.join();
        this.xaResource.commit(this.xid, true);
        IMap m = this.client.getMap(name);
        Assert.assertEquals((Object)val1, (Object)m.get((Object)key1));
        Assert.assertEquals((Object)val2, (Object)m.get((Object)key2));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetXAResource_TransactionProxy() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext transactionContext = this.xaResource.getTransactionContext();
        transactionContext.getXaResource();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTransactionObject_UnknownService() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext transactionContext = this.xaResource.getTransactionContext();
        transactionContext.getTransactionalObject("hz:impl:topicService", "topic");
    }

    @Test(expected=TransactionNotActiveException.class)
    public void testPrepare_AlreadyPreparedTransaction() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext context = this.xaResource.getTransactionContext();
        TransactionalMap map = context.getMap("map");
        map.put((Object)"key", (Object)"val");
        this.xaResource.end(this.xid, 0x4000000);
        this.xaResource.prepare(this.xid);
        this.xaResource.prepare(this.xid);
    }

    @Test(expected=TransactionException.class)
    public void testCommit_OnePhase_Prepared() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext context = this.xaResource.getTransactionContext();
        TransactionalMap map = context.getMap("map");
        map.put((Object)"key", (Object)"val");
        this.xaResource.end(this.xid, 0x4000000);
        this.xaResource.prepare(this.xid);
        this.xaResource.commit(this.xid, true);
    }

    @Test(expected=TransactionException.class)
    public void testCommit_TwoPhase_NonPrepared() throws Exception {
        this.xaResource.start(this.xid, 0);
        TransactionContext context = this.xaResource.getTransactionContext();
        TransactionalMap map = context.getMap("map");
        map.put((Object)"key", (Object)"val");
        this.xaResource.end(this.xid, 0x4000000);
        this.xaResource.commit(this.xid, false);
    }
}

