/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.connection.nio.ClientReadHandler;
import com.hazelcast.client.connection.nio.ClientWriteHandler;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataAdapter;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnection
implements Connection,
Closeable {
    private volatile boolean live = true;
    private final ILogger logger = Logger.getLogger(ClientConnection.class);
    private final ClientWriteHandler writeHandler;
    private final ClientReadHandler readHandler;
    private final ClientConnectionManagerImpl connectionManager;
    private final int connectionId;
    private final SocketChannelWrapper socketChannelWrapper;
    private volatile Address remoteEndpoint;
    private final ConcurrentMap<Integer, ClientCallFuture> callIdMap = new ConcurrentHashMap<Integer, ClientCallFuture>();
    private final ConcurrentMap<Integer, ClientCallFuture> eventHandlerMap = new ConcurrentHashMap<Integer, ClientCallFuture>();
    private final ByteBuffer readBuffer;
    private final SerializationService serializationService;
    private final ClientExecutionService executionService;
    private boolean readFromSocket = true;
    private final AtomicInteger packetCount = new AtomicInteger(0);

    public ClientConnection(ClientConnectionManagerImpl connectionManager, IOSelector in, IOSelector out, int connectionId, SocketChannelWrapper socketChannelWrapper, ClientExecutionService executionService) throws IOException {
        Socket socket = socketChannelWrapper.socket();
        this.connectionManager = connectionManager;
        this.serializationService = connectionManager.getSerializationService();
        this.executionService = executionService;
        this.socketChannelWrapper = socketChannelWrapper;
        this.connectionId = connectionId;
        this.readHandler = new ClientReadHandler(this, in, socket.getReceiveBufferSize());
        this.writeHandler = new ClientWriteHandler(this, out, socket.getSendBufferSize());
        this.readBuffer = ByteBuffer.allocate(socket.getReceiveBufferSize());
    }

    public void incrementPacketCount() {
        this.packetCount.incrementAndGet();
    }

    public void decrementPacketCount() {
        this.packetCount.decrementAndGet();
    }

    public void registerCallId(ClientCallFuture future) {
        int callId = this.connectionManager.newCallId();
        future.getRequest().setCallId(callId);
        this.callIdMap.put(callId, future);
        if (future.getHandler() != null) {
            this.eventHandlerMap.put(callId, future);
        }
    }

    public ClientCallFuture deRegisterCallId(int callId) {
        return (ClientCallFuture)this.callIdMap.remove(callId);
    }

    public ClientCallFuture deRegisterEventHandler(int callId) {
        return (ClientCallFuture)this.eventHandlerMap.remove(callId);
    }

    public EventHandler getEventHandler(int callId) {
        ClientCallFuture future = (ClientCallFuture)this.eventHandlerMap.get(callId);
        if (future == null) {
            return null;
        }
        return future.getHandler();
    }

    public boolean write(SocketWritable packet) {
        if (!this.live) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, won't write packet -> " + packet);
            }
            return false;
        }
        this.writeHandler.enqueueSocketWritable(packet);
        return true;
    }

    public void init() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        buffer.put(StringUtil.stringToBytes((String)"CB1"));
        buffer.put(StringUtil.stringToBytes((String)"JVM"));
        buffer.flip();
        this.socketChannelWrapper.write(buffer);
    }

    public void write(Data data) throws IOException {
        int totalSize = data.totalSize();
        int bufferSize = 16384;
        ByteBuffer buffer = ByteBuffer.allocate(totalSize > 16384 ? 16384 : totalSize);
        DataAdapter packet = new DataAdapter(data);
        boolean complete = false;
        while (!complete) {
            complete = packet.writeTo(buffer);
            buffer.flip();
            try {
                this.socketChannelWrapper.write(buffer);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
            buffer.clear();
        }
    }

    public Data read() throws IOException {
        ClientPacket packet = new ClientPacket(this.serializationService.getSerializationContext());
        while (true) {
            boolean complete;
            if (this.readFromSocket) {
                int readBytes = this.socketChannelWrapper.read(this.readBuffer);
                if (readBytes == -1) {
                    throw new EOFException("Remote socket closed!");
                }
                this.readBuffer.flip();
            }
            if (complete = packet.readFrom(this.readBuffer)) {
                if (this.readBuffer.hasRemaining()) {
                    this.readFromSocket = false;
                } else {
                    this.readBuffer.compact();
                    this.readFromSocket = true;
                }
                return packet.getData();
            }
            this.readFromSocket = true;
            this.readBuffer.clear();
        }
    }

    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    public boolean live() {
        return this.live;
    }

    public long lastReadTime() {
        return this.readHandler.getLastHandle();
    }

    public long lastWriteTime() {
        return this.writeHandler.getLastHandle();
    }

    @Override
    public void close() {
        this.close(null);
    }

    public ConnectionType getType() {
        return ConnectionType.JAVA_CLIENT;
    }

    public boolean isClient() {
        return true;
    }

    public InetAddress getInetAddress() {
        return this.socketChannelWrapper.socket().getInetAddress();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getRemoteSocketAddress();
    }

    public int getPort() {
        return this.socketChannelWrapper.socket().getPort();
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannelWrapper;
    }

    public ClientConnectionManagerImpl getConnectionManager() {
        return this.connectionManager;
    }

    public ClientReadHandler getReadHandler() {
        return this.readHandler;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public Address getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getLocalSocketAddress();
    }

    void innerClose() throws IOException {
        if (!this.live) {
            return;
        }
        this.live = false;
        if (this.socketChannelWrapper.isOpen()) {
            this.socketChannelWrapper.close();
        }
        this.readHandler.shutdown();
        this.writeHandler.shutdown();
        if (this.socketChannelWrapper.isBlocking()) {
            return;
        }
        if (this.connectionManager.isLive()) {
            try {
                this.executionService.execute(new CleanResourcesTask());
            }
            catch (RejectedExecutionException e) {
                this.logger.warning("Execution rejected ", (Throwable)e);
            }
        } else {
            this.cleanResources(new HazelcastException("Client is shutting down!!!"));
        }
    }

    private void cleanResources(HazelcastException response) {
        Iterator iter = this.callIdMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            iter.remove();
            ((ClientCallFuture)entry.getValue()).notify(response);
            this.eventHandlerMap.remove(entry.getKey());
        }
        Iterator iterator = this.eventHandlerMap.values().iterator();
        while (iterator.hasNext()) {
            ClientCallFuture future = (ClientCallFuture)iterator.next();
            iterator.remove();
            future.notify(response);
        }
    }

    public void close(Throwable t) {
        if (!this.live) {
            return;
        }
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning((Throwable)e);
        }
        String message = "Connection [" + this.socketChannelWrapper.socket().getRemoteSocketAddress() + "] lost. Reason: ";
        message = t != null ? message + t.getClass().getName() + "[" + t.getMessage() + "]" : message + "Socket explicitly closed";
        this.logger.warning(message);
        if (!this.socketChannelWrapper.isBlocking()) {
            this.connectionManager.destroyConnection(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientConnection{");
        sb.append("live=").append(this.live);
        sb.append(", writeHandler=").append(this.writeHandler);
        sb.append(", readHandler=").append(this.readHandler);
        sb.append(", connectionId=").append(this.connectionId);
        sb.append(", socketChannel=").append(this.socketChannelWrapper);
        sb.append(", remoteEndpoint=").append(this.remoteEndpoint);
        sb.append('}');
        return sb.toString();
    }

    private class CleanResourcesTask
    implements Runnable {
        private CleanResourcesTask() {
        }

        @Override
        public void run() {
            this.waitForPacketsProcessed();
            ClientConnection.this.cleanResources((HazelcastException)new TargetDisconnectedException(ClientConnection.this.remoteEndpoint));
        }

        private void waitForPacketsProcessed() {
            long begin = System.currentTimeMillis();
            int count = ClientConnection.this.packetCount.get();
            while (count != 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    ClientConnection.this.logger.warning((Throwable)e);
                    break;
                }
                long elapsed = System.currentTimeMillis() - begin;
                if (elapsed > 5000L) {
                    ClientConnection.this.logger.warning("There are packets which are not processed " + count);
                    break;
                }
                count = ClientConnection.this.packetCount.get();
            }
        }
    }
}

