/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public final class ClientInvocationServiceImpl
implements ClientInvocationService {
    private final ILogger logger = Logger.getLogger(ClientInvocationService.class);
    private final HazelcastClient client;
    private final ClientConnectionManager connectionManager;
    private final ResponseThread responseThread;
    private volatile boolean isShutdown;

    public ClientInvocationServiceImpl(HazelcastClient client) {
        this.client = client;
        this.connectionManager = client.getConnectionManager();
        this.responseThread = new ResponseThread(client.getThreadGroup(), client.getName() + ".response-", client.getClientConfig().getClassLoader());
        this.responseThread.start();
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnRandomTarget(ClientRequest request) throws Exception {
        return this.send(request);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnTarget(ClientRequest request, Address target) throws Exception {
        return this.send(request, target);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnKeyOwner(ClientRequest request, Object key) throws Exception {
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        Address owner = partitionService.getPartitionOwner(partitionService.getPartitionId(key));
        if (owner != null) {
            return this.invokeOnTarget(request, owner);
        }
        return this.invokeOnRandomTarget(request);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnRandomTarget(ClientRequest request, EventHandler handler) throws Exception {
        return this.sendAndHandle(request, handler);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnTarget(ClientRequest request, Address target, EventHandler handler) throws Exception {
        return this.sendAndHandle(request, target, handler);
    }

    @Override
    public <T> ICompletableFuture<T> invokeOnKeyOwner(ClientRequest request, Object key, EventHandler handler) throws Exception {
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        Address owner = partitionService.getPartitionOwner(partitionService.getPartitionId(key));
        if (owner != null) {
            return this.invokeOnTarget(request, owner, handler);
        }
        return this.invokeOnRandomTarget(request, handler);
    }

    public ICompletableFuture send(ClientRequest request, ClientConnection connection) {
        request.setSingleConnection();
        return this.doSend(request, connection, null);
    }

    public Future reSend(ClientCallFuture future) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(null);
        this.sendInternal(future, connection);
        return future;
    }

    public boolean isRedoOperation() {
        return this.client.getClientConfig().isRedoOperation();
    }

    private ICompletableFuture send(ClientRequest request) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(null);
        return this.doSend(request, connection, null);
    }

    private ICompletableFuture send(ClientRequest request, Address target) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(target);
        return this.doSend(request, connection, null);
    }

    private ICompletableFuture sendAndHandle(ClientRequest request, EventHandler handler) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(null);
        return this.doSend(request, connection, handler);
    }

    private ICompletableFuture sendAndHandle(ClientRequest request, Address target, EventHandler handler) throws Exception {
        ClientConnection connection = this.connectionManager.tryToConnect(target);
        return this.doSend(request, connection, handler);
    }

    private ICompletableFuture doSend(ClientRequest request, ClientConnection connection, EventHandler handler) {
        ClientCallFuture future = new ClientCallFuture(this.client, request, handler);
        this.sendInternal(future, connection);
        return future;
    }

    private void sendInternal(ClientCallFuture future, ClientConnection connection) {
        connection.registerCallId(future);
        future.setConnection(connection);
        SerializationService ss = this.client.getSerializationService();
        Data data = ss.toData((Object)future.getRequest());
        if (!connection.write((SocketWritable)new Packet(data, ss.getPortableContext()))) {
            int callId = future.getRequest().getCallId();
            connection.deRegisterCallId(callId);
            connection.deRegisterEventHandler(callId);
            future.notify(new TargetNotMemberException("Address : " + connection.getRemoteEndpoint()));
        }
    }

    public void shutdown() {
        this.isShutdown = true;
        this.responseThread.interrupt();
    }

    public void handlePacket(Packet packet) {
        this.responseThread.workQueue.add(packet);
    }

    private class ResponseThread
    extends Thread {
        private final BlockingQueue<Packet> workQueue;

        public ResponseThread(ThreadGroup threadGroup, String name, ClassLoader classLoader) {
            super(threadGroup, name);
            this.workQueue = new LinkedBlockingQueue<Packet>();
            this.setContextClassLoader(classLoader);
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
            }
            catch (Throwable t) {
                ClientInvocationServiceImpl.this.logger.severe(t);
            }
        }

        private void doRun() {
            while (true) {
                Packet task;
                try {
                    task = this.workQueue.take();
                }
                catch (InterruptedException e) {
                    if (!ClientInvocationServiceImpl.this.isShutdown) continue;
                    return;
                }
                if (ClientInvocationServiceImpl.this.isShutdown) {
                    return;
                }
                this.process(task);
            }
        }

        private void process(Packet packet) {
            try {
                ClientConnection conn = (ClientConnection)packet.getConn();
                ClientResponse clientResponse = (ClientResponse)ClientInvocationServiceImpl.this.client.getSerializationService().toObject((Object)packet.getData());
                int callId = clientResponse.getCallId();
                Data response = clientResponse.getResponse();
                this.handlePacket(response, clientResponse.isError(), callId, conn);
                conn.decrementPacketCount();
            }
            catch (Exception e) {
                ClientInvocationServiceImpl.this.logger.severe("Failed to process task: " + packet + " on responseThread :" + this.getName());
            }
        }

        private void handlePacket(Object response, boolean isError, int callId, ClientConnection conn) {
            ClientCallFuture future = conn.deRegisterCallId(callId);
            if (future == null) {
                ClientInvocationServiceImpl.this.logger.warning("No call for callId: " + callId + ", response: " + response);
                return;
            }
            if (isError) {
                response = ClientInvocationServiceImpl.this.client.getSerializationService().toObject(response);
            }
            future.notify(response);
        }
    }
}

