/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.StripedExecutor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class ClientListenerServiceImpl
implements ClientListenerService {
    private final ILogger logger = Logger.getLogger(ClientInvocationService.class);
    private final ClientConnectionManager connectionManager;
    private final SerializationService serializationService;
    private final ClientInvocationService invocationService;
    private final ConcurrentMap<String, Integer> registrationMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, String> registrationAliasMap = new ConcurrentHashMap<String, String>();
    private final StripedExecutor eventExecutor;
    private final Set<ClientCallFuture> failedListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public ClientListenerServiceImpl(HazelcastClient client, int eventThreadCount, int eventQueueCapacity) {
        this.connectionManager = client.getConnectionManager();
        this.serializationService = client.getSerializationService();
        this.invocationService = client.getInvocationService();
        this.eventExecutor = new StripedExecutor(this.logger, client.getName() + ".event", client.getThreadGroup(), eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String listen(ClientRequest request, Object key, EventHandler handler) {
        try {
            ICompletableFuture future = key == null ? this.invocationService.invokeOnRandomTarget(request, handler) : this.invocationService.invokeOnKeyOwner(request, key, handler);
            String registrationId = (String)this.serializationService.toObject(future.get());
            this.registerListener(registrationId, request.getCallId());
            return registrationId;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public boolean stopListening(BaseClientRemoveListenerRequest request, String registrationId) {
        try {
            String realRegistrationId = this.deRegisterListener(registrationId);
            if (realRegistrationId == null) {
                return false;
            }
            request.setRegistrationId(realRegistrationId);
            ICompletableFuture future = this.invocationService.invokeOnRandomTarget((ClientRequest)request);
            return (Boolean)this.serializationService.toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void registerFailedListener(ClientCallFuture future) {
        this.failedListeners.add(future);
    }

    public void triggerFailedListeners() {
        Iterator<ClientCallFuture> iterator = this.failedListeners.iterator();
        while (iterator.hasNext()) {
            ClientCallFuture failedListener = iterator.next();
            iterator.remove();
            failedListener.resend();
        }
    }

    public void registerListener(String uuid, Integer callId) {
        this.registrationAliasMap.put(uuid, uuid);
        this.registrationMap.put(uuid, callId);
    }

    public void reRegisterListener(String uuid, String alias, Integer callId) {
        String oldAlias = this.registrationAliasMap.put(uuid, alias);
        if (oldAlias != null) {
            this.registrationMap.remove(oldAlias);
            this.registrationMap.put(alias, callId);
        }
    }

    public String deRegisterListener(String alias) {
        String uuid = (String)this.registrationAliasMap.remove(alias);
        if (uuid != null) {
            Integer callId = (Integer)this.registrationMap.remove(alias);
            this.connectionManager.removeEventHandler(callId);
        }
        return uuid;
    }

    public void handleEventPacket(Packet packet) {
        try {
            this.eventExecutor.execute((Runnable)new ClientEventProcessor(packet));
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, " event packet could not be handled ", (Throwable)e);
        }
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
    }

    private final class ClientEventProcessor
    implements Runnable {
        final Packet packet;

        private ClientEventProcessor(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            ClientConnection conn = (ClientConnection)this.packet.getConn();
            ClientResponse clientResponse = (ClientResponse)ClientListenerServiceImpl.this.serializationService.toObject((Object)this.packet.getData());
            int callId = clientResponse.getCallId();
            Data response = clientResponse.getResponse();
            this.handleEvent(response, callId, conn);
        }

        private void handleEvent(Data event, int callId, ClientConnection conn) {
            EventHandler eventHandler = conn.getEventHandler(callId);
            Object eventObject = ClientListenerServiceImpl.this.serializationService.toObject((Object)event);
            if (eventHandler == null) {
                ClientListenerServiceImpl.this.logger.warning("No eventHandler for callId: " + callId + ", event: " + eventObject + ", conn: " + conn);
                return;
            }
            eventHandler.handle(eventObject);
        }
    }
}

