/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.util.ClientCancellableDelegatingFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.executor.impl.RunnableAdapter;
import com.hazelcast.executor.impl.client.IsShutdownRequest;
import com.hazelcast.executor.impl.client.PartitionTargetCallableRequest;
import com.hazelcast.executor.impl.client.ShutdownRequest;
import com.hazelcast.executor.impl.client.SpecificTargetCallableRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.Address;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientExecutorServiceProxy
extends ClientProxy
implements IExecutorService {
    private static final int MIN_TIME_RESOLUTION_OF_CONSECUTIVE_SUBMITS = 10;
    private static final int MAX_CONSECUTIVE_SUBMITS = 100;
    private final String name;
    private final Random random = new Random(-System.currentTimeMillis());
    private final AtomicInteger consecutiveSubmits = new AtomicInteger();
    private volatile long lastSubmitTime;

    public ClientExecutorServiceProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public void execute(Runnable command) {
        this.submit(command);
    }

    public void executeOnKeyOwner(Runnable command, Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner((Callable)callable, key);
    }

    public void executeOnMember(Runnable command, Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember((Callable)callable, member);
    }

    public void executeOnMembers(Runnable command, Collection<Member> members) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        for (Member member : members) {
            this.submitToMember((Callable)callable, member);
        }
    }

    public void execute(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.executeOnMember(command, members.get(selectedMember));
    }

    public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        this.executeOnMembers(command, members);
    }

    public void executeOnAllMembers(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        for (MemberImpl member : memberList) {
            this.submitToMember((Callable)callable, (Member)member);
        }
    }

    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        Address memberAddress = this.getMemberAddress(member);
        return this.submitToTargetInternal(task, memberAddress, null, false);
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(members.size());
        for (Member member : members) {
            Address memberAddress = this.getMemberAddress(member);
            Future<Object> f = this.submitToTargetInternal(task, memberAddress, null, true);
            futureMap.put(member, f);
        }
        return futureMap;
    }

    public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        return this.submitToMember(task, members.get(selectedMember));
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
        List<Member> members = this.selectMembers(memberSelector);
        return this.submitToMembers(task, members);
    }

    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(memberList.size());
        for (MemberImpl m : memberList) {
            Future<Object> f = this.submitToTargetInternal(task, m.getAddress(), null, true);
            futureMap.put((Member)m, f);
        }
        return futureMap;
    }

    public void submitToMember(Runnable command, Member member, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToMember((Callable)callable, member, (ExecutionCallback)callback);
    }

    public void submitToMembers(Runnable command, Collection<Member> members, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember((Callable)callable, member, executionCallback);
        }
    }

    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        Address memberAddress = this.getMemberAddress(member);
        this.submitToTargetInternal(task, memberAddress, callback);
    }

    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, member, executionCallback);
        }
    }

    public void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        List<Member> members = this.selectMembers(memberSelector);
        int selectedMember = this.random.nextInt(members.size());
        this.submitToMember(task, members.get(selectedMember), callback);
    }

    public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        List<Member> members = this.selectMembers(memberSelector);
        this.submitToMembers(task, members, callback);
    }

    public void submitToAllMembers(Runnable command, MultiExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToAllMembers((Callable)callable, callback);
    }

    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(memberList.size(), callback);
        for (MemberImpl member : memberList) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, (Member)member);
            this.submitToMember(task, (Member)member, executionCallback);
        }
    }

    public Future<?> submit(Runnable command) {
        Object partitionKey = this.getTaskPartitionKey(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        if (partitionKey != null) {
            return this.submitToKeyOwner((Callable)callable, partitionKey);
        }
        return this.submitToRandomInternal((Callable)callable, null, false);
    }

    public <T> Future<T> submit(Runnable command, T result) {
        Object partitionKey = this.getTaskPartitionKey(command);
        RunnableAdapter<T> callable = this.createRunnableAdapter(command);
        if (partitionKey != null) {
            return this.submitToKeyOwnerInternal((Callable<T>)callable, partitionKey, result, false);
        }
        return this.submitToRandomInternal((Callable<T>)callable, result, false);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Object partitionKey = this.getTaskPartitionKey(task);
        if (partitionKey != null) {
            return this.submitToKeyOwner(task, partitionKey);
        }
        return this.submitToRandomInternal(task, null, false);
    }

    public void submit(Runnable command, ExecutionCallback callback) {
        Object partitionKey = this.getTaskPartitionKey(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        if (partitionKey != null) {
            this.submitToKeyOwnerInternal((Callable)callable, partitionKey, (ExecutionCallback)callback);
        } else {
            this.submitToRandomInternal((Callable)callable, (ExecutionCallback)callback);
        }
    }

    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        Object partitionKey = this.getTaskPartitionKey(task);
        if (partitionKey != null) {
            this.submitToKeyOwnerInternal(task, partitionKey, callback);
        } else {
            this.submitToRandomInternal(task, callback);
        }
    }

    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        return this.submitToKeyOwnerInternal(task, key, null, false);
    }

    public void submitToKeyOwner(Runnable command, Object key, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwner((Callable)callable, key, (ExecutionCallback)callback);
    }

    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        this.submitToKeyOwnerInternal(task, key, callback);
    }

    public LocalExecutorStats getLocalExecutorStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public void shutdown() {
        ShutdownRequest request = new ShutdownRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    public boolean isShutdown() {
        IsShutdownRequest request = new IsShutdownRequest(this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isTerminated() {
        return this.isShutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            futures.add(this.submitToRandomInternal(task, null, true));
        }
        ExecutorService asyncExecutor = this.getContext().getExecutionService().getAsyncExecutor();
        for (Future future : futures) {
            Object value = this.retrieveResult(future);
            result.add((Future<T>)new CompletedFuture(this.getContext().getSerializationService(), value, asyncExecutor));
        }
        return result;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    private Object getTaskPartitionKey(Object task) {
        if (task instanceof PartitionAware) {
            return ((PartitionAware)task).getPartitionKey();
        }
        return null;
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    private <T> Future<T> submitToKeyOwnerInternal(Callable<T> task, Object key, T defaultValue, boolean preventSync) {
        Preconditions.checkNotNull(task, (String)"task should not be null");
        String uuid = this.getUUID();
        int partitionId = this.getPartitionId(key);
        PartitionTargetCallableRequest request = new PartitionTargetCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture<T> f = this.invokeOnPartitionOwner((ClientRequest)request, partitionId);
        return this.checkSync(f, uuid, null, partitionId, preventSync, defaultValue);
    }

    private <T> void submitToKeyOwnerInternal(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, (String)"task should not be null");
        String uuid = this.getUUID();
        int partitionId = this.getPartitionId(key);
        PartitionTargetCallableRequest request = new PartitionTargetCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture<T> f = this.invokeOnPartitionOwner((ClientRequest)request, partitionId);
        f.andThen(callback);
    }

    private <T> Future<T> submitToRandomInternal(Callable<T> task, T defaultValue, boolean preventSync) {
        Preconditions.checkNotNull(task, (String)"task should not be null");
        String uuid = this.getUUID();
        int partitionId = this.randomPartitionId();
        PartitionTargetCallableRequest request = new PartitionTargetCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture<T> f = this.invokeOnPartitionOwner((ClientRequest)request, partitionId);
        return this.checkSync(f, uuid, null, partitionId, preventSync, defaultValue);
    }

    private <T> void submitToRandomInternal(Callable<T> task, ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, (String)"task should not be null");
        String uuid = this.getUUID();
        int partitionId = this.randomPartitionId();
        PartitionTargetCallableRequest request = new PartitionTargetCallableRequest(this.name, uuid, task, partitionId);
        ICompletableFuture<T> f = this.invokeOnPartitionOwner((ClientRequest)request, partitionId);
        f.andThen(callback);
    }

    private <T> Future<T> submitToTargetInternal(Callable<T> task, Address address, T defaultValue, boolean preventSync) {
        Preconditions.checkNotNull(task, (String)"task should not be null");
        String uuid = this.getUUID();
        SpecificTargetCallableRequest request = new SpecificTargetCallableRequest(this.name, uuid, task, address);
        ICompletableFuture<T> f = this.invokeOnTarget((TargetClientRequest)request, address);
        return this.checkSync(f, uuid, address, -1, preventSync, defaultValue);
    }

    private <T> void submitToTargetInternal(Callable<T> task, Address address, ExecutionCallback<T> callback) {
        Preconditions.checkNotNull(task, (String)"task should not be null");
        SpecificTargetCallableRequest request = new SpecificTargetCallableRequest(this.name, null, task, address);
        ICompletableFuture<T> f = this.invokeOnTarget((TargetClientRequest)request, address);
        f.andThen(callback);
    }

    public String toString() {
        return "IExecutorService{name='" + this.getName() + '\'' + '}';
    }

    private <T> Future<T> checkSync(ICompletableFuture<T> f, String uuid, Address address, int partitionId, boolean preventSync, T defaultValue) {
        boolean sync = this.isSyncComputation(preventSync);
        if (sync) {
            Object response = this.retrieveResult((Future<T>)f);
            ExecutorService asyncExecutor = this.getContext().getExecutionService().getAsyncExecutor();
            return new CompletedFuture(this.getContext().getSerializationService(), response, asyncExecutor);
        }
        return new ClientCancellableDelegatingFuture<T>(f, this.getContext(), uuid, address, partitionId, defaultValue);
    }

    private <T> Object retrieveResult(Future<T> f) {
        Object response;
        try {
            response = f.get();
        }
        catch (Exception e) {
            response = e;
        }
        return response;
    }

    private boolean isSyncComputation(boolean preventSync) {
        long now = Clock.currentTimeMillis();
        long last = this.lastSubmitTime;
        this.lastSubmitTime = now;
        AtomicInteger consecutiveSubmits = this.consecutiveSubmits;
        if (last + 10L < now) {
            consecutiveSubmits.set(0);
            return false;
        }
        return !preventSync && consecutiveSubmits.incrementAndGet() % 100 == 0;
    }

    private List<Member> selectMembers(MemberSelector memberSelector) {
        if (memberSelector == null) {
            throw new IllegalArgumentException("memberSelector must not be null");
        }
        ArrayList<Member> selected = new ArrayList<Member>();
        Collection<MemberImpl> members = this.getContext().getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (!memberSelector.select((Member)member)) continue;
            selected.add((Member)member);
        }
        if (selected.isEmpty()) {
            throw new RejectedExecutionException("No member selected with memberSelector[" + memberSelector + "]");
        }
        return selected;
    }

    private <T> ICompletableFuture<T> invokeOnPartitionOwner(ClientRequest request, int partitionId) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, partitionId);
            return clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private <T> ICompletableFuture<T> invokeOnTarget(TargetClientRequest request, Address target) {
        try {
            ClientInvocation invocation = new ClientInvocation(this.getClient(), (ClientRequest)request, target);
            return invocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private String getUUID() {
        return UuidUtil.buildRandomUuidString();
    }

    private Address getMemberAddress(Member member) {
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException(member + " is not available!!!");
        }
        return m.getAddress();
    }

    private int getPartitionId(Object key) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return partitionService.getPartitionId(key);
    }

    private int randomPartitionId() {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        return this.random.nextInt(partitionService.getPartitionCount());
    }

    private static final class MultiExecutionCallbackWrapper
    implements MultiExecutionCallback {
        private final MultiExecutionCallback multiExecutionCallback;
        private final Map<Member, Object> values;
        private final AtomicInteger members;

        private MultiExecutionCallbackWrapper(int memberSize, MultiExecutionCallback multiExecutionCallback) {
            this.multiExecutionCallback = multiExecutionCallback;
            this.values = Collections.synchronizedMap(new HashMap(memberSize));
            this.members = new AtomicInteger(memberSize);
        }

        public void onResponse(Member member, Object value) {
            this.multiExecutionCallback.onResponse(member, value);
            this.values.put(member, value);
            int waitingResponse = this.members.decrementAndGet();
            if (waitingResponse == 0) {
                this.onComplete(this.values);
            }
        }

        public void onComplete(Map<Member, Object> values) {
            this.multiExecutionCallback.onComplete(values);
        }
    }

    private static final class ExecutionCallbackWrapper<T>
    implements ExecutionCallback<T> {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper;
        Member member;

        private ExecutionCallbackWrapper(MultiExecutionCallbackWrapper multiExecutionCallback, Member member) {
            this.multiExecutionCallbackWrapper = multiExecutionCallback;
            this.member = member;
        }

        public void onResponse(T response) {
            this.multiExecutionCallbackWrapper.onResponse(this.member, response);
        }

        public void onFailure(Throwable t) {
        }
    }
}

