/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientOutSelectorImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.cluster.client.ClientPingRequest;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.IOSelectorOutOfMemoryHandler;
import com.hazelcast.nio.tcp.InSelectorImpl;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final ILogger LOGGER = Logger.getLogger(ClientConnectionManagerImpl.class);
    private static final IOSelectorOutOfMemoryHandler OUT_OF_MEMORY_HANDLER = new IOSelectorOutOfMemoryHandler(){

        public void handle(OutOfMemoryError error) {
            LOGGER.severe((Throwable)error);
        }
    };
    private final int connectionTimeout;
    private final int heartBeatInterval;
    private final int heartBeatTimeout;
    private final ConcurrentMap<Address, Object> connectionLockMap = new ConcurrentHashMap<Address, Object>();
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    private final HazelcastClientInstanceImpl client;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private IOSelector inSelector;
    private IOSelector outSelector;
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ClientExecutionServiceImpl executionService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> connections = new ConcurrentHashMap<Address, ClientConnection>();
    private final Set<Address> connectionsInProgress = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Set<ConnectionHeartbeatListener> heartbeatListeners = new CopyOnWriteArraySet<ConnectionHeartbeatListener>();
    protected volatile boolean alive;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client, AddressTranslator addressTranslator) {
        this.client = client;
        this.addressTranslator = addressTranslator;
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeout = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        ClientProperties clientProperties = client.getClientProperties();
        int timeout = clientProperties.getHeartbeatTimeout().getInteger();
        this.heartBeatTimeout = timeout > 0 ? timeout : Integer.parseInt("60000");
        int interval = clientProperties.getHeartbeatInterval().getInteger();
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt("5000");
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.initializeSelectors(client);
        this.socketOptions = networkConfig.getSocketOptions();
        ClientExtension clientExtension = client.getClientExtension();
        this.socketChannelWrapperFactory = clientExtension.createSocketChannelWrapperFactory();
        this.socketInterceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
    }

    protected void initializeSelectors(HazelcastClientInstanceImpl client) {
        this.inSelector = new InSelectorImpl(client.getThreadGroup(), client.getName() + ".ClientInSelector", Logger.getLogger(InSelectorImpl.class), OUT_OF_MEMORY_HANDLER);
        this.outSelector = new ClientOutSelectorImpl(client.getThreadGroup(), client.getName() + ".ClientOutSelector", Logger.getLogger(ClientOutSelectorImpl.class), OUT_OF_MEMORY_HANDLER);
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            ClientExtension clientExtension = this.client.getClientExtension();
            return clientExtension.createSocketInterceptor();
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public synchronized void start() {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.startSelectors();
        HeartBeat heartBeat = new HeartBeat();
        this.executionService.scheduleWithFixedDelay(heartBeat, this.heartBeatInterval, this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    protected void startSelectors() {
        this.inSelector.start();
        this.outSelector.start();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (ClientConnection connection : this.connections.values()) {
            connection.close();
        }
        this.shutdownSelectors();
        this.connectionLockMap.clear();
        this.connectionListeners.clear();
        this.heartbeatListeners.clear();
    }

    protected void shutdownSelectors() {
        this.inSelector.shutdown();
        this.outSelector.shutdown();
    }

    @Override
    public ClientConnection getConnection(Address target) {
        return (ClientConnection)this.connections.get(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientConnection getOrConnect(Address target, Authenticator authenticator) throws IOException {
        Address remoteAddress = this.addressTranslator.translate(target);
        if (remoteAddress == null) {
            throw new IOException("Address is required!");
        }
        ClientConnection connection = (ClientConnection)this.connections.get(target);
        if (connection == null) {
            Object lock;
            Object object = lock = this.getLock(target);
            synchronized (object) {
                connection = (ClientConnection)this.connections.get(target);
                if (connection == null) {
                    connection = this.initializeConnection(remoteAddress, authenticator);
                }
            }
        }
        return connection;
    }

    private ClientConnection initializeConnection(Address address, Authenticator authenticator) throws IOException {
        ClientConnection connection = this.createSocketConnection(address);
        this.authenticate(authenticator, connection);
        this.connections.put(connection.getRemoteEndpoint(), connection);
        this.fireConnectionAddedEvent(connection);
        return connection;
    }

    @Override
    public ClientConnection getOrTriggerConnect(Address target, Authenticator authenticator) throws IOException {
        Address remoteAddress = this.addressTranslator.translate(target);
        if (remoteAddress == null) {
            throw new IOException("Address is required!");
        }
        ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        ClientConnection connection = (ClientConnection)this.connections.get(target);
        if (connection != null) {
            return connection;
        }
        if (this.connectionsInProgress.add(target)) {
            executionService.executeInternal(new InitConnectionTask(target, remoteAddress, authenticator));
        }
        throw new IOException("No available connection to address " + target);
    }

    private void authenticate(Authenticator authenticator, ClientConnection connection) throws IOException {
        try {
            authenticator.authenticate(connection);
        }
        catch (Throwable throwable) {
            connection.close(throwable);
            throw ExceptionUtil.rethrow((Throwable)throwable, IOException.class);
        }
    }

    private void fireConnectionAddedEvent(ClientConnection connection) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionAdded((Connection)connection);
        }
    }

    protected ClientConnection createSocketConnection(Address address) throws IOException {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!!!");
        }
        SocketChannel socketChannel = null;
        try {
            int bufferSize;
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            socket.setKeepAlive(this.socketOptions.isKeepAlive());
            socket.setTcpNoDelay(this.socketOptions.isTcpNoDelay());
            socket.setReuseAddress(this.socketOptions.isReuseAddress());
            if (this.socketOptions.getLingerSeconds() > 0) {
                socket.setSoLinger(true, this.socketOptions.getLingerSeconds());
            }
            if ((bufferSize = this.socketOptions.getBufferSize() * 1024) <= 0) {
                bufferSize = 32768;
            }
            socket.setSendBufferSize(bufferSize);
            socket.setReceiveBufferSize(bufferSize);
            socketChannel.socket().connect(address.getInetSocketAddress(), this.connectionTimeout);
            SocketChannelWrapper socketChannelWrapper = this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
            ClientConnection clientConnection = new ClientConnection(this.client, this.inSelector, this.outSelector, this.connectionIdGen.incrementAndGet(), socketChannelWrapper);
            socketChannel.configureBlocking(true);
            if (this.socketInterceptor != null) {
                this.socketInterceptor.onConnect(socket);
            }
            socketChannel.configureBlocking(false);
            socket.setSoTimeout(0);
            clientConnection.getReadHandler().register();
            clientConnection.init();
            return clientConnection;
        }
        catch (Exception e) {
            if (socketChannel != null) {
                socketChannel.close();
            }
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
    }

    @Override
    public void destroyConnection(Connection connection) {
        Address endpoint = connection.getEndPoint();
        if (endpoint != null) {
            ClientConnection conn = (ClientConnection)this.connections.remove(endpoint);
            if (conn == null) {
                return;
            }
            conn.close();
            for (ConnectionListener connectionListener : this.connectionListeners) {
                connectionListener.connectionRemoved((Connection)conn);
            }
        } else {
            ClientInvocationService invocationService = this.client.getInvocationService();
            invocationService.cleanConnectionResources((ClientConnection)connection);
        }
    }

    @Override
    public void handlePacket(Packet packet) {
        ClientConnection conn = (ClientConnection)packet.getConn();
        conn.incrementPendingPacketCount();
        if (packet.isHeaderSet(2)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleEventPacket(packet);
        } else {
            ClientInvocationService invocationService = this.client.getInvocationService();
            invocationService.handlePacket(packet);
        }
    }

    private Object getLock(Address address) {
        Object current;
        Object lock = this.connectionLockMap.get(address);
        if (lock == null && (current = this.connectionLockMap.putIfAbsent(address, lock = new Object())) != null) {
            lock = current;
        }
        return lock;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void addConnectionHeartbeatListener(ConnectionHeartbeatListener connectionHeartbeatListener) {
        this.heartbeatListeners.add(connectionHeartbeatListener);
    }

    private class InitConnectionTask
    implements Runnable {
        private final Address target;
        private final Address remoteAddress;
        private final Authenticator authenticator;

        InitConnectionTask(Address target, Address remoteAddress, Authenticator authenticator) {
            this.target = target;
            this.remoteAddress = remoteAddress;
            this.authenticator = authenticator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object lock;
            Object object = lock = ClientConnectionManagerImpl.this.getLock(this.target);
            synchronized (object) {
                ClientConnection connection = (ClientConnection)ClientConnectionManagerImpl.this.connections.get(this.target);
                if (connection != null) {
                    return;
                }
                try {
                    ClientConnectionManagerImpl.this.initializeConnection(this.remoteAddress, this.authenticator);
                }
                catch (IOException e) {
                    LOGGER.finest((Throwable)e);
                }
                finally {
                    ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
                }
            }
        }
    }

    class HeartBeat
    implements Runnable {
        HeartBeat() {
        }

        @Override
        public void run() {
            if (!ClientConnectionManagerImpl.this.alive) {
                return;
            }
            long now = Clock.currentTimeMillis();
            for (ClientConnection connection : ClientConnectionManagerImpl.this.connections.values()) {
                if (now - connection.lastReadTime() > (long)ClientConnectionManagerImpl.this.heartBeatTimeout && connection.isHeartBeating()) {
                    connection.heartBeatingFailed();
                    this.fireHeartBeatStopped(connection);
                }
                if (now - connection.lastReadTime() > (long)ClientConnectionManagerImpl.this.heartBeatInterval) {
                    ClientPingRequest request = new ClientPingRequest();
                    new ClientInvocation(ClientConnectionManagerImpl.this.client, (ClientRequest)request, connection).invoke();
                    continue;
                }
                if (connection.isHeartBeating()) continue;
                connection.heartBeatingSucceed();
                this.fireHeartBeatStarted(connection);
            }
        }

        private void fireHeartBeatStarted(ClientConnection connection) {
            for (ConnectionHeartbeatListener heartbeatListener : ClientConnectionManagerImpl.this.heartbeatListeners) {
                heartbeatListener.heartBeatStarted(connection);
            }
        }

        private void fireHeartBeatStopped(ClientConnection connection) {
            for (ConnectionHeartbeatListener heartbeatListener : ClientConnectionManagerImpl.this.heartbeatListeners) {
                heartbeatListener.heartBeatStopped(connection);
            }
        }
    }
}

